<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">

    
    <title id="app-title"><?php echo e(config('app.name', 'Stackvault')); ?> | Login</title>

    
    <link id="app-favicon" rel="shortcut icon" href="<?php echo e(asset('images/favicon.png')); ?>" type="image/x-icon">

    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">

    
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <link href="<?php echo e(asset('build/assets/built.css')); ?>" rel="stylesheet" />
    <script src="https://unpkg.com/lucide@latest"></script>
    <script src="<?php echo e(asset('build/assets/app2.js')); ?>"></script>

    <style>
        body { font-family: 'Inter', sans-serif; }

        /* Dynamic Brand Color Default (Indigo) */
        :root {
            --brand-primary: #4f46e5;
            --brand-hover: #4338ca;
        }

        /* Utility classes to use the variable */
        .text-primary-brand { color: var(--brand-primary); }
        .bg-primary-brand { background-color: var(--brand-primary); }
        .bg-primary-brand:hover { background-color: var(--brand-hover); }
        .ring-primary-brand:focus { --tw-ring-color: var(--brand-primary); }
        .border-primary-brand:focus { border-color: var(--brand-primary); }
    </style>
</head>
<body class="min-h-screen flex items-center justify-center bg-[#d6d6d6] font-sans antialiased p-4">

    
    <div class="w-full max-w-md bg-white rounded-2xl shadow-[0_8px_30px_rgb(0,0,0,0.04)] border border-gray-100 p-8 sm:p-10">
        <form method="POST" action="<?php echo e(route('login')); ?>">
            <?php echo csrf_field(); ?>

            
            <a href="<?php echo e(env('WEBSITE_URL')); ?>" class="block text-center mb-8">
                <img id="login-logo"
                     src="<?php echo e(asset('images/logo-v2.png')); ?>"
                     alt="Logo"
                     class="mx-auto h-12 w-auto object-contain transition-all duration-300">
            </a>

            <div class="text-center mb-8">
                <h2 class="text-2xl font-bold text-slate-900">Welcome Back</h2>
                <p class="text-sm text-slate-500 font-medium mt-1">Sign in to your dashboard</p>
            </div>

            <?php if(session('deactivated')): ?>
                <div class="bg-red-50 border border-red-100 text-red-600 text-sm font-medium p-3 rounded-xl mb-6 text-center">
                    <?php echo e(session('deactivated')); ?>

                </div>
            <?php endif; ?>

            <div class="space-y-5">
                
                <div>
                    <label for="email" class="block text-sm font-semibold text-slate-700 mb-1.5">Email Address</label>
                    <?php if (isset($component)) { $__componentOriginal18c21970322f9e5c938bc954620c12bb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal18c21970322f9e5c938bc954620c12bb = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.text-input','data' => ['id' => 'email','placeholder' => 'example@mail.com','class' => 'block w-full rounded-xl border border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 placeholder-gray-400 focus:bg-white focus:border-primary-brand focus:ring-primary-brand ring-primary-brand border-primary-brand transition-all shadow-sm','type' => 'email','name' => 'email','value' => old('email'),'required' => true,'autofocus' => true,'autocomplete' => 'username']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('text-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'email','placeholder' => 'example@mail.com','class' => 'block w-full rounded-xl border border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 placeholder-gray-400 focus:bg-white focus:border-primary-brand focus:ring-primary-brand ring-primary-brand border-primary-brand transition-all shadow-sm','type' => 'email','name' => 'email','value' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute(old('email')),'required' => true,'autofocus' => true,'autocomplete' => 'username']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal18c21970322f9e5c938bc954620c12bb)): ?>
<?php $attributes = $__attributesOriginal18c21970322f9e5c938bc954620c12bb; ?>
<?php unset($__attributesOriginal18c21970322f9e5c938bc954620c12bb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal18c21970322f9e5c938bc954620c12bb)): ?>
<?php $component = $__componentOriginal18c21970322f9e5c938bc954620c12bb; ?>
<?php unset($__componentOriginal18c21970322f9e5c938bc954620c12bb); ?>
<?php endif; ?>
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('email'),'class' => 'mt-2 text-red-500 text-xs']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('email')),'class' => 'mt-2 text-red-500 text-xs']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>

                
                <div>
                    <div class="flex items-center justify-between mb-1.5">
                        <label for="password" class="block text-sm font-semibold text-slate-700">Password</label>
                    </div>

                    <div class="relative">
                        <?php if (isset($component)) { $__componentOriginal18c21970322f9e5c938bc954620c12bb = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal18c21970322f9e5c938bc954620c12bb = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.text-input','data' => ['id' => 'password','placeholder' => '••••••••','class' => 'block w-full rounded-xl border border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 placeholder-gray-400 focus:bg-white focus:border-primary-brand focus:ring-primary-brand ring-primary-brand border-primary-brand transition-all shadow-sm pr-12','type' => 'password','name' => 'password','required' => true,'autocomplete' => 'current-password']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('text-input'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'password','placeholder' => '••••••••','class' => 'block w-full rounded-xl border border-gray-200 bg-gray-50 p-3.5 text-sm text-slate-900 placeholder-gray-400 focus:bg-white focus:border-primary-brand focus:ring-primary-brand ring-primary-brand border-primary-brand transition-all shadow-sm pr-12','type' => 'password','name' => 'password','required' => true,'autocomplete' => 'current-password']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal18c21970322f9e5c938bc954620c12bb)): ?>
<?php $attributes = $__attributesOriginal18c21970322f9e5c938bc954620c12bb; ?>
<?php unset($__attributesOriginal18c21970322f9e5c938bc954620c12bb); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal18c21970322f9e5c938bc954620c12bb)): ?>
<?php $component = $__componentOriginal18c21970322f9e5c938bc954620c12bb; ?>
<?php unset($__componentOriginal18c21970322f9e5c938bc954620c12bb); ?>
<?php endif; ?>

                        <button type="button" id="togglePassword" class="absolute inset-y-0 right-0 pr-3.5 flex items-center text-gray-400 hover:text-gray-600 focus:outline-none transition-colors">
                            <i data-lucide="eye" class="w-5 h-5"></i>
                        </button>
                    </div>
                    <?php if (isset($component)) { $__componentOriginalf94ed9c5393ef72725d159fe01139746 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalf94ed9c5393ef72725d159fe01139746 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.input-error','data' => ['messages' => $errors->get('password'),'class' => 'mt-2 text-red-500 text-xs']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('input-error'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['messages' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($errors->get('password')),'class' => 'mt-2 text-red-500 text-xs']); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $attributes = $__attributesOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__attributesOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalf94ed9c5393ef72725d159fe01139746)): ?>
<?php $component = $__componentOriginalf94ed9c5393ef72725d159fe01139746; ?>
<?php unset($__componentOriginalf94ed9c5393ef72725d159fe01139746); ?>
<?php endif; ?>
                </div>
            </div>

            
            <div class="flex items-center justify-between mt-6 mb-8">
                <label for="remember_me" class="inline-flex items-center cursor-pointer">
                    <input id="remember_me" type="checkbox"
                           class="rounded border-gray-300 text-primary-brand shadow-sm focus:ring-primary-brand cursor-pointer" name="remember">
                    <span class="ml-2 text-sm text-slate-500 font-medium"><?php echo e(__('Remember me')); ?></span>
                </label>

                <?php if(Route::has('password.request')): ?>
                    <a class="text-sm font-semibold text-primary-brand hover:brightness-110 transition-colors" href="<?php echo e(route('password.request')); ?>">
                        <?php echo e(__('Forgot password?')); ?>

                    </a>
                <?php endif; ?>
            </div>

            
            <button type="submit" class="w-full text-white bg-primary-brand hover:brightness-110 focus:ring-4 focus:ring-opacity-30 font-bold py-3.5 px-4 rounded-xl transition-all duration-200 shadow-lg shadow-indigo-500/20">
                <?php echo e(__('Log in')); ?>

            </button>

            
            <div class="mt-8 text-center space-y-4">
                <p class="text-sm text-slate-500">
                    Don't have an account? <a href="./register" class="font-bold text-primary-brand hover:brightness-110">Sign Up</a>
                </p>
                <a href="<?php echo e(env('WEBSITE_URL')); ?>" class="block text-xs text-gray-400 hover:text-gray-600 transition-colors">Return Home</a>
            </div>
        </form>
    </div>

    <script>
        // --- 1. DYNAMIC BRANDING LOGIC ---
        async function fetchPersona() {
            try {
                const response = await fetch('/api/persona/active');
                if (!response.ok) throw new Error('Failed to fetch');
                const data = await response.json();

                // Update Title
                document.title = `${data.name} | Login`;

                // Update Logo
                const logoImg = document.getElementById('login-logo');
                if (logoImg) {
                    // Use full logo (with text) for light mode if available
                    logoImg.src = data.logo_full_url || data.logo_url;
                    logoImg.alt = data.name;
                }

                // Update Favicon
                const favicon = document.getElementById('app-favicon');
                if (favicon && data.logo_url) favicon.href = data.logo_url;

                // Update Dynamic Brand Color (CSS Variable)
                if (data.colors && data.colors.primary) {
                    document.documentElement.style.setProperty('--brand-primary', data.colors.primary);
                    // Simple logic to create a hover state (darkening slightly not possible easily with just hex vars in vanilla css without calc,
                    // so we rely on brightness filter in the tailwind class `hover:brightness-110` or similar logic).
                }

            } catch (e) { console.warn('Branding load failed', e); }
        }

        // --- 2. PASSWORD TOGGLE LOGIC (Lucide) ---
        const passwordInput = document.getElementById('password');
        const togglePasswordBtn = document.getElementById('togglePassword');

        togglePasswordBtn.addEventListener('click', () => {
            const icon = togglePasswordBtn.querySelector('i');

            if (passwordInput.type === 'password') {
                passwordInput.type = 'text';
                icon.setAttribute('data-lucide', 'eye-off');
            } else {
                passwordInput.type = 'password';
                icon.setAttribute('data-lucide', 'eye');
            }
            lucide.createIcons();
        });

        document.addEventListener('DOMContentLoaded', () => {
            fetchPersona();
            lucide.createIcons();
        });
    </script>
</body>
</html>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/auth/login.blade.php ENDPATH**/ ?>