<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <section class="py-8 antialiased md:py-16">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-5xl">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10">Deposit</h1>

                <div class="mt-6 sm:mt-8">
                    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                        <div class="flex items-center justify-between border-b border-gray-700 pb-4 mb-4">
                            <h4 class="text-lg font-semibold text-white">Payment Guide</h4>
                        </div>
                        <div class="text-gray-400">
                            Make payment to the account details below, using the payment ID:
                            <span class="text-xl font-bold text-white"><?php echo e($transactionId); ?></span> as your description.
                            Then click on "I have made Payment" and the admin will verify the payment and send it to your wallet.
                        </div>
                    </div>
                </div>

                <?php if($errors->any()): ?>
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-[#131319] dark:text-red-400" role="alert">
                        <span class="font-medium">Please correct the following errors:</span>
                        <ul class="mt-1.5 list-disc list-inside">
                            <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li><?php echo e($error); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>
                <?php endif; ?>

                <div class="mt-6 sm:mt-8 lg:flex lg:items-start lg:gap-12">
                    <form action="" method="POST" class="w-full rounded-lg border border-gray-700 bg-[#131319] p-4 shadow-sm sm:p-6 lg:p-8">
                        <?php echo csrf_field(); ?>
                        <div class="mb-6 grid grid-cols-1 md:grid-cols-2 gap-4">
                            
                            <div class="col-span-1 md:col-span-2">
                                <label for="wallet_option" class="mb-2 block text-sm font-medium text-gray-400">
                                    Wallet*
                                </label>
                                <select id="wallet_option" name="wallet_coin_id"
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500 required">
                                    <?php $__currentLoopData = $payment_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($option->id); ?>" data-value="<?php echo e($option->value); ?>" data-account-details="<?php echo e($option->account_details); ?>" data-name="<?php echo e($option->name); ?>" data-code="<?php echo e($option->code); ?>"
                                            <?php if($option->code === 'USD'): ?> selected <?php endif; ?>
                                            class="capitalize"><?php echo e($option->name); ?> (<?php echo e($option->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            
                            <div class="col-span-1 md:col-span-2">
                                <label for="payment_option" class="mb-2 block text-sm font-medium text-gray-400">
                                    Payment Option*
                                </label>
                                <select id="payment_option" name="payment_option_id"
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500 required">
                                    <?php $__currentLoopData = $payment_options; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $option): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($option->id); ?>" data-value="<?php echo e($option->value); ?>" data-account-details="<?php echo e($option->account_details); ?>" data-name="<?php echo e($option->name); ?>" data-code="<?php echo e($option->code); ?>"
                                            <?php if($option->code === 'BTC'): ?> selected <?php endif; ?>
                                            class="capitalize"><?php echo e($option->name); ?> (<?php echo e($option->code); ?>)</option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>

                            
                            <div class="col-span-1 md:col-span-2">
                                <label class="mb-2 block text-sm font-medium text-gray-400">
                                    Input Mode
                                </label>
                                <div class="flex bg-gray-700 rounded-lg p-1 border border-gray-600">
                                    <button type="button" id="usd-toggle" class="toggle-button flex-1 py-2 px-4 rounded-md text-sm font-medium transition-colors duration-200 bg-primary-600 text-white">
                                        Enter USD Amount
                                    </button>
                                    <button type="button" id="wallet-toggle" class="toggle-button flex-1 py-2 px-4 rounded-md text-sm font-medium transition-colors duration-200 text-gray-300 hover:text-white">
                                        Enter <span id="wallet-toggle-label">USD</span> Amount
                                    </button>
                                </div>
                            </div>

                            
                            <div class="col-span-1 md:col-span-2">
                                <label for="amount_input" class="mb-2 block text-sm font-medium text-gray-400">
                                    <span id="amount-input-label">Enter USD Amount*</span>
                                </label>
                                <input type="number" step="any" id="amount_input"
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder:text-gray-400 focus:border-primary-500 focus:ring-primary-500"
                                    placeholder="Enter Amount" required />
                            </div>

                            
                            <div id="conversion-display" class="col-span-1 md:col-span-2">
                                <div class="bg-gray-700 rounded-lg p-4 border border-gray-600">
                                    <div class="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
                                        <div>
                                            <span class="text-gray-400">Wallet Amount:</span>
                                            <div id="wallet-amount-display" class="text-white font-semibold text-lg">0 USD</div>
                                        </div>
                                        <div>
                                            <span class="text-gray-400">Payment Amount:</span>
                                            <div id="payment-amount-display" class="text-white font-semibold text-lg">0 BTC</div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="mt-4 text-center">
                            <div class="bg-gray-700 rounded-lg p-3 border border-gray-600">
                                <span id="usd-equivalent-display" class="text-white text-lg font-medium">USD Equivalent: $0.00</span>
                            </div>
                        </div>

                        
                        <div class="mt-6 sm:mt-8">
                            <div class="bg-gray-700 rounded-lg p-6 border border-gray-600 text-center">
                                <?php
                                    $defaultPaymentOption = $payment_options->firstWhere('code', 'BTC');
                                    $defaultAccountDetails = $defaultPaymentOption ? $defaultPaymentOption->account_details : 'No account details available.';
                                ?>
                                <div class="text-gray-300">Your address for refill <span id="account-code-display" class="font-semibold">BTC</span></div>
                                <div id="account-details" class="text-white mt-2 text-lg font-medium break-all">
                                    <?php echo e($defaultAccountDetails); ?>

                                </div>
                                <button type="button" id="request_bank_details_btn" class="hidden mt-4 px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-medium">Request Account Details</button>
                            </div>
                        </div>

                        <input type="hidden" id="transaction_id" name="transaction_id" value="<?php echo e($transactionId); ?>" required />
                        <input type="hidden" id="type" name="type" value="deposit" required />
                        
                        <input type="hidden" id="submitted_amount" name="amount_coin" />
                        
                        <input type="hidden" id="submitted_payment_option_id" name="payment_option_id" />
                        
                        <input type="hidden" id="submitted_usd_amount" name="amount" />

                        <button type="submit" class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-300 font-bold py-3 px-4 rounded-lg mt-6 transition-colors duration-200">
                            <?php echo e(__('I have made Payment')); ?>

                        </button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <script>
        const walletSelect = document.getElementById('wallet_option');
        const paymentSelect = document.getElementById('payment_option');
        const accountDetailsDiv = document.getElementById('account-details');
        const accountCodeDisplay = document.getElementById('account-code-display');
        const requestBankDetailsBtn = document.getElementById('request_bank_details_btn');
        const submittedAmountInput = document.getElementById('submitted_amount');
        const submittedPaymentOptionId = document.getElementById('submitted_payment_option_id');
        const submittedUsdAmountInput = document.getElementById('submitted_usd_amount');
        const usdEquivalentDisplay = document.getElementById('usd-equivalent-display');
        const usdToggle = document.getElementById('usd-toggle');
        const walletToggle = document.getElementById('wallet-toggle');
        const walletToggleLabel = document.getElementById('wallet-toggle-label');
        const amountInputLabel = document.getElementById('amount-input-label');
        const amountInput = document.getElementById('amount_input');
        const walletAmountDisplay = document.getElementById('wallet-amount-display');
        const paymentAmountDisplay = document.getElementById('payment-amount-display');

        let inputMode = 'usd';

        function getSelectedOptionData(selectElement) {
            const selectedOption = selectElement.options[selectElement.selectedIndex];
            return {
                id: selectedOption.value,
                value: parseFloat(selectedOption.dataset.value),
                code: selectedOption.dataset.code,
                name: selectedOption.dataset.name,
                account_details: selectedOption.dataset.accountDetails
            };
        }

        function setInputMode(mode) {
            inputMode = mode;
            const selectedWallet = getSelectedOptionData(walletSelect);

            if (mode === 'usd') {
                usdToggle.classList.add('bg-primary-600', 'text-white');
                usdToggle.classList.remove('text-gray-300', 'hover:text-white');
                walletToggle.classList.remove('bg-primary-600', 'text-white');
                walletToggle.classList.add('text-gray-300', 'hover:text-white');
                amountInputLabel.textContent = 'Enter USD Amount*';
                amountInput.placeholder = 'Enter USD amount';
            } else {
                walletToggle.classList.add('bg-primary-600', 'text-white');
                walletToggle.classList.remove('text-gray-300', 'hover:text-white');
                usdToggle.classList.remove('bg-primary-600', 'text-white');
                usdToggle.classList.add('text-gray-300', 'hover:text-white');
                amountInputLabel.textContent = `Enter ${selectedWallet.code} Amount*`;
                amountInput.placeholder = `Enter ${selectedWallet.code} amount`;
            }
            calculateAmounts();
        }

        function calculateAmounts() {
            const selectedWallet = getSelectedOptionData(walletSelect);
            const selectedPayment = getSelectedOptionData(paymentSelect);
            const inputAmount = parseFloat(amountInput.value) || 0;

            let walletAmount, paymentAmount, usdAmount;

            if (inputMode === 'usd') {
                usdAmount = inputAmount;
                walletAmount = selectedWallet.value > 0 ? usdAmount / selectedWallet.value : 0;
                paymentAmount = selectedPayment.value > 0 ? usdAmount / selectedPayment.value : 0;
            } else {
                walletAmount = inputAmount;
                usdAmount = walletAmount * selectedWallet.value;
                paymentAmount = selectedPayment.value > 0 ? usdAmount / selectedPayment.value : 0;
            }

            walletAmountDisplay.textContent = `${walletAmount.toFixed(8)} ${selectedWallet.code}`;
            paymentAmountDisplay.textContent = `${paymentAmount.toFixed(8)} ${selectedPayment.code}`;
            usdEquivalentDisplay.textContent = `USD Equivalent: $${usdAmount.toFixed(2)}`;

            submittedAmountInput.value = paymentAmount.toFixed(8);
            submittedPaymentOptionId.value = selectedPayment.id;
            submittedUsdAmountInput.value = usdAmount.toFixed(2);
        }

        function updateUI() {
            const selectedPayment = getSelectedOptionData(paymentSelect);
            const selectedWallet = getSelectedOptionData(walletSelect);

            accountCodeDisplay.textContent = selectedPayment.code;
            accountDetailsDiv.textContent = selectedPayment.account_details;
            if (selectedPayment.name.toLowerCase() === 'bank transfer') {
                accountDetailsDiv.textContent = 'Click "Request Account Details" below.';
                requestBankDetailsBtn.classList.remove('hidden');
            } else {
                requestBankDetailsBtn.classList.add('hidden');
            }

            walletToggleLabel.textContent = selectedWallet.code;
            console.log(walletToggleLabel.textContent);

            calculateAmounts();
        }

        usdToggle.addEventListener('click', () => setInputMode('usd'));
        walletToggle.addEventListener('click', () => setInputMode('wallet'));
        walletSelect.addEventListener('change', updateUI);
        paymentSelect.addEventListener('change', updateUI);
        amountInput.addEventListener('input', calculateAmounts);

        if (requestBankDetailsBtn) {
            requestBankDetailsBtn.addEventListener('click', (event) => {
                event.preventDefault();
                alert('Bank account details requested. Please check your email or dashboard for updates.');
            });
        }

        const modal = document.getElementById('success-alert-modal');
        if (modal) {
            document.addEventListener('DOMContentLoaded', () => {
                modal.classList.remove('hidden');
            });
        }

        document.addEventListener('DOMContentLoaded', () => {
            updateUI();
        });
    </script>

    <?php if(session('success')): ?>
    <div id="success-alert-modal" class="fixed inset-0 bg-[#000] bg-opacity-75 flex items-center justify-center z-50 p-4" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
            <div class="text-center text-white mb-6">
                <svg class="mx-auto h-16 w-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                </svg>
                <?php if(session('success') === 'Deposit request made successfully!'): ?>
                    <h2 class="mt-4 text-3xl font-bold">Request Sent!</h2>
                    <p class="mt-2">Below is your transaction ID:</p>
                    <p class="mt-2 text-2xl font-semibold"><?php echo e(session('transaction_id')); ?></p>
                    <p class="mt-3 text-sm">You will receive an email shortly with the account details for the bank transfer. Once the transfer is made, your wallet will be credited.</p>
                <?php else: ?>
                    <h2 class="mt-4 text-3xl font-bold">Well Done!</h2>
                    <p class="mt-2">Your transaction ID:</p>
                    <p class="mt-2 text-2xl font-semibold"><?php echo e(session('transaction_id')); ?></p>
                    <p class="mt-3 text-sm">Your deposit has been logged and will be added to your wallet once it is confirmed.</p>
                <?php endif; ?>
            </div>
            <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                <button type="button" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200" onclick="document.getElementById('success-alert-modal').classList.add('hidden');">
                    Deposit Again
                </button>
                <a href="/wallet" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg text-center transition-colors duration-200">
                    Go To Wallet
                </a>
            </div>
        </div>
    </div>
    <?php endif; ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/deposit.blade.php ENDPATH**/ ?>