<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    
    <div class="grid grid-cols-1 md:grid-cols-3 lg:grid-cols-5 gap-1 h-full md:max-h-[90vh] relative">

        
        <div id="mobile-detail-header" class="hidden md:hidden fixed top-16 left-0 right-0 z-40 bg-[#131319] border-b border-gray-700 shadow-lg px-4 py-3">
            <div class="flex items-center justify-between mb-3">
                <button id="mobile-back-btn" class="flex items-center text-gray-400 hover:text-white">
                    <svg class="w-6 h-6 mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
                    <span class="text-sm font-medium">Markets</span>
                </button>
                <div class="text-center">
                    <h3 id="mobile-header-symbol" class="text-white font-bold text-lg leading-tight">--</h3>
                    <p id="mobile-header-price" class="text-xs text-blue-400 font-mono">--</p>
                </div>
                <div class="w-16"></div>
            </div>

            <div class="grid grid-cols-2 bg-gray-800 rounded-lg p-1">
                <button id="mob-tab-chart" class="py-1.5 text-sm font-medium rounded-md bg-gray-600 text-white shadow-sm transition-all">Chart</button>
                <button id="mob-tab-trade" class="py-1.5 text-sm font-medium rounded-md text-gray-400 hover:text-white transition-all">Trade</button>
            </div>
        </div>

        
        <div id="stock-list-panel" class="col-span-full md:col-span-1 bg-[#131319] rounded-lg shadow-md pt-0 p-4 flex flex-col h-screen md:max-h-[90vh] pb-24 md:pb-4">
            <div class="sticky top-0 bg-[#131319] pb-4 z-10 pt-2">
                <h2 class="text-xl font-bold text-white">Markets</h2>
                <p class="text-gray-400 text-sm mb-2 pb-2">Select Asset to begin trading</p>
                <input type="text" id="search-input" class="w-full rounded-lg p-2 text-gray-800 bg-gray-100 border-none focus:ring-2 focus:ring-blue-500" placeholder="Search...">
                <div class="mt-2">
                    <select id="market-filter" class="w-full rounded-lg p-2 text-gray-800 bg-gray-100 border-none">
                        <option value="all">All Markets</option>
                        <option value="usd">NYSE</option>
                        <option value="gbx">LSE</option>
                        <option value="forex">Forex</option>
                    </select>
                </div>
            </div>

            <div id="stock-list" class="flex-1 overflow-y-auto custom-scrollbar border-t border-gray-700">
                
                <?php $__currentLoopData = $stocks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $stock): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="stock-item p-3 border-b border-gray-800 cursor-pointer hover:bg-gray-800 transition-colors"
                    data-asset-type="stock"
                    data-stock-id="<?php echo e($stock->id); ?>"
                    data-stock-code="<?php echo e($stock->code); ?>"
                    data-tradingview-code="<?php echo e($stock->tradingview_code); ?>"
                    data-market="<?php echo e($stock->market); ?>">
                        <div class="flex items-center justify-between">
                            <div>
                                <span class="block text-base font-bold text-white"><?php echo e($stock->code); ?></span>
                                <span class="block text-xs text-gray-500"><?php echo e(Str::limit($stock->name, 20)); ?></span>
                            </div>
                            <div class="text-right">
                                <span class="block text-sm font-semibold text-white">$<?php echo e(number_format($stock->value, 2)); ?></span>
                                <span class="block text-xs <?php echo e(($stock->wallet->claimed ?? 0) > 0 ? 'text-green-400' : 'text-gray-600'); ?>">
                                    <?php echo e($stock->wallet->claimed ?? 0); ?> Shares
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
                <?php $__currentLoopData = $forexPairs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $pair): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="stock-item p-3 border-b border-gray-800 cursor-pointer hover:bg-gray-800 transition-colors"
                    data-asset-type="forex"
                    data-stock-id="<?php echo e($pair->id); ?>"
                    data-stock-code="<?php echo e($pair->symbol); ?>"
                    data-tradingview-code="<?php echo e($pair->tradingview_code); ?>"
                    data-market="forex"
                    data-leverage="<?php echo e($pair->leverage); ?>">
                        <div class="flex items-center justify-between">
                            <div>
                                <span class="block text-base font-bold text-white"><?php echo e($pair->symbol); ?></span>
                                <span class="block text-xs text-gray-500"><?php echo e(Str::limit($pair->name, 20)); ?></span>
                            </div>
                            <div class="text-right">
                                <span class="block text-sm font-semibold text-white"><?php echo e(number_format($pair->exchange_rate, 4)); ?></span>
                                <span class="block text-xs <?php echo e(($pair->wallet->balance ?? 0) > 0 ? 'text-green-400' : 'text-gray-600'); ?>">
                                    <?php echo e(number_format($pair->wallet->balance ?? 0, 2)); ?> Units
                                </span>
                            </div>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>

        
        <div id="chart-panel" class="col-span-full md:col-span-2 lg:col-span-3 bg-[#131319] rounded-lg shadow-md p-4 overflow-y-auto custom-scrollbar h-full hidden md:block pt-32 md:pt-4">
            <h2 id="chart-title" class="text-xl font-bold mb-4 text-white hidden md:block">General Market Overview</h2>

            <div class="h-[300px] md:h-[450px] w-full">
                <div id="tradingview-chart-container" class="h-full w-full bg-black rounded-lg overflow-hidden"></div>
            </div>

            <div id="stock-details" class="mt-6 hidden">
                <h3 class="text-xl font-bold text-white mb-4 px-1">Market Data</h3>
                <div class="grid grid-cols-2 md:grid-cols-3 gap-3">
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">Open</p>
                        <p id="details-open" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">Prev Close</p>
                        <p id="details-close" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">High</p>
                        <p id="details-high" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">Low</p>
                        <p id="details-low" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">52W High</p>
                        <p id="details-52wh" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                    <div class="bg-gray-800 p-3 rounded-lg border border-gray-700">
                        <p class="text-gray-400 text-xs uppercase">52W Low</p>
                        <p id="details-52wl" class="text-white text-base font-mono font-semibold">-</p>
                    </div>
                </div>
            </div>
        </div>

        
        <div id="trading-panel" class="col-span-full md:col-span-1 xlg:col-span-2 bg-[#131319] rounded-lg shadow-md p-4 overflow-y-auto custom-scrollbar h-full hidden md:block pt-32 md:pt-4">
            <h2 class="text-xl font-bold mb-4 text-white hidden md:block">Trade</h2>

            <div id="trading-component" class="hidden">
                
                <?php echo $__env->make('components.trading-component', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <input type="hidden" id="data_stock_id">
                <input type="hidden" id="data_market">
                <input type="hidden" id="data_ask">
                <input type="hidden" id="data_bid">

                
                <div id="leverage-container" class="mt-4 mb-4 hidden bg-gray-800 p-3 rounded border border-gray-700">
                    <label class="block text-gray-400 text-sm mb-2">Leverage</label>
                    <select id="leverage-input" class="w-full bg-gray-700 text-white rounded p-2 text-sm border border-gray-600 focus:border-blue-500">
                        <option value="1">1:1 (No Leverage)</option>
                        <option value="50">1:50</option>
                        <option value="100" selected>1:100</option>
                        <option value="500">1:500</option>
                    </select>
                </div>

                <div class="mt-4 p-3 bg-gray-800 rounded border border-gray-700">
                    <div class="flex justify-between items-center text-sm text-gray-400">
                        <span id="cost-label">Estimated Total:</span>
                        <span id="estimated-total" class="text-xl font-bold text-blue-400">$0.00</span>
                    </div>
                </div>

                
                <div class="tradingview-widget-container mt-6 w-full hidden md:block">
                    <div class="tradingview-widget-container__widget"></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-market-overview.js" async>
                        { "colorTheme": "dark", "dateRange": "12M", "locale": "en", "width": "100%", "height": "400", "isTransparent": true, "tabs": [{ "title": "Indices", "symbols": [{ "s": "FOREXCOM:SPXUSD" }, { "s": "FOREXCOM:NSXUSD" }] }] }
                    </script>
                </div>
            </div>

            <div id="select-stock-prompt" class="p-10 text-center text-gray-500 flex flex-col items-center justify-center h-full">
                <svg class="w-16 h-16 mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"></path></svg>
                <p>Select an asset from the list.</p>
            </div>
        </div>
    </div>

    
    <div id="message-popup" class="hidden fixed inset-0 bg-black bg-opacity-80 z-[100] flex items-center justify-center p-4">
        <div class="bg-[#1e1e24] p-6 rounded-lg shadow-2xl max-w-sm w-full mx-4 border border-gray-600 relative">
            <div class="flex items-center justify-between mb-4">
                <h3 id="popup-title" class="text-xl font-bold text-white">Message</h3>
                <button id="close-popup" class="text-gray-400 hover:text-white transition-colors">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
                </button>
            </div>
            <p id="popup-message" class="text-gray-300 mb-6 leading-relaxed">--</p>
            <div class="flex justify-end">
                <button id="ok-popup" class="px-5 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-500 transition-colors font-medium">OK</button>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script src="https://s3.tradingview.com/tv.js"></script>
    <script>
        // --- 1. GLOBAL VARIABLES ---
        let currentWidget = null;
        let currentOrderSide = 'buy';
        let currentUnit = 'shares';
        let currentOrderType = 'limit';
        let currentTIF = 'day';
        let selectedStock = null;
        let currentAssetType = 'stock';

        let userBalance = <?php echo e(auth()->user()->wallet->balance ?? 0); ?>;

        // --- DOM REFERENCES (Will be populated in DOMContentLoaded) ---
        let leverageContainer, leverageInput, costLabel;
        let sharesQuantityInput, fiatQuantityInput, limitPriceInput, stopPriceInput;
        let limitFields, marketFields, stopFields; // Field containers
        let limitBtn, marketBtn, stopBtn; // Order Type Buttons
        let tifDayBtn, tifGtcBtn, marketTifDayBtn, marketTifGtcBtn, stopTifDayBtn, stopTifGtcBtn; // TIF Buttons
        let submitOrderBtn, submitText, submitSpinner, messagePopup, popupTitle, popupMessage;
        let unitSharesBtn, unitFiatBtn, buyTab, sellTab;

        const usdFormatter = new Intl.NumberFormat('en-US', { style: 'currency', currency: 'USD' });

        // --- HELPER FUNCTIONS ---
        function showMessage(type, title, message) {
            popupTitle.textContent = title;
            popupMessage.textContent = message;
            popupTitle.className = type === 'success' ? 'text-xl font-bold mb-2 text-green-500' : 'text-xl font-bold mb-2 text-red-500';
            messagePopup.classList.remove('hidden');
            messagePopup.classList.add('flex');
        }

        // --- UI TOGGLING FUNCTIONS (Restored Logic) ---

        // 1. Switch between Shares vs Units (Forex)
        function toggleInterface(type) {
            if (type === 'forex') {
                if(leverageContainer) leverageContainer.classList.remove('hidden');
                if(costLabel) costLabel.textContent = "Required Margin:";
                if(unitSharesBtn) unitSharesBtn.textContent = "Units";
                if(sharesQuantityInput) sharesQuantityInput.placeholder = "Units (e.g. 1000)";
            } else {
                if(leverageContainer) leverageContainer.classList.add('hidden');
                if(costLabel) costLabel.textContent = "Estimated Cost:";
                if(unitSharesBtn) unitSharesBtn.textContent = "Shares";
                if(sharesQuantityInput) sharesQuantityInput.placeholder = "Quantity";
            }
        }

        // 2. Switch Order Types (Limit/Market/Stop)
        function updateOrderTypeUI() {
            // Reset Buttons
            [limitBtn, marketBtn, stopBtn].forEach(btn => {
                if(btn) {
                    btn.classList.remove('bg-gray-500', 'text-white');
                    btn.classList.add('text-gray-400');
                }
            });

            // Hide Fields
            [limitFields, marketFields, stopFields].forEach(field => {
                if(field) field.classList.add('hidden');
            });

            // Activate Selected
            if (currentOrderType === 'limit') {
                limitBtn.classList.add('bg-gray-500', 'text-white');
                limitFields.classList.remove('hidden');
            } else if (currentOrderType === 'market') {
                marketBtn.classList.add('bg-gray-500', 'text-white');
                marketFields.classList.remove('hidden');
            } else if (currentOrderType === 'stop') {
                stopBtn.classList.add('bg-gray-500', 'text-white');
                stopFields.classList.remove('hidden');
            }
            calculateQuantities();
        }

        // 3. Switch Buy/Sell Tabs
        function updateOrderSideUI() {
            if (currentOrderSide === 'buy') {
                buyTab.classList.replace('bg-gray-700', 'bg-blue-600'); buyTab.classList.replace('text-gray-400', 'text-white');
                sellTab.classList.replace('bg-red-600', 'bg-gray-700'); sellTab.classList.replace('text-white', 'text-gray-400');
                submitOrderBtn.classList.replace('bg-red-600', 'bg-blue-600');
                submitText.textContent = 'Submit Buy Order';
                trading_box_content?.classList.replace('border-red-600', 'border-blue-600');
            } else {
                sellTab.classList.replace('bg-gray-700', 'bg-red-600'); sellTab.classList.replace('text-gray-400', 'text-white');
                buyTab.classList.replace('bg-blue-600', 'bg-gray-700'); buyTab.classList.replace('text-white', 'text-gray-400');
                submitOrderBtn.classList.replace('bg-blue-600', 'bg-red-600');
                submitText.textContent = 'Submit Sell Order';
                trading_box_content?.classList.replace('border-blue-600', 'border-red-600');
            }
            calculateQuantities();
        }

        // 4. Switch Units (Shares vs USD)
        function updateUnitUI() {
            if (currentUnit === 'shares') {
                sharesQuantityInput.classList.remove('hidden');
                fiatQuantityInput.classList.add('hidden');
                unitSharesBtn.classList.add('bg-gray-500', 'text-white');
                unitSharesBtn.classList.remove('text-gray-400');
                unitFiatBtn.classList.add('text-gray-400');
                unitFiatBtn.classList.remove('bg-gray-500', 'text-white');
            } else {
                fiatQuantityInput.classList.remove('hidden');
                sharesQuantityInput.classList.add('hidden');
                unitFiatBtn.classList.add('bg-gray-500', 'text-white');
                unitFiatBtn.classList.remove('text-gray-400');
                unitSharesBtn.classList.add('text-gray-400');
                unitSharesBtn.classList.remove('bg-gray-500', 'text-white');
            }
            calculateQuantities();
        }

        function getCurrentPrice() {
            if (currentOrderType === 'limit') {
                const limitVal = parseFloat(limitPriceInput?.value);
                if (limitVal > 0) return limitVal;
            } else if (currentOrderType === 'stop') {
                const stopVal = parseFloat(stopPriceInput?.value);
                if (stopVal > 0) return stopVal;
            }
            const ask = parseFloat(document.getElementById('data_ask').value) || 0;
            const bid = parseFloat(document.getElementById('data_bid').value) || 0;
            return currentOrderSide === 'buy' ? ask : bid;
        }

        function calculateQuantities() {
            // Only calc if elements exist
            if (!sharesQuantityInput || !fiatQuantityInput) return;

            const price = getCurrentPrice();
            const leverage = currentAssetType === 'forex' ? (parseInt(leverageInput?.value) || 1) : 1;

            // Get active value
            let quantity = 0;
            if (currentUnit === 'shares') {
                quantity = parseFloat(sharesQuantityInput.value) || 0;
            } else {
                // If in Fiat mode, we need to calculate implied shares
                const fiatVal = parseFloat(fiatQuantityInput.value) || 0;
                quantity = price > 0 ? (fiatVal / price) : 0;
            }

            let totalCost = 0;
            if (currentAssetType === 'forex') {
                totalCost = (quantity * price) / leverage;
            } else {
                totalCost = quantity * price;
            }

            const totalDisplay = document.getElementById('estimated-total');
            if(totalDisplay) totalDisplay.textContent = usdFormatter.format(totalCost);
        }

        // --- MOBILE VIEW CONTROLLER ---
        // (Same as before)
        const stockListPanel = document.getElementById('stock-list-panel');
        const chartPanel = document.getElementById('chart-panel');
        const tradingPanel = document.getElementById('trading-panel');
        const mobileHeader = document.getElementById('mobile-detail-header');

        function switchToMobileDetail() {
            if (window.innerWidth < 768) {
                stockListPanel?.classList.add('hidden');
                mobileHeader?.classList.remove('hidden');
                activateMobileTab('chart');
            }
        }
        function switchToMobileList() {
            if (window.innerWidth < 768) {
                stockListPanel?.classList.remove('hidden');
                chartPanel?.classList.add('hidden');
                tradingPanel?.classList.add('hidden');
                mobileHeader?.classList.add('hidden');
            }
        }
        function activateMobileTab(tab) {
            const mobTabChart = document.getElementById('mob-tab-chart');
            const mobTabTrade = document.getElementById('mob-tab-trade');
            if (window.innerWidth >= 768) return;

            if (tab === 'chart') {
                chartPanel.classList.remove('hidden');
                tradingPanel.classList.add('hidden');
                mobTabChart.classList.add('bg-gray-600', 'text-white', 'shadow-sm');
                mobTabChart.classList.remove('text-gray-400');
                mobTabTrade.classList.remove('bg-gray-600', 'text-white', 'shadow-sm');
                mobTabTrade.classList.add('text-gray-400');
            } else {
                chartPanel.classList.add('hidden');
                tradingPanel.classList.remove('hidden');
                mobTabTrade.classList.add('bg-gray-600', 'text-white', 'shadow-sm');
                mobTabTrade.classList.remove('text-gray-400');
                mobTabChart.classList.remove('bg-gray-600', 'text-white', 'shadow-sm');
                mobTabChart.classList.add('text-gray-400');
            }
        }

        document.addEventListener('DOMContentLoaded', function() {
            // --- 1. ELEMENT INITIALIZATION (RE-BINDING) ---
            leverageContainer = document.getElementById('leverage-container');
            leverageInput = document.getElementById('leverage-input');
            costLabel = document.getElementById('cost-label');

            sharesQuantityInput = document.getElementById('shares-quantity-input');
            fiatQuantityInput = document.getElementById('fiat-quantity-input');
            limitPriceInput = document.getElementById('limit-price');
            stopPriceInput = document.getElementById('stop-price');

            limitBtn = document.getElementById('limit-btn');
            marketBtn = document.getElementById('market-btn');
            stopBtn = document.getElementById('stop-btn');

            limitFields = document.getElementById('limit-fields');
            marketFields = document.getElementById('market-fields');
            stopFields = document.getElementById('stop-fields');

            buyTab = document.getElementById('buy-tab');
            sellTab = document.getElementById('sell-tab');
            unitSharesBtn = document.getElementById('unit-shares');
            unitFiatBtn = document.getElementById('unit-fiat');
            trading_box_content = document.getElementById('trading_box_content');

            submitOrderBtn = document.getElementById('submit-order');
            submitText = document.getElementById('submit-text');
            submitSpinner = document.getElementById('submit-spinner');

            messagePopup = document.getElementById('message-popup');
            popupTitle = document.getElementById('popup-title');
            popupMessage = document.getElementById('popup-message');
            const closePopupBtn = document.getElementById('close-popup');
            const okPopupBtn = document.getElementById('ok-popup');

            // --- 2. RESTORING EVENT LISTENERS ---

            // Buy / Sell Tabs
            if(buyTab) buyTab.addEventListener('click', () => { currentOrderSide = 'buy'; updateOrderSideUI(); });
            if(sellTab) sellTab.addEventListener('click', () => { currentOrderSide = 'sell'; updateOrderSideUI(); });

            // Unit Toggles
            if(unitSharesBtn) unitSharesBtn.addEventListener('click', () => { currentUnit = 'shares'; updateUnitUI(); });
            if(unitFiatBtn) unitFiatBtn.addEventListener('click', () => { currentUnit = 'fiat'; updateUnitUI(); });

            // Order Type Toggles
            if(limitBtn) limitBtn.addEventListener('click', () => { currentOrderType = 'limit'; updateOrderTypeUI(); });
            if(marketBtn) marketBtn.addEventListener('click', () => { currentOrderType = 'market'; updateOrderTypeUI(); });
            if(stopBtn) stopBtn.addEventListener('click', () => { currentOrderType = 'stop'; updateOrderTypeUI(); });

            // Calculation Triggers
            if(leverageInput) leverageInput.addEventListener('change', calculateQuantities);
            if(sharesQuantityInput) sharesQuantityInput.addEventListener('input', calculateQuantities);
            if(fiatQuantityInput) fiatQuantityInput.addEventListener('input', calculateQuantities);
            if(limitPriceInput) limitPriceInput.addEventListener('input', calculateQuantities);

            // --- 3. EXISTING LOGIC (Asset Selection, Mobile, Chart) ---
            const stockItems = document.querySelectorAll('.stock-item');
            const searchInput = document.getElementById('search-input');
            const marketFilter = document.getElementById('market-filter');
            const mobileBackBtn = document.getElementById('mobile-back-btn');
            const mobTabChart = document.getElementById('mob-tab-chart');
            const mobTabTrade = document.getElementById('mob-tab-trade');

            if(mobileBackBtn) mobileBackBtn.addEventListener('click', switchToMobileList);
            if(mobTabChart) mobTabChart.addEventListener('click', () => activateMobileTab('chart'));
            if(mobTabTrade) mobTabTrade.addEventListener('click', () => activateMobileTab('trade'));

            stockItems.forEach(item => {
                item.addEventListener('click', function() {
                    stockItems.forEach(i => i.classList.remove('bg-gray-700', 'border-l-4', 'border-blue-500'));
                    this.classList.add('bg-gray-700', 'border-l-4', 'border-blue-500');

                    currentAssetType = this.dataset.assetType || 'stock';
                    const stockCode = this.dataset.stockCode;
                    const stockId = this.dataset.stockId;
                    const tradingviewCode = this.dataset.tradingviewCode;

                    document.getElementById('mobile-header-symbol').textContent = stockCode;
                    document.getElementById('chart-title').textContent = `${stockCode} Overview`;

                    toggleInterface(currentAssetType);

                    document.getElementById('trading-component').classList.remove('hidden');
                    document.getElementById('select-stock-prompt').classList.add('hidden');
                    document.getElementById('stock-details').classList.remove('hidden');

                    switchToMobileDetail();

                    if (currentWidget) { document.getElementById('tradingview-chart-container').innerHTML = ""; }
                    currentWidget = new TradingView.widget({
                        "container_id": "tradingview-chart-container",
                        "width": "100%", "height": "100%", "autosize": true,
                        "symbol": tradingviewCode, "interval": "D", "timezone": "Etc/UTC", "theme": "dark", "style": "1", "locale": "en",
                        "toolbar_bg": "#f1f3f6", "enable_publishing": false, "allow_symbol_change": true, "backgroundColor": "#000000"
                    });

                    const endpoint = currentAssetType === 'forex' ? `/api/forex/${stockId}` : `/api/stocks/${stockCode}`;
                    fetch(endpoint)
                        .then(res => res.json())
                        .then(data => {
                            selectedStock = data;
                            document.getElementById('data_stock_id').value = data.id;
                            document.getElementById('data_market').value = currentAssetType === 'forex' ? 'forex' : data.market;
                            document.getElementById('data_ask').value = data.ask_value;
                            document.getElementById('data_bid').value = data.bid_value;

                            document.getElementById('available-funds').textContent = usdFormatter.format(userBalance);

                            const askDisplay = currentAssetType === 'forex' ? data.ask_value : usdFormatter.format(data.ask_value);

                            document.getElementById('mobile-header-price').textContent = askDisplay;
                            document.getElementById('avg-price').textContent = askDisplay;
                            document.getElementById('details-open').textContent = askDisplay;
                            document.getElementById('details-close').textContent = currentAssetType === 'forex' ? '-' : usdFormatter.format(data.bid_value);
                            const high = data.year_range_max || 0; const low = data.year_range_min || 0;
                            const highDisplay = currentAssetType === 'forex' ? high : usdFormatter.format(high);
                            const lowDisplay = currentAssetType === 'forex' ? low : usdFormatter.format(low);
                            document.getElementById('details-high').textContent = highDisplay;
                            document.getElementById('details-low').textContent = lowDisplay;
                            document.getElementById('details-52wh').textContent = highDisplay;
                            document.getElementById('details-52wl').textContent = lowDisplay;

                            calculateQuantities();
                        });
                });
            });

            // Filter
            function filterAssets() {
                const term = searchInput.value.toLowerCase();
                const market = marketFilter.value;
                stockItems.forEach(item => {
                    const code = item.dataset.stockCode.toLowerCase();
                    const itemMarket = item.dataset.market;
                    const itemType = item.dataset.assetType;
                    const matchesSearch = code.includes(term);
                    let matchesMarket = true;
                    if (market !== 'all') {
                        if (market === 'forex') matchesMarket = (itemType === 'forex');
                        else matchesMarket = (itemMarket === market && itemType === 'stock');
                    }
                    item.style.display = (matchesSearch && matchesMarket) ? 'block' : 'none';
                });
            }
            searchInput.addEventListener('input', filterAssets);
            marketFilter.addEventListener('change', filterAssets);

            // Submit
            if (submitOrderBtn) {
                submitOrderBtn.addEventListener('click', async () => {
                    const stockId = document.getElementById('data_stock_id').value;
                    if (!stockId) return showMessage('error', 'Error', 'Select an asset first.');

                    // UI Loading State
                    submitText.classList.add('hidden');
                    submitSpinner.classList.remove('hidden');
                    submitOrderBtn.disabled = true;

                    // 1. Determine Endpoint
                    const endpoint = currentAssetType === 'forex' ? '/api/trade/forex' : '/api/trade';

                    // 2. Calculate Final Quantities
                    // Your controller requires BOTH shares_quantity AND fiat_amount
                    let finalShares = 0;
                    let finalFiat = 0;
                    const price = getCurrentPrice();

                    if (currentUnit === 'shares') {
                        finalShares = parseFloat(sharesQuantityInput.value) || 0;
                        finalFiat = (finalShares * price).toFixed(2);
                    } else {
                        // Fiat Mode
                        finalFiat = parseFloat(fiatQuantityInput.value) || 0;
                        finalShares = price > 0 ? (finalFiat / price) : 0;
                    }

                    // 3. Construct Payload
                    const payload = {
                        stock_id: stockId,
                        trade_action: currentOrderSide,
                        order_type: currentOrderType,
                        time_in_force: currentTIF, // Uses the global variable set by buttons

                        // Required fields for StockController validation:
                        shares_quantity: finalShares,
                        fiat_amount: finalFiat,
                        fill_outside_rth: document.getElementById('fill-outside-rth').checked ? 1 : 0,

                        // Conditional fields
                        leverage: currentAssetType === 'forex' ? parseInt(leverageInput.value) : null,
                        limit_price: limitPriceInput.value ? parseFloat(limitPriceInput.value) : null,
                        stop_price: stopPriceInput.value ? parseFloat(stopPriceInput.value) : null
                    };

                    try {
                        const response = await fetch(endpoint, {
                            method: 'POST',
                            headers: {
                                'Content-Type': 'application/json',
                                'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content')
                            },
                            body: JSON.stringify(payload)
                        });

                        const data = await response.json();

                        if (data.success) {
                            showMessage('success', 'Trade Executed', data.message);
                            // Reset inputs
                            sharesQuantityInput.value = '';
                            fiatQuantityInput.value = '';
                            calculateQuantities();
                        } else {
                            // Handle Validation Errors (422) or Logic Errors
                            const errorMsg = data.message || (data.errors ? Object.values(data.errors).flat().join('\n') : 'Unknown Error');
                            showMessage('error', 'Trade Failed', errorMsg);
                        }
                    } catch (e) {
                        console.error(e);
                        showMessage('error', 'Error', 'Connection failed. Check console.');
                    } finally {
                        // Reset UI
                        submitText.classList.remove('hidden');
                        submitSpinner.classList.add('hidden');
                        submitOrderBtn.disabled = false;
                    }
                });
            }

            if(closePopupBtn) closePopupBtn.addEventListener('click', () => messagePopup.classList.add('hidden'));
            if(okPopupBtn) okPopupBtn.addEventListener('click', () => messagePopup.classList.add('hidden'));

            // Initialize Defaults
            updateOrderTypeUI();
            updateUnitUI();
            updateOrderSideUI();
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/dashboard.blade.php ENDPATH**/ ?>