<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <section class="p-4 sm:p-6 lg:p-8 pt-0">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="text-2xl font-semibold text-white flex items-center">
                    <svg data-lucide="clipboard-list" class="w-8 h-8 mr-3 text-green-500"></svg>
                    Transaction History
                </h1>
                <div class="mt-2 sm:mt-0">
                    <a href="<?php echo e(route('dashboard')); ?>"
                       class="inline-flex items-center px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-lg text-sm font-semibold transition-colors duration-200">
                        <svg data-lucide="arrow-left" class="mr-2 w-4 h-4"></svg>
                        Back to Dashboard
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 pb-4">
        <div class="max-w-full mx-auto">
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm text-white overflow-x-auto">
                <div class="border-b border-gray-700 pb-4 mb-6">
                    <h4 class="font-bold text-xl text-white">All Transactions</h4>
                </div>

                <?php if($transactions->isEmpty()): ?>
                    <div class="p-4 text-center text-gray-400 text-lg">
                        No transactions found.
                    </div>
                <?php else: ?>
                    <table class="min-w-full divide-y divide-gray-700">
                        <thead class="bg-[#131319]">
                            <tr>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Transaction ID</th>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Type</th>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Amount</th>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Date</th>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Status</th>
                                <th scope="col" class="px-3 py-3.5 text-left text-sm font-semibold text-gray-400">Details</th>
                            </tr>
                        </thead>
                        <tbody id="transaction-rows" class="divide-y divide-gray-800">
                            <?php $__currentLoopData = $transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <?php
                                    $isPositive = in_array(strtolower($transaction->type), ['deposit', 'stock_sell']);
                                    $statusName = strtolower($transaction->status->name);
                                ?>
                                <tr>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-300"><?php echo e($transaction->transaction_id); ?></td>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm font-medium text-white"><?php echo e(ucfirst($transaction->type)); ?></td>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm <?php echo e($isPositive ? 'text-green-400' : 'text-red-400'); ?>">
                                        <?php echo e($isPositive ? '+' : '-'); ?>$<?php echo e(number_format($transaction->amount, 2)); ?>

                                    </td>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-300"><?php echo e($transaction->created_at->format('M d, Y')); ?></td>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm text-white">
                                        <span class="inline-flex items-center rounded-full px-4 py-1 text-xs font-medium
                                            <?php if($statusName == 'pending'): ?>
                                                bg-yellow-500 text-white
                                            <?php elseif($statusName == 'completed'): ?>
                                                bg-green-500 text-white
                                            <?php elseif($statusName == 'canceled'): ?>
                                                bg-red-500 text-white
                                            <?php else: ?>
                                                bg-gray-500 text-white
                                            <?php endif; ?>">
                                            <?php echo e(ucfirst($statusName)); ?>

                                        </span>
                                    </td>
                                    <td class="whitespace-nowrap px-3 py-4 text-sm text-gray-300">
                                        <button
                                            class="text-primary-400 hover:text-primary-300"
                                            onclick="showDetailsModal(<?php echo e(json_encode($transaction)); ?>)">
                                            View Details
                                        </button>
                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>

                    <div id="pagination-controls" class="mt-6 flex justify-center space-x-2">
                        </div>
                <?php endif; ?>
            </div>
        </div>
    </section>

    
    <div id="details-modal" class="fixed inset-0 bg-black bg-opacity-75 hidden z-50 flex items-center justify-center p-4">
        <div class="bg-[#131319] rounded-lg p-6 w-full max-w-md border border-gray-700 shadow-lg text-white">
            <div class="flex justify-between items-center pb-4 border-b border-gray-700 mb-4">
                <h3 class="text-xl font-bold">Transaction Details</h3>
                <button onclick="closeDetailsModal()" class="text-gray-400 hover:text-white transition-colors duration-200">
                    <svg data-lucide="x" class="w-6 h-6"></svg>
                </button>
            </div>
            <div class="space-y-4">
                <div>
                    <p class="text-gray-400 text-sm">Transaction ID</p>
                    <p id="modal-transaction-id" class="font-semibold text-lg"></p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Type</p>
                    <p id="modal-type" class="font-semibold capitalize"></p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Amount</p>
                    <p id="modal-amount" class="font-semibold text-green-400"></p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Date</p>
                    <p id="modal-date" class="font-semibold"></p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Status</p>
                    <p id="modal-status" class="font-semibold"></p>
                </div>
                <div>
                    <p class="text-gray-400 text-sm">Details</p>
                    <p id="modal-details" class="font-semibold"></p>
                </div>
                 <div id="modal-payment-option-container" class="hidden">
                    <p class="text-gray-400 text-sm">Payment Option</p>
                    <p id="modal-payment-option" class="font-semibold"></p>
                </div>
                <div id="modal-wallet-option-container" class="hidden">
                    <p class="text-gray-400 text-sm">Wallet Option</p>
                    <p id="modal-wallet-option" class="font-semibold"></p>
                </div>
                 <div id="modal-withdrawal-location-container" class="hidden">
                    <p class="text-gray-400 text-sm">Withdrawal Location</p>
                    <p id="modal-withdrawal-location" class="font-semibold break-all"></p>
                </div>
            </div>
        </div>
    </div>

    <script>
        // Client-side pagination logic
        document.addEventListener('DOMContentLoaded', () => {
            const tableBody = document.getElementById('transaction-rows');
            const rows = Array.from(tableBody.getElementsByTagName('tr'));
            const itemsPerPage = 10;
            let currentPage = 1;
            const totalPages = Math.ceil(rows.length / itemsPerPage);
            const paginationControls = document.getElementById('pagination-controls');

            function showPage(page) {
                rows.forEach(row => row.style.display = 'none');
                const startIndex = (page - 1) * itemsPerPage;
                const endIndex = startIndex + itemsPerPage;
                for (let i = startIndex; i < endIndex && i < rows.length; i++) {
                    rows[i].style.display = '';
                }
                updatePaginationControls();
            }

            function updatePaginationControls() {
                paginationControls.innerHTML = '';

                const prevBtn = document.createElement('button');
                prevBtn.textContent = 'Previous';
                prevBtn.classList.add('px-4', 'py-2', 'rounded-lg', 'font-semibold', 'transition-colors', 'duration-200');
                if (currentPage > 1) {
                    prevBtn.classList.add('bg-gray-700', 'hover:bg-gray-600', 'text-white');
                    prevBtn.addEventListener('click', () => {
                        currentPage--;
                        showPage(currentPage);
                    });
                } else {
                    prevBtn.classList.add('bg-gray-800', 'text-gray-500', 'cursor-not-allowed');
                }
                paginationControls.appendChild(prevBtn);

                for (let i = 1; i <= totalPages; i++) {
                    const pageBtn = document.createElement('button');
                    pageBtn.textContent = i;
                    pageBtn.classList.add('px-4', 'py-2', 'rounded-lg', 'font-semibold', 'transition-colors', 'duration-200');
                    if (i === currentPage) {
                        pageBtn.classList.add('bg-primary-600', 'text-white');
                    } else {
                        pageBtn.classList.add('bg-gray-700', 'hover:bg-gray-600', 'text-white');
                        pageBtn.addEventListener('click', () => {
                            currentPage = i;
                            showPage(currentPage);
                        });
                    }
                    paginationControls.appendChild(pageBtn);
                }

                const nextBtn = document.createElement('button');
                nextBtn.textContent = 'Next';
                nextBtn.classList.add('px-4', 'py-2', 'rounded-lg', 'font-semibold', 'transition-colors', 'duration-200');
                if (currentPage < totalPages) {
                    nextBtn.classList.add('bg-gray-700', 'hover:bg-gray-600', 'text-white');
                    nextBtn.addEventListener('click', () => {
                        currentPage++;
                        showPage(currentPage);
                    });
                } else {
                    nextBtn.classList.add('bg-gray-800', 'text-gray-500', 'cursor-not-allowed');
                }
                paginationControls.appendChild(nextBtn);
            }

            showPage(currentPage);
        });

        // Modal functions
        function showDetailsModal(transaction) {
            const modal = document.getElementById('details-modal');

            // Populate modal content
            document.getElementById('modal-transaction-id').textContent = transaction.transaction_id;
            document.getElementById('modal-type').textContent = transaction.type;
            const isPositive = ['deposit', 'stock_sell'].includes(transaction.type.toLowerCase());
            document.getElementById('modal-amount').textContent = `${isPositive ? '+' : '-'}\$${parseFloat(transaction.amount).toFixed(2)}`;
            document.getElementById('modal-amount').className = `font-semibold ${isPositive ? 'text-green-400' : 'text-red-400'}`;

            document.getElementById('modal-date').textContent = new Date(transaction.created_at).toLocaleDateString();
            document.getElementById('modal-status').textContent = transaction.status.name;
            document.getElementById('modal-details').textContent = transaction.details;

            // Handle optional fields
            const paymentOptionContainer = document.getElementById('modal-payment-option-container');
            const walletOptionContainer = document.getElementById('modal-wallet-option-container');
            const withdrawalLocationContainer = document.getElementById('modal-withdrawal-location-container');

            if (transaction.payment_option) {
                document.getElementById('modal-payment-option').textContent = transaction.payment_option.name;
                paymentOptionContainer.classList.remove('hidden');
            } else {
                paymentOptionContainer.classList.add('hidden');
            }

            if (transaction.wallet_option) {
                document.getElementById('modal-wallet-option').textContent = transaction.wallet_option.name;
                walletOptionContainer.classList.remove('hidden');
            } else {
                walletOptionContainer.classList.add('hidden');
            }

            if (transaction.withdrawal_location) {
                document.getElementById('modal-withdrawal-location').textContent = transaction.withdrawal_location;
                withdrawalLocationContainer.classList.remove('hidden');
            } else {
                withdrawalLocationContainer.classList.add('hidden');
            }

            modal.classList.remove('hidden');
        }

        function closeDetailsModal() {
            const modal = document.getElementById('details-modal');
            modal.classList.add('hidden');
        }
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\liquid-brokers-crypto-investment-app-v3.1\resources\views/transactions-history.blade.php ENDPATH**/ ?>