<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">
                    <?php if(isset($expertTrader)): ?>
                        Subscriptions for: <span class="text-primary-500"><?php echo e($expertTrader->name); ?></span>
                    <?php else: ?>
                        All User Replications
                    <?php endif; ?>
                </h4>
                <p class="mt-2 text-gray-400 text-sm">
                    <?php if(isset($expertTrader)): ?>
                        Viewing all users currently copying this plan.
                    <?php else: ?>
                        Viewing all copy-trading subscriptions across the platform.
                    <?php endif; ?>
                </p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                
                <a href="<?php echo e(route('admin.expert-traders.index')); ?>"
                   class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-semibold transition-colors duration-200">
                    &larr; Back to Plans
                </a>

                
                <?php if(isset($expertTrader)): ?>
                    <a href="<?php echo e(route('admin.expert-traders.subscriptions')); ?>"
                       class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">
                        View All
                    </a>
                <?php endif; ?>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">User</th>
                        
                        <?php if(!isset($expertTrader)): ?>
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Plan Name</th>
                        <?php endif; ?>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Allocated Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Current PNL</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Date Subscribed</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__empty_1 = true; $__currentLoopData = $replications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $rep): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">
                            <?php echo e($rep->user->name ?? 'Unknown User'); ?>

                            <div class="text-xs text-gray-400 font-normal"><?php echo e($rep->user->email ?? ''); ?></div>
                        </td>

                        <?php if(!isset($expertTrader)): ?>
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                <?php if($rep->expertTrader): ?>
                                    <a href="<?php echo e(route('admin.expert-traders.subscriptions', $rep->expertTrader->id)); ?>" class="hover:text-primary-400 underline">
                                        <?php echo e($rep->expertTrader->name); ?>

                                    </a>
                                <?php else: ?>
                                    <span class="text-red-400 italic">Deleted Plan</span>
                                <?php endif; ?>
                            </td>
                        <?php endif; ?>

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            $<?php echo e(number_format($rep->allocated_amount, 2)); ?>

                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <span class="<?php echo e($rep->current_pnl >= 0 ? 'text-green-400' : 'text-red-400'); ?>">
                                <?php echo e($rep->current_pnl >= 0 ? '+' : ''); ?>$<?php echo e(number_format($rep->current_pnl, 2)); ?>

                            </span>
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                <?php if($rep->status === 'active'): ?> bg-green-600 text-white
                                <?php elseif($rep->status === 'paused'): ?> bg-yellow-600 text-white
                                <?php else: ?> bg-gray-600 text-white <?php endif; ?>">
                                <?php echo e(ucfirst($rep->status)); ?>

                            </span>
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            <?php echo e($rep->created_at->format('M d, Y')); ?>

                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="<?php echo e(isset($expertTrader) ? 5 : 6); ?>" class="px-6 py-8 text-center text-gray-500 text-lg">
                            No subscriptions found.
                        </td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div class="mt-6">
            <?php echo e($replications->links()); ?>

        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/admin-dash/expert-traders/subscriptions.blade.php ENDPATH**/ ?>