<x-app-layout>
    <section class="py-8 antialiased md:py-16">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-5xl">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10">Withdraw</h1>

                <div class="mt-6 sm:mt-8">
                    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                        <div class="flex items-center justify-between border-b border-gray-700 pb-4 mb-4">
                            <h4 class="text-lg font-semibold text-white">Withdrawal Guide</h4>
                            {{-- Removed old lookup/search input as it doesn't seem relevant for a guide --}}
                        </div>
                        <div class="text-gray-400">
                            Provide the amount of funds you want to withdraw, then choose from our payment options and provide the details for this option. The admin will review the withdrawal request and your funds will be sent to your payment option.
                        </div>
                    </div>
                </div>

                @if ($errors->any())
                    <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-[#131319] dark:text-red-400" role="alert">
                        <span class="font-medium">Please correct the following errors:</span>
                        <ul class="mt-1.5 list-disc list-inside">
                            @foreach ($errors->all() as $error)
                                <li>{{ $error }}</li>
                            @endforeach
                        </ul>
                    </div>
                @endif


                @if(Auth::user()->kyc_status_id === 1 || Auth::user()->kyc_status_id === 3)
                    <div class="bg-red-700 text-white p-4 rounded-lg mt-6 text-center shadow-md border border-red-600">
                        <p class="font-semibold">You can't withdraw until your KYC is approved.</p>
                    </div>
                @else
                    <div class="mt-6 sm:mt-8 lg:flex lg:items-start lg:gap-12">
                        <form action="" method="POST" class="w-full rounded-lg border border-gray-700 bg-[#131319] p-4 shadow-sm sm:p-6 lg:p-8">
                            @csrf
                            <div class="mb-6 grid grid-cols-1 gap-4">
                                <div class="col-span-1">
                                    <label for="wallets" class="mb-2 block text-sm font-medium text-gray-400"> Select Wallet* </label>
                                    <select id="wallets" name="option" onchange="updateWithdrawalAmount()"
                                            class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:border-primary-500 focus:ring-primary-500 required">
                                        @foreach($wallets as $wallet)
                                            <option value="{{ $wallet->coin->id }}"
                                                    data-balance="{{ $wallet->balance }}"
                                                    data-coin-code="{{ $wallet->coin->code }}"
                                                    class="capitalize">
                                                {{ $wallet->coin->name }} (Balance: {{ number_format($wallet->balance, 2) }} {{ $wallet->coin->code }})
                                            </option>
                                        @endforeach
                                    </select>
                                </div>
                                <div class="col-span-1">
                                    <label for="amount" class="mb-2 block text-sm font-medium text-gray-400"> Withdrawal Amount (<span id="coinCodeDisplay">USD</span>)* </label>
                                    <input type="number" step="any" id="amount" name="amount"
                                           class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder:text-gray-400 focus:border-primary-500 focus:ring-primary-500"
                                           placeholder="Enter Amount" required />
                                    <p id="maxBalanceMessage" class="mt-1 text-sm text-gray-400"></p>
                                </div>

                                <div class="col-span-1">
                                    <label for="withdrawal_location" class="mb-2 block text-sm font-medium text-gray-400"> Account Info (Crypto Wallet Address, Bank Details, etc.)* </label>
                                    <textarea id="withdrawal_location" name="withdrawal_location"
                                              class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder:text-gray-400 focus:border-primary-500 focus:ring-primary-500"
                                              placeholder="Enter Crypto Wallet Address, Bank Details, etc." required rows="3"></textarea>
                                    <p class="mt-1 text-sm text-gray-400">e.g., crypto wallet address, bank details, etc.</p>
                                </div>
                            </div>
                            <input type="hidden" id="transaction_id" name="transaction_id" value="{{ $transactionId }}" required />
                            <input type="hidden" id="type" name="type" value="withdrawal" required />

                            @if(count($wallets) > 0 && $wallets->sum('balance') > 0)
                                <button type="submit" class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-300 font-bold py-3 px-4 rounded-lg mt-6 transition-colors duration-200">
                                    {{ __('Request Withdrawal') }}
                                </button>
                            @else
                                <button type="button" class="w-full text-white bg-red-600 cursor-not-allowed font-bold py-3 px-4 rounded-lg mt-6 opacity-75" disabled>
                                    {{ __('Insufficient Funds, Withdrawal Not Available') }}
                                </button>
                            @endif
                        </form>
                    </div>
                @endif
            </div>
        </div>
    </section>

    <script>
        const walletsSelect = document.getElementById('wallets');
        const amountInput = document.getElementById('amount');
        const maxBalanceMessage = document.getElementById('maxBalanceMessage');
        const coinCodeDisplay = document.getElementById('coinCodeDisplay');

        function updateWithdrawalAmount() {
            const selectedOption = walletsSelect.options[walletsSelect.selectedIndex];
            const balance = parseFloat(selectedOption.getAttribute('data-balance'));
            const coinCode = selectedOption.getAttribute('data-coin-code');

            coinCodeDisplay.textContent = coinCode;

            if (balance > 0) {
                amountInput.removeAttribute('disabled');
                amountInput.setAttribute('max', balance);
                maxBalanceMessage.textContent = `Max available: ${balance.toLocaleString(undefined, { minimumFractionDigits: 2, maximumFractionDigits: 2 })} ${coinCode}`;
                maxBalanceMessage.classList.remove('text-red-500'); // Use 500 for consistency
                maxBalanceMessage.classList.add('text-gray-400'); // Consistent gray text
            } else {
                amountInput.setAttribute('disabled', 'disabled');
                amountInput.value = ''; // Clear input if no balance
                amountInput.removeAttribute('max');
                maxBalanceMessage.textContent = 'Sorry, you do not have enough funds in this wallet.';
                maxBalanceMessage.classList.remove('text-gray-400');
                maxBalanceMessage.classList.add('text-red-500');
            }
        }

        // Initialize on page load
        document.addEventListener('DOMContentLoaded', updateWithdrawalAmount); // Use DOMContentLoaded for better practice
    </script>

    @if (session('success'))
        <div id="success-alert-modal" class="fixed inset-0 bg-[#000] bg-opacity-75 flex items-center justify-center z-50 p-4" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                <div class="text-center text-white mb-6">
                    <svg class="mx-auto h-16 w-16 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                    <h2 class="mt-4 text-3xl font-bold">Well Done!</h2>
                    <p class="mt-2">Your transaction ID:</p>
                    <p class="mt-2 text-2xl font-semibold">{{ session('transaction_id') }}</p>
                    <p class="mt-3 text-sm">Your withdrawal request has been logged and will be processed shortly.</p>
                </div>
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <button type="button" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200" onclick="document.getElementById('success-alert-modal').classList.add('hidden');">
                        Withdraw Again
                    </button>
                    <a href="/wallet" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg text-center transition-colors duration-200">
                        Go To Wallet
                    </a>
                </div>
            </div>
        </div>
        <script>
            // Show the modal when the page loads if a success session exists
            document.addEventListener('DOMContentLoaded', () => {
                const modal = document.getElementById('success-alert-modal');
                if (modal) {
                    modal.classList.remove('hidden');
                }
            });
        </script>
    @endif
</x-app-layout>
