<x-app-layout>
    <section class="py-8 antialiased md:py-16 pt-0 md:pt-0">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-7xl">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10">Wallet</h1>
                @php
                    // Helper function to format numbers with K, M, B suffixes
                    if (!function_exists('formatCompactNumber')) {
                        function formatCompactNumber($number) {
                            if ($number >= 1000000000) {
                                return number_format($number / 1000000000, 1) . 'B';
                            } elseif ($number >= 1000000) {
                                return number_format($number / 1000000, 1) . 'M';
                            } elseif ($number >= 1000) {
                                return number_format($number / 1000, 1) . 'K';
                            } else {
                                return number_format($number, 2);
                            }
                        }
                    }

                    // Pre-calculate formatted values
                    $collateral_compact = formatCompactNumber(Auth::user()->wallet->totalBalance);
                    $bonus_compact = formatCompactNumber(Auth::user()->wallet->bonus);
                    $total_funds = $total_staked + Auth::user()->wallet->totalBalance;
                    $total_compact = formatCompactNumber($total_funds);
                    $available_compact = formatCompactNumber(Auth::user()->wallet->totalBalance);
                    $staked_compact = formatCompactNumber($total_staked);
                    $available_percentage = ($total_funds > 0) ? number_format((Auth::user()->wallet->totalBalance / $total_funds) * 100, 1) : 0;
                    $staked_percentage = ($total_funds > 0) ? number_format(($total_staked / $total_funds) * 100, 1) : 0;
                @endphp
                <div class="mt-6 grid lg:grid-cols-2 gap-6">
                    {{-- Enhanced Wallet Balances Card --}}
                    <div class="rounded-xl p-6 bg-gradient-to-br from-gray-700 via-gray-800 to-gray-900 shadow-lg border border-gray-600
                                relative overflow-hidden
                                lg:col-span-1 flex flex-col xjustify-between gap-6">
                        {{-- Enhanced background pattern with better opacity --}}
                        <div class="absolute inset-0 opacity-5" style="background-image: url('{{ asset('images/bg-pattern.svg') }}'); background-size: cover; background-repeat: no-repeat;"></div>

                        {{-- Subtle glow effect --}}
                        <div class="absolute top-4 left-4 w-32 h-32 bg-green-500/10 rounded-full blur-3xl"></div>
                        <div class="absolute bottom-4 right-4 w-24 h-24 bg-blue-500/10 rounded-full blur-2xl"></div>

                        {{-- Collateral Balance --}}
                        <div class="relative z-10 flex flex-col xjustify-between h-fit bg-[#131319]/30 backdrop-blur-sm rounded-lg p-4 border border-gray-600/50">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"/>
                                    </svg>
                                    <span class="text-sm font-medium text-gray-300">USD Balance</span>
                                </div>
                                <div class="bg-green-500/20 px-2 py-1 rounded-full">
                                    <span class="text-xs text-green-400 font-medium">Available</span>
                                </div>
                            </div>

                            <div class="mb-3">
                                <div id="collateral-amount" class="text-3xl lg:text-4xl font-bold text-white leading-tight mb-1">
                                    ${{ number_format(Auth::user()->wallet->balance, 2) }}
                                </div>
                                <div id="collateral-full" class="text-sm text-gray-400 hidden">
                                    ${{ number_format(Auth::user()->wallet->balance, 2) }}
                                </div>
                            </div>

                            @if(Auth::user()->wallet->totalBalance == 0)
                                <div class="text-xs text-gray-500 bg-gray-700/50 px-2 py-1 rounded">No collateral yet</div>
                            @else
                                <div class="text-xs text-green-400 bg-green-500/10 px-2 py-1 rounded">
                                    <svg class="w-3 h-3 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7h8m0 0v8m0-8l-8 8-4-4-6 6"/>
                                    </svg>
                                    Ready to invest
                                </div>
                            @endif
                        </div>

                        {{-- Bonus Balance --}}
                        <div class="relative z-10 flex flex-col xjustify-between h-fit bg-[#131319]/30 backdrop-blur-sm rounded-lg p-4 border border-gray-600/50">
                            <div class="flex items-center justify-between mb-3">
                                <div class="flex items-center gap-2">
                                    <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1"/>
                                    </svg>
                                    <span class="text-sm font-medium text-gray-300">Total Assets Value</span>
                                </div>
                                <!-- <div class="bg-yellow-500/20 px-2 py-1 rounded-full">
                                    <span class="text-xs text-yellow-400 font-medium">Rewards</span>
                                </div> -->
                            </div>

                            <div class="mb-3">
                                <div id="bonus-amount" class="text-3xl lg:text-4xl font-bold text-white leading-tight mb-1">
                                    ${{ number_format(Auth::user()->wallet->bonus, 2) }}
                                </div>
                                <div id="bonus-full" class="text-sm text-gray-400 hidden">
                                    ${{ number_format(Auth::user()->wallet->totalBalance, 2) }}
                                </div>
                            </div>

                            @if(Auth::user()->wallet->bonus == 0)
                                <div class="text-xs text-gray-500 bg-gray-700/50 px-2 py-1 rounded">No bonus yet</div>
                            @else
                                <div class="text-xs text-yellow-400 bg-yellow-500/10 px-2 py-1 rounded">
                                    <svg class="w-3 h-3 inline mr-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 3v4M3 5h4M6 17v4m-2-2h4m5-16l2.286 6.857L21 12l-5.714 2.143L13 21l-2.286-6.857L5 12l5.714-2.143L13 3z"/>
                                    </svg>
                                    Earned rewards
                                </div>
                            @endif
                        </div>

                        {{-- Toggle Button --}}
                        <!-- <div class="absolute top-4 right-4 z-20">
                            <button id="toggle-details"
                                    class="bg-gray-700/80 hover:bg-gray-600/80 backdrop-blur-sm border border-gray-600 rounded-lg p-2 transition-all duration-200 group"
                                    title="Toggle detailed view">
                                <svg class="w-4 h-4 text-gray-300 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                </svg>
                            </button>
                        </div> -->
                    </div>

                    {{-- Enhanced Allocation Chart Card --}}
                    <div class="rounded-xl p-6 bg-gradient-to-br from-gray-800 to-gray-900 shadow-lg border border-gray-600 lg:col-span-1 relative overflow-hidden">
                        {{-- Background accent --}}
                        <div class="absolute top-4 right-4 w-24 h-24 bg-purple-500/10 rounded-full blur-2xl"></div>

                        <div class="relative z-10">
                            <div class="flex items-center justify-between mb-6">
                                <h3 class="text-lg font-semibold text-white flex items-center gap-2">
                                    <svg class="w-5 h-5 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 19v-6a2 2 0 00-2-2H5a2 2 0 00-2 2v6a2 2 0 002 2h2a2 2 0 002-2zm0 0V9a2 2 0 012-2h2a2 2 0 012 2v10m-6 0a2 2 0 002 2h2a2 2 0 002-2m0 0V5a2 2 0 012-2h2a2 2 0 012 2v14a2 2 0 01-2 2h-2a2 2 0 01-2-2z"/>
                                    </svg>
                                    Portfolio Allocation
                                </h3>
                                <div class="text-sm text-gray-400">
                                    Total: <span id="total-amount" class="font-semibold text-white">${{ formatCompactNumber($total_staked + Auth::user()->wallet->totalBalance) }}</span>
                                </div>
                            </div>

                            <div class="flex flex-col lg:flex-row items-center justify-center gap-8">
                                <div id="donut-chart" class="w-40 h-40 lg:w-48 lg:h-48 flex-shrink-0"></div>

                                @php
                                    $total_funds = $total_staked + Auth::user()->wallet->totalBalance;
                                    $available_percentage = ($total_funds > 0) ? number_format((Auth::user()->wallet->totalBalance / $total_funds) * 100, 1) : 0;
                                    $staked_percentage = ($total_funds > 0) ? number_format(($total_staked / $total_funds) * 100, 1) : 0;
                                @endphp

                                <div class="flex flex-col gap-4 w-full lg:w-auto min-w-[240px]">
                                    {{-- Available Funds --}}
                                    <div class="bg-[#131319]/50 backdrop-blur-sm rounded-lg p-4 border border-gray-700/50">
                                        <div class="flex items-center justify-between mb-2">
                                            <div class="flex items-center gap-2">
                                                <div class="w-3 h-3 bg-green-500 rounded-full shadow-sm shadow-green-500/50"></div>
                                                <span class="text-sm font-medium text-gray-300">Available</span>
                                            </div>
                                            <div class="bg-green-500/20 px-2 py-1 rounded-full">
                                                <span class="text-xs font-semibold text-green-400">{{ $available_percentage }}%</span>
                                            </div>
                                        </div>
                                        <div class="text-xl font-bold text-white">
                                            <span id="available-compact">${{ formatCompactNumber(Auth::user()->wallet->totalBalance) }}</span>
                                            <span id="available-full" class="hidden">${{ number_format(Auth::user()->wallet->totalBalance, 2) }}</span>
                                        </div>
                                    </div>

                                    {{-- Staked Funds --}}
                                    <div class="bg-[#131319]/50 backdrop-blur-sm rounded-lg p-4 border border-gray-700/50">
                                        <div class="flex items-center justify-between mb-2">
                                            <div class="flex items-center gap-2">
                                                <div class="w-3 h-3 bg-yellow-500 rounded-full shadow-sm shadow-yellow-500/50"></div>
                                                <span class="text-sm font-medium text-gray-300">In Orders</span>
                                            </div>
                                            <div class="bg-yellow-500/20 px-2 py-1 rounded-full">
                                                <span class="text-xs font-semibold text-yellow-400">{{ $staked_percentage }}%</span>
                                            </div>
                                        </div>
                                        <div class="text-xl font-bold text-white">
                                            <span id="staked-compact">${{ formatCompactNumber($total_staked) }}</span>
                                            <span id="staked-full" class="hidden">${{ number_format($total_staked, 2) }}</span>
                                        </div>
                                    </div>

                                    {{-- Toggle Button for Chart Details --}}
                                    <button id="toggle-chart-details"
                                            class="w-full bg-gray-700 hover:bg-gray-600 text-white text-sm font-medium py-2 px-4 rounded-lg transition-all duration-200 flex items-center justify-center gap-2 border border-gray-600">
                                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                                        </svg>
                                        <span id="toggle-text">View Detailed Amounts</span>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                {{-- Action Buttons --}}
                <div class="mt-6 grid grid-cols-1 sm:grid-cols-2 md:grid-cols-4 gap-4">
                    <a href="/deposit" class="rounded-lg p-4 bg-blue-600 hover:bg-blue-700 text-white flex items-center justify-center gap-2 text-xl font-semibold transition-colors duration-200">
                        <i data-lucide="wallet" class="w-6 h-6"></i>
                        DEPOSIT
                    </a>

                    <a href="/trade" class="rounded-lg p-4 bg-blue-600 hover:bg-blue-700 text-white flex items-center justify-center gap-2 text-xl font-semibold transition-colors duration-200">
                        <i data-lucide="trending-up" class="w-6 h-6"></i>
                        BUY CRYPTO
                    </a>

                    <a href="/withdraw" class="rounded-lg p-4 border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white flex items-center justify-center gap-2 text-xl font-semibold transition-colors duration-200">
                        <i data-lucide="arrow-up-right" class="w-6 h-6"></i>
                        WITHDRAW
                    </a>

                    <a href="/referral" class="rounded-lg p-4 border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white flex items-center justify-center gap-2 text-xl font-semibold transition-colors duration-200">
                        <i data-lucide="user-plus" class="w-6 h-6"></i>
                        REFER A FRIEND
                    </a>
                </div>

                {{-- Your Balances Table --}}
                <div class="mt-10 bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
                    <div class="border-b border-gray-700 pb-4 mb-4">
                        <h4 class="text-2xl font-semibold text-white">Your Balances</h4>
                    </div>
                    <div class="overflow-x-auto">
                        <table class="min-w-full divide-y divide-gray-700">
                            <thead class="bg-gray-700">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Coin</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Total</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">APY Rewards</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                                </tr>
                            </thead>
                            <tbody>
                                @foreach (Auth::user()->wallet->walletCoins as $walletCoin)
                                    <tr class="bg-[#131319] border-b border-gray-700 hover:bg-gray-700 transition-colors duration-200">
                                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">
                                            <div>{{ $walletCoin->coin->name }}</div>
                                            <div class="text-gray-400 text-xs">{{ $walletCoin->coin->code }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                            <div>{{ $walletCoin->balance == 0 ? '0.0' : rtrim(rtrim(number_format($walletCoin->balance, 18, '.', ''), '0'), '.') }}</div>
                                            <div class="text-gray-400 text-xs">${{ number_format($walletCoin->coin->value * $walletCoin->balance, 2) }}</div>
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                            @if($walletCoin->coin->stake_apr > 0)
                                                <div class="text-green-400 font-semibold">{{ $walletCoin->coin->stake_apr }}% APY</div>
                                                <div class="mt-1"><a href="/stake?code={{$walletCoin->coin->code}}" class="text-primary-400 hover:underline text-xs">Stake It</a></div>
                                            @else
                                                <span class="text-gray-500 text-xs">Staking not available</span>
                                            @endif
                                        </td>
                                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                            <div class="flex flex-col sm:flex-row gap-2">
                                                <a href="/deposit?code={{$walletCoin->coin->code}}" class="inline-block bg-blue-600 hover:bg-blue-700 text-white p-2 px-3 rounded-md text-xs font-semibold transition-colors duration-200 text-center">DEPOSIT</a>
                                                <a href="/withdraw?code={{$walletCoin->coin->code}}" class="inline-block border-2 border-blue-600 text-blue-600 hover:bg-blue-600 hover:text-white p-2 px-3 rounded-md text-xs font-semibold transition-colors duration-200 text-center">WITHDRAW</a>
                                            </div>
                                        </td>
                                    </tr>
                                @endforeach
                                {{-- If no wallet coins --}}
                                @if(Auth::user()->wallet->walletCoins->isEmpty())
                                    <tr>
                                        <td colspan="4" class="px-6 py-8 text-center text-gray-500 text-lg">
                                            No coins in your wallet yet.
                                            <div class="mt-4">
                                                <a href="/deposit" class="inline-block px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                                                    Deposit Funds
                                                </a>
                                            </div>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </section>

    {{-- ApexCharts Script --}}
    <script src="https://cdn.jsdelivr.net/npm/apexcharts"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const availablePercentage = {{ $available_percentage }};
            const stakedPercentage = {{ $staked_percentage }};

            const options = {
                series: [availablePercentage, stakedPercentage],
                chart: {
                    height: 190, // Adjusted height for better fit in the card
                    type: 'donut',
                    background: 'transparent', // Ensure chart background is transparent
                },
                labels: ['Available', 'In Orders'],
                colors: ['#4cb957', '#fed527'], // Green for available, Yellow for in orders
                legend: {
                    show: false // Hide the legend since we have custom labels next to the chart
                },
                plotOptions: {
                    pie: {
                        donut: {
                            size: '70%', // Adjust donut hole size
                            labels: {
                                show: true,
                                name: {
                                    show: true,
                                    fontSize: '12px',
                                    fontFamily: 'inherit',
                                    color: '#a0aec0', // gray-400
                                    offsetY: -10
                                },
                                value: {
                                    show: true,
                                    fontSize: '18px',
                                    fontFamily: 'inherit',
                                    color: '#ffffff', // white
                                    offsetY: 0,
                                    formatter: function (val) {
                                        return val + '%';
                                    }
                                },
                                total: {
                                    show: true,
                                    showAlways: true,
                                    label: 'Total',
                                    fontSize: '12px',
                                    fontFamily: 'inherit',
                                    color: '#a0aec0', // gray-400
                                    formatter: function (w) {
                                        // Calculate total percentage (should be 100 or close to it)
                                        return (w.globals.seriesTotals.reduce((a, b) => {
                                            return a + b
                                        }, 0)).toFixed(0) + '%';
                                    }
                                }
                            }
                        },
                        dataLabels: {
                            enabled: false // Completely disable data labels on the chart slices themselves
                        }
                    }
                },
                responsive: [{
                    breakpoint: 768, // md breakpoint
                    options: {
                        chart: {
                            height: 150
                        },
                        plotOptions: {
                            pie: {
                                donut: {
                                    labels: {
                                        name: { show: false },
                                        value: { show: false },
                                        total: { show: false }
                                    }
                                }
                            }
                        }
                    }
                }]
            };

            const chartElement = document.getElementById("donut-chart");
            if (chartElement) {
                const chart = new ApexCharts(chartElement, options);
                chart.render();
            }

            let isDetailedView = false;

            // Toggle for wallet balances
            const toggleButton = document.getElementById('toggle-details');
            const collateralAmount = document.getElementById('collateral-amount');
            const collateralFull = document.getElementById('collateral-full');
            const bonusAmount = document.getElementById('bonus-amount');
            const bonusFull = document.getElementById('bonus-full');

            // Toggle for chart section
            const toggleChartButton = document.getElementById('toggle-chart-details');
            const availableCompact = document.getElementById('available-compact');
            const availableFull = document.getElementById('available-full');
            const stakedCompact = document.getElementById('staked-compact');
            const stakedFull = document.getElementById('staked-full');
            const totalAmount = document.getElementById('total-amount');
            const toggleText = document.getElementById('toggle-text');

            // Wallet balance toggle
            if (toggleButton) {
                toggleButton.addEventListener('click', function() {
                    isDetailedView = !isDetailedView;

                    if (isDetailedView) {
                        // Show detailed view
                        collateralAmount.classList.add('hidden');
                        collateralFull.classList.remove('hidden');
                        bonusAmount.classList.add('hidden');
                        bonusFull.classList.remove('hidden');

                        // Update button icon to "hide" icon
                        toggleButton.innerHTML = `
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.875 18.825A10.05 10.05 0 0112 19c-4.478 0-8.268-2.943-9.543-7a9.97 9.97 0 011.563-3.029m5.858.908a3 3 0 114.243 4.243M9.878 9.878l4.242 4.242M9.878 9.878L3 3m6.878 6.878L12 12m6.121-3.879L21 21m-6.121-3.879L12 12"/>
                            </svg>
                        `;
                        toggleButton.title = "Hide detailed view";
                    } else {
                        // Show compact view
                        collateralAmount.classList.remove('hidden');
                        collateralFull.classList.add('hidden');
                        bonusAmount.classList.remove('hidden');
                        bonusFull.classList.add('hidden');

                        // Update button icon to "show" icon
                        toggleButton.innerHTML = `
                            <svg class="w-4 h-4 text-gray-300 group-hover:text-white transition-colors" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/>
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/>
                            </svg>
                        `;
                        toggleButton.title = "Toggle detailed view";
                    }
                });
            }

            // Chart section toggle
            if (toggleChartButton) {
                toggleChartButton.addEventListener('click', function() {
                    const isCurrentlyDetailed = !availableCompact.classList.contains('hidden');

                    if (isCurrentlyDetailed) {
                        // Switch to detailed view
                        availableCompact.classList.add('hidden');
                        availableFull.classList.remove('hidden');
                        stakedCompact.classList.add('hidden');
                        stakedFull.classList.remove('hidden');

                        // Update total amount to detailed
                        const totalValue = {{ $total_staked + Auth::user()->wallet->totalBalance }};
                        totalAmount.textContent = '$' + totalValue.toLocaleString('en-US', {minimumFractionDigits: 2, maximumFractionDigits: 2});

                        toggleText.textContent = 'View Compact Amounts';
                    } else {
                        // Switch to compact view
                        availableCompact.classList.remove('hidden');
                        availableFull.classList.add('hidden');
                        stakedCompact.classList.remove('hidden');
                        stakedFull.classList.add('hidden');

                        // Update total amount to compact
                        totalAmount.textContent = '{{ "$" . formatCompactNumber($total_staked + Auth::user()->wallet->totalBalance) }}';

                        toggleText.textContent = 'View Detailed Amounts';
                    }
                });
            }
        });
    </script>
</x-app-layout>
