<x-user-layout>
    <div class="space-y-8">

        {{-- HEADER --}}
        <div>
            <h2 class="text-2xl font-bold text-slate-900">Profile Settings</h2>
            <p class="text-sm text-slate-500 font-medium mt-1">Manage your personal information and security settings.</p>
        </div>

        <div class="grid grid-cols-1 xl:grid-cols-3 gap-8">

            {{-- LEFT COLUMN: PROFILE EDIT --}}
            <div class="xl:col-span-2 space-y-8">

                {{-- CARD 1: PERSONAL INFORMATION --}}
                <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_4px_20px_rgb(0,0,0,0.03)] overflow-hidden">
                    <div class="p-6 sm:p-8 border-b border-gray-100">
                        <h3 class="text-lg font-bold text-slate-900">Personal Information</h3>
                        <p class="text-sm text-slate-500">Update your photo and personal details.</p>
                    </div>

                    <div class="p-6 sm:p-8">
                        <form method="post" action="{{ route('user.profile.update') }}" enctype="multipart/form-data" class="space-y-6">
                            @csrf
                            @method('patch')

                            {{-- Photo Section --}}
                            <div class="flex items-center gap-6 mb-6">
                                <div class="relative group">
                                    <div class="w-24 h-24 rounded-full overflow-hidden border-4 border-gray-50 shadow-inner bg-gray-100">
                                        @if(Auth::user()->kyc)
                                            {{--
                                                Since we used ->store('profile-photos', 'public'), the 'kyc' column
                                                contains the relative path (e.g., "profile-photos/image.jpg").
                                                We just need to prepend 'storage/'.
                                            --}}
                                            <img id="preview-img"
                                                src="{{ asset('storage/' . Auth::user()->profile_photo) }}"
                                                alt="Profile"
                                                class="w-full h-full object-cover">
                                        @else
                                            <img id="preview-img"
                                                src="https://ui-avatars.com/api/?name={{ Auth::user()->firstname }}+{{ Auth::user()->lastname }}&background=eef2ff&color=4f46e5"
                                                class="w-full h-full object-cover">
                                        @endif
                                    </div>
                                    <label for="photo" class="absolute bottom-0 right-0 bg-indigo-600 text-white p-2 rounded-full cursor-pointer hover:bg-indigo-700 transition-colors shadow-md">
                                        <i data-lucide="camera" class="w-4 h-4"></i>
                                    </label>
                                    <input type="file" id="photo" name="photo" class="hidden" accept="image/*" onchange="previewFile(event)">
                                </div>
                                <div>
                                    <h4 class="font-bold text-slate-900">Profile Photo</h4>
                                    <p class="text-xs text-slate-500 mt-1">Max file size 2MB. JPG, PNG allowed.</p>
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                {{-- First Name --}}
                                <div>
                                    <x-input-label for="firstname" value="First Name" class="text-slate-700 font-semibold mb-2" />
                                    <x-text-input id="firstname" name="firstname" type="text"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3"
                                        :value="old('firstname', $user->firstname)" required />
                                    <x-input-error class="mt-2" :messages="$errors->get('firstname')" />
                                </div>

                                {{-- Last Name --}}
                                <div>
                                    <x-input-label for="lastname" value="Last Name" class="text-slate-700 font-semibold mb-2" />
                                    <x-text-input id="lastname" name="lastname" type="text"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3"
                                        :value="old('lastname', $user->lastname)" required />
                                    <x-input-error class="mt-2" :messages="$errors->get('lastname')" />
                                </div>

                                {{-- Email --}}
                                <div class="md:col-span-2">
                                    <x-input-label for="email" value="Email Address" class="text-slate-700 font-semibold mb-2" />
                                    <x-text-input id="email" name="email" type="email"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3"
                                        :value="old('email', $user->email)" required />
                                    <x-input-error class="mt-2" :messages="$errors->get('email')" />

                                    @if ($user instanceof \Illuminate\Contracts\Auth\MustVerifyEmail && ! $user->hasVerifiedEmail())
                                        <div class="mt-2 text-sm text-amber-600 bg-amber-50 p-3 rounded-lg flex items-center gap-2">
                                            <i data-lucide="alert-circle" class="w-4 h-4"></i>
                                            <span>Your email is unverified.</span>
                                        </div>
                                    @endif
                                </div>

                                {{-- Phone --}}
                                <div>
                                    <x-input-label for="phone" value="Phone Number" class="text-slate-700 font-semibold mb-2" />
                                    <x-text-input id="phone" name="phone" type="text"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3"
                                        :value="old('phone', $user->phone)" />
                                    <x-input-error class="mt-2" :messages="$errors->get('phone')" />
                                </div>

                                {{-- Address --}}
                                <div>
                                    <x-input-label for="address" value="Address" class="text-slate-700 font-semibold mb-2" />
                                    <x-text-input id="address" name="address" type="text"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3"
                                        :value="old('address', $user->address)" />
                                    <x-input-error class="mt-2" :messages="$errors->get('address')" />
                                </div>
                            </div>

                            <div class="flex items-center gap-4 pt-4">
                                <button type="submit" class="px-6 py-3 bg-indigo-600 hover:bg-indigo-700 text-white font-bold rounded-xl shadow-lg shadow-indigo-500/30 transition-all text-sm">
                                    Save Changes
                                </button>
                                @if (session('status') === 'profile-updated')
                                    <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)" class="text-sm text-green-600 font-medium flex items-center">
                                        <i data-lucide="check" class="w-4 h-4 mr-1"></i> Saved
                                    </p>
                                @endif
                            </div>
                        </form>
                    </div>
                </div>

                {{-- CARD 2: PASSWORD --}}
                <div class="bg-white rounded-2xl border border-gray-100 shadow-[0_4px_20px_rgb(0,0,0,0.03)] overflow-hidden">
                    <div class="p-6 sm:p-8 border-b border-gray-100">
                        <h3 class="text-lg font-bold text-slate-900">Security</h3>
                        <p class="text-sm text-slate-500">Ensure your account is using a long, random password to stay secure.</p>
                    </div>

                    <div class="p-6 sm:p-8">
                        <form method="post" action="{{ route('user.password.update') }}" class="space-y-6">
                            @csrf
                            @method('put')

                            <div>
                                <x-input-label for="current_password" value="Current Password" class="text-slate-700 font-semibold mb-2" />
                                <div class="relative">
                                    <x-text-input id="current_password" name="current_password" type="password"
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3 pr-10" required />
                                    <button type="button" onclick="toggleVisibility('current_password', this)" class="absolute right-3 top-3 text-gray-400 hover:text-gray-600">
                                        <i data-lucide="eye" class="w-5 h-5"></i>
                                    </button>
                                </div>
                                <x-input-error :messages="$errors->updatePassword->get('current_password')" class="mt-2" />
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                <div>
                                    <x-input-label for="update_password" value="New Password" class="text-slate-700 font-semibold mb-2" />
                                    <div class="relative">
                                        <x-text-input id="update_password" name="password" type="password"
                                            class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3 pr-10" required />
                                        <button type="button" onclick="toggleVisibility('update_password', this)" class="absolute right-3 top-3 text-gray-400 hover:text-gray-600">
                                            <i data-lucide="eye" class="w-5 h-5"></i>
                                        </button>
                                    </div>
                                    <x-input-error :messages="$errors->updatePassword->get('password')" class="mt-2" />
                                </div>

                                <div>
                                    <x-input-label for="update_password_confirmation" value="Confirm Password" class="text-slate-700 font-semibold mb-2" />
                                    <div class="relative">
                                        <x-text-input id="update_password_confirmation" name="password_confirmation" type="password"
                                            class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-3 pr-10" required />
                                        <button type="button" onclick="toggleVisibility('update_password_confirmation', this)" class="absolute right-3 top-3 text-gray-400 hover:text-gray-600">
                                            <i data-lucide="eye" class="w-5 h-5"></i>
                                        </button>
                                    </div>
                                    <x-input-error :messages="$errors->updatePassword->get('password_confirmation')" class="mt-2" />
                                </div>
                            </div>

                            <div class="flex items-center gap-4 pt-4">
                                <button type="submit" class="px-6 py-3 bg-gray-900 hover:bg-black text-white font-bold rounded-xl transition-all text-sm">
                                    Update Password
                                </button>
                                @if (session('status') === 'password-updated')
                                    <p x-data="{ show: true }" x-show="show" x-transition x-init="setTimeout(() => show = false, 2000)" class="text-sm text-green-600 font-medium flex items-center">
                                        <i data-lucide="check" class="w-4 h-4 mr-1"></i> Updated
                                    </p>
                                @endif
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            {{-- RIGHT COLUMN: STATUS CARD --}}
            <div class="xl:col-span-1 space-y-8">
                <div class="bg-indigo-600 rounded-2xl shadow-lg shadow-indigo-500/30 p-8 text-white relative overflow-hidden">
                    <div class="absolute top-0 right-0 -mt-4 -mr-4 w-32 h-32 bg-white opacity-10 rounded-full blur-2xl"></div>
                    <div class="relative z-10">
                        <div class="w-12 h-12 bg-white/20 rounded-xl flex items-center justify-center mb-6 backdrop-blur-sm">
                            <i data-lucide="shield-check" class="w-6 h-6 text-white"></i>
                        </div>
                        <h3 class="text-xl font-bold mb-1">Account Status</h3>
                        <p class="text-indigo-100 text-sm mb-6">Your current verification level.</p>

                        <div class="space-y-4">
                            <div class="flex justify-between items-center py-2 border-b border-indigo-500/30">
                                <span class="text-indigo-100 text-sm">Role</span>
                                <span class="font-bold text-white capitalize">{{ Auth::user()->role_id == 1 ? 'Administrator' : 'User' }}</span>
                            </div>
                            <div class="flex justify-between items-center py-2 border-b border-indigo-500/30">
                                <span class="text-indigo-100 text-sm">Joined</span>
                                <span class="font-bold text-white">{{ Auth::user()->created_at->format('M d, Y') }}</span>
                            </div>
                            <div class="flex justify-between items-center py-2">
                                <span class="text-indigo-100 text-sm">KYC Status</span>
                                @php
                                    $kycStatus = Auth::user()->kyc_status_id ?? 'Pending'; // Adjust based on your DB logic
                                @endphp
                                <span class="px-3 py-1 bg-white/20 rounded-full text-xs font-bold backdrop-blur-md">
                                    Active
                                </span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
    <script>
        // Image Preview Script
        function previewFile(event) {
            const preview = document.getElementById('preview-img');
            const file = event.target.files[0];
            const reader = new FileReader();

            reader.onloadend = function () {
                preview.src = reader.result;
            }

            if (file) {
                reader.readAsDataURL(file);
            }
        }

        // Password Visibility Toggle
        function toggleVisibility(fieldId, btn) {
            const input = document.getElementById(fieldId);
            const icon = btn.querySelector('i');

            if (input.type === 'password') {
                input.type = 'text';
                icon.setAttribute('data-lucide', 'eye-off');
            } else {
                input.type = 'password';
                icon.setAttribute('data-lucide', 'eye');
            }
            lucide.createIcons();
        }
    </script>
    @endpush
</x-user-layout>
