<x-app-layout>
    <section class="py-8 antialiased md:py-16">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-5xl py-">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10 display-2">Request Refund</h1>

                <div class="mt-6 grow sm:mt-8 lg:mt-0">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Request Refund Guide</h4>
                            <div class="box-controls pull-right">
                                <div class="lookup lookup-circle lookup-right">
                                <input type="text" name="s">
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <p class="text-gray-600 mb-3">Click on the button below to start the process of requesting refund</p>
                            <x-primary-button class="" data-bs-toggle="modal" data-bs-target="#request-form-modal">Request refund</x-primary-button>

                                    <!-- Approval modal -->
                                    <div id="request-form-modal" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
                                        <div class="modal-dialog modal-dialog-centered">
                                            <div class="modal-content modal-filled bg-white">
                                                <div class="modal-body p-4">
                                                    <div class="text-center">
                                                        <i class="dripicons-checkmark h1"></i>
                                                        <h2 class="mt-2 font-bold text-3xl">Request Refund</h2>
                                                        <p class="mb-7">Fill the form below to complete the request for refund process</p>
                                                        <form action="{{ url('request-refund') }}" method="POST">
                                                            @csrf
                                                            <div class="mb-4">
                                                                <label for="investment_id" class="block mb-2 text-sm text-left font-medium text-gray-900 dark:text-white">*Select from your current active investments</label>
                                                                <select id="investment_id" name="investment_id" class="bg-gray-50 border border-gray-300 text-gray-900 text-sm rounded-lg focus:ring-blue-500 focus:border-blue-500 block w-full p-2.5  dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" required>
                                                                    <option value="">Select Investment</option>
                                                                    @foreach ($investments as $investment)
                                                                        <option value="{{ $investment->id }}">{{ $investment->inv_id }}</option>
                                                                    @endforeach
                                                                </select>
                                                            </div>

                                                            <div class="mb-4">
                                                                <label for="reason" class="block mb-2 text-sm font-medium text-gray-900 dark:text-white text-left">*Reason for Termination</label>
                                                                <textarea id="reason" name="reason" rows="4" class="block p-2.5 w-full text-sm text-gray-900 bg-gray-50 rounded-lg border border-gray-300 focus:ring-blue-500 focus:border-blue-500 xdark:bg-gray-700 dark:border-gray-600 dark:placeholder-gray-400 dark:text-white dark:focus:ring-blue-500 dark:focus:border-blue-500" placeholder="Enter reason for refund request" required></textarea>
                                                            </div>

                                                            <div class="flex item-center justify-center gap-4 my-4">
                                                                <button type="submit" class="btn btn-light my-2 bg-white border-2 border-blue-600">Request refund</button>
                                                                <button type="button" class="btn btn-light my-2 bg-gray-300 text-white" data-bs-dismiss="modal">Cancel</button>
                                                            </div>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div><!-- /.modal-content -->
                                        </div><!-- /.modal-dialog -->
                                    </div><!-- /.modal -->
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    @if (session('success'))
    <button type="button" class="btn btn-success hidden" data-bs-toggle="modal" data-bs-target="#success-alert-modal" id="trigger_success">Success Alert</button>
    <div id="success-alert-modal" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content modal-filled bg-success">
                <div class="modal-body p-4">
                    <div class="text-center">
                        <i class="dripicons-checkmark h1"></i>
                        <h2 class="mt-2">Refund Request Registered Successfully!</h2>
                        <h2 class="mt-2 text-2xl">Refund Request ID: {{ session('refund_id') }}</h2>
                        <div class="flex item-center justify-center gap-4">
                            <a type="button" class="btn btn-light my-2 bg-white" href="/investment">Invest</a>
                            <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <script>
        // var modal = new bootstrap.Modal(document.getElementById('success-alert-modal'));
        // modal.show();
        const button_success = document.querySelector('#trigger_success');

        // Simulate a click event
        button_success.click();
        document.addEventListener('DOMContentLoaded', () => {
            window.addEventListener('load', () => {
                const triggerButton = document.getElementById('trigger-modal');
                button_success.click();
            });
        });
    </script>
@endif
@if (session('error'))
    <button type="button" class="btn btn-success hidden" data-bs-toggle="modal" data-bs-target="#error-alert-modal" id="trigger_error">Success Alert</button>
    <div id="error-alert-modal" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content modal-filled bg-danger">
                <div class="modal-body p-4">
                    <div class="text-center">
                        <i class="dripicons-checkmark h1"></i>
                        <h2 class="mt-2 font-bold text-3xl">Error!</h2>
                        <h2 class="mt-2 text-2xl">{{session('error')}}</h2>
                        <div class="flex item-center justify-center gap-4">
                            <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">Close</button>
                        </div>
                    </div>
                </div>
            </div><!-- /.modal-content -->
        </div><!-- /.modal-dialog -->
    </div><!-- /.modal -->
    <script>
        // var modal = new bootstrap.Modal(document.getElementById('success-alert-modal'));
        // modal.show();
        const button_success = document.querySelector('#trigger_error');

        // Simulate a click event
        button_success.click();
        document.addEventListener('DOMContentLoaded', () => {
            window.addEventListener('load', () => {
                const triggerButton = document.getElementById('trigger-modal');
                button_success.click();
            });
        });
    </script>
@endif
</x-app-layout>
