<x-app-layout>
    <section class="p-4 sm:p-6 lg:p-8">
        <div class="mx-auto max-w-full">
            <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-6">
                <h1 class="font-semibold text-white text-3xl">My Portfolio</h1>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 pb-4">
        <div class="max-w-full mx-auto">
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-md">
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center">
                    <div class="flex-1 mb-4 sm:mb-0">
                        <h4 class="flex items-center text-green-500 text-lg sm:text-xl font-semibold">
                            <svg data-lucide="line-chart" class="w-6 h-6 mr-2"></svg>
                            Total Investment Value <small class="text-gray-400 text-sm ml-2">(active staking & fixed plans)</small>
                        </h4>
                        <div class="mt-2">
                            <p class="text-3xl md:text-4xl lg:text-5xl font-bold text-white">${{ number_format($total_staked ?? 0, 2) }}</p>
                        </div>
                    </div>
                    <div class="flex-shrink-0 text-right w-full sm:w-auto">
                        <div class="flex justify-end items-center h-full">
                            <svg data-lucide="wallet" class="w-16 h-16 text-green-500"></svg>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="px-4 sm:px-6 lg:px-8 pt-4">
        <div class="max-w-full mx-auto space-y-8">

            {{-- User's Stock Holdings --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-md">
                <div class="border-b border-gray-700 pb-4 mb-4 flex justify-between items-center">
                    <h4 class="font-bold text-2xl text-white">My Stock Holdings</h4>
                    <a href="{{ route('trade.index') }}" class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg text-sm transition-colors duration-200">
                        Buy More Stocks
                    </a>
                </div>
                @if(!empty($stockWallets) && count($stockWallets) > 0)
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($stockWallets as $stockWallet)
                        <div class="border p-6 rounded-lg border-gray-700 bg-gray-700">
                            <div class="flex flex-col gap-2">
                                <div class="font-bold text-2xl text-white">{{ $stockWallet->stock->name }}</div>
                                <div class="text-sm text-gray-400">({{ $stockWallet->stock->code }} -  {{$stockWallet->stock->market ? 'NYSE' : 'LSE'}})</div>
                            </div>
                            <div class="flex justify-between items-center mt-4 mb-2">
                                <div>
                                    <div class="text-gray-300 text-sm">Shares Owned</div>
                                    <div class="text-4xl font-semibold text-white mt-1">{{ number_format($stockWallet->claimed, 0) }}</div>
                                </div>
                                <div class="text-right">
                                    <div class="text-gray-300 text-sm">Current Value</div>
                                    <div class="text-xl font-semibold text-green-400 mt-1">${{ number_format($stockWallet->claimed * $stockWallet->stock->value, 2) }}</div>
                                </div>
                            </div>
                            <div class="text-gray-400 text-sm">Current Price: ${{ number_format($stockWallet->stock->value, 2) }}</div>
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-4 text-center text-gray-400 text-lg">
                        You do not own any stocks yet.
                        <div class="mt-4">
                            <a href="{{ route('trade.index') }}" class="inline-block px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                                Start Trading Now
                            </a>
                        </div>
                    </div>
                @endif
            </div>

            {{-- User's Fixed Investments (from new UserFixedInvestment model) --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-md">
                <div class="border-b border-gray-700 pb-4 mb-4 flex justify-between items-center">
                    <h4 class="font-bold text-2xl text-white">My Investments</h4>
                    <a href="{{ route('stake.index') }}" class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg text-sm transition-colors duration-200">
                        Explore More Plans
                    </a>
                </div>
                @if(!empty($userFixedInvestments) && count($userFixedInvestments) > 0)
                    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                        @foreach($userFixedInvestments as $fixedInv)
                        <div class="border p-6 rounded-lg {{ $fixedInv->status === 'active' ? 'border-primary-500' : ($fixedInv->status === 'matured' ? 'border-yellow-500' : ($fixedInv->status === 'disbursed' ? 'border-green-500' : 'border-red-500')) }} bg-gray-700">
                            <div class="flex flex-col md:flex-row gap-5 justify-between items-start mb-4">
                                <div>
                                    <div class="font-bold text-2xl text-white mb-1">{{ $fixedInv->investmentPlan->name }}</div>
                                    <div class="text-4xl font-semibold text-white">${{ number_format($fixedInv->invested_amount, 2) }}</div>
                                </div>
                                <div class="text-right w-full">
                                    @if( $fixedInv->days_left == 0)
                                        <div class="text-gray-300 text-sm">Matured</div>
                                    @else
                                        <div class="text-gray-300 text-sm">{{ $fixedInv->days_left }} @if($fixedInv->days_left > 1) Days @else Day @endif Left</div>
                                    @endif
                                    @if( $fixedInv->status === 'matured')
                                        <div class="text-gray-500 italic text-sm">admin will disburse your earninig to your wallet soon</div>
                                    @endif
                                    <div class="w-full bg-gray-600 rounded-full h-2.5 mt-2">
                                        <div class="@if( $fixedInv->days_left == 0) bg-green-500 @else bg-primary-500 @endif h-2.5 rounded-full" style="width: {{ $fixedInv->percent_completed }}%"></div>
                                    </div>
                                    <div class="text-gray-300 text-sm mt-2">Daily ROI: {{ $fixedInv->investmentPlan->daily_roi_percentage }}%</div>
                                </div>
                            </div>
                            <div class="text-gray-400 text-sm">Investment ID: {{ $fixedInv->inv_id }}</div>
                            <div class="text-gray-400 text-sm">Started: {{ $fixedInv->start_date->format('d/m/Y') }}</div>
                            <div class="text-gray-400 text-sm">Duration: {{ $fixedInv->user_chosen_duration_value }} @if($fixedInv->user_chosen_duration_value > 1) days @else day @endif</div>
                            <div class="text-gray-400 text-sm mt-1">Status:
                                <span class="px-2 py-1 rounded-full text-xs font-semibold
                                    @if($fixedInv->status === 'active') bg-primary-600 text-white
                                    @elseif($fixedInv->status === 'matured') bg-yellow-600 text-white
                                    @elseif($fixedInv->status === 'disbursed') bg-green-600 text-white
                                    @else bg-red-600 text-white @endif">
                                    {{ ucfirst($fixedInv->status) }}
                                </span>
                            </div>
                            @if($fixedInv->current_pnl !== null)
                            <div class="text-gray-400 text-sm mt-1">Current P&L:
                                <span class="font-semibold @if($fixedInv->current_pnl >= 0) text-green-400 @else text-red-400 @endif">
                                    ${{ number_format($fixedInv->current_pnl, 2) }}
                                </span>
                            </div>
                            @endif
                        </div>
                        @endforeach
                    </div>
                @else
                    <div class="p-4 text-center text-gray-400 text-lg">
                        No active fixed investment plans yet.
                        <div class="mt-4">
                            <a href="{{ route('stake.index') }}" class="inline-block px-6 py-3 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">
                                Explore Fixed Investment Plans
                            </a>
                        </div>
                    </div>
                @endif
            </div>

        </div>
    </section>

    @if (session('success'))
        <div id="success-alert-modal" class="fixed inset-0 bg-[#000] bg-opacity-75 flex items-center justify-center z-50 p-4" tabindex="-1" role="dialog" aria-hidden="true">
            <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                <div class="text-center text-white mb-6">
                    <svg data-lucide="check-circle" class="mx-auto h-16 w-16 text-white"></svg>
                    <h2 class="mt-4 text-3xl font-bold">Investment Successful!</h2>
                    <p class="mt-2 text-xl">Investment ID: {{ session('investment_id') }}</p>
                </div>
                <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
                    <a href="{{ route('investment.index') }}" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">
                        Invest Again
                    </a>
                    <button type="button" class="w-full sm:w-auto px-6 py-3 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200" onclick="document.getElementById('success-alert-modal').classList.add('hidden');">
                        Close
                    </button>
                </div>
            </div>
        </div>
        <script>
            document.addEventListener('DOMContentLoaded', () => {
                const modal = document.getElementById('success-alert-modal');
                if (modal) {
                    modal.classList.remove('hidden');
                }
            });
        </script>
    @endif
</x-app-layout>
