<x-app-layout>
    <x-slot name="header">
        <h2 class="font-semibold text-xl text-gray-800 dark:text-gray-200 leading-tight">
            {{ __('Dashboard') }}
        </h2>
    </x-slot>

    <div class="py-12">
        <div class="max-w-7xl mx-auto sm:px-6 lg:px-8">
            <div class="bg-white dark:bg-[#131319] overflow-hidden shadow-sm sm:rounded-lg">
                <div class="p-6 text-gray-900 dark:text-gray-100 h-auto">
                    <form class="">

                        <div id="header" class="flex flex-col md:flex-row h-auto md:h-[25vh]">
                            <div class="grid grid-cols-1 md:grid-cols-6 items-center gap-4 text-xs">
                                <div class="col-span-1 flex justify-center">
                                    <div class="rounded-full profile-picture bg-gray-100 relative m-auto w-36 h-36 bg-[rgb(222,6,6)] flex items-center justify-center">
                                        <img src="https://img.icons8.com/?size=100&id=IzemTAHM11pn&format=png&color=900000" alt="user" class="w-4/5 h-4/5 absolute top-1/2 left-1/2 transform -translate-x-1/2 -translate-y-1/2">
                                    </div>
                                </div>
                                <div class="col-span-4 flex flex-col md:flex-row text-start justify-center md:justify-start space-y-4 md:space-y-0">
                                    <button class="rounded-md mx-2 w-full md:w-60 border-solid border-2 hover:bg-transparent border-red-900 hover:text-[#900] bg-red-900 text-white py-2 px-4 font-bold">CHANGE PICTURE</button>
                                    <button class="rounded-md mx-2 w-full md:w-60 border-solid border-2 border-[#900] text-[#900] hover:bg-red-900 hover:text-white py-2 px-4 font-bold">DELETE PICTURE</button>
                                </div>
                            </div>
                        </div>

                        <div id="details" class="border-2 border-gray-200 border-solid p-4 rounded-md text-xs">
                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <!-- Row 1 -->
                                <div class="flex flex-col my-1">
                                    <label for="firstname" class="text-sm font-medium text-gray-500">First Name</label>
                                    <input type="text" class="text-xs border-1 border-gray-300 rounded-md focus:ring focus:ring-gray-500/50" id="firstname" placeholder="Enter your Firstname">
                                </div>
                                <div class="flex flex-col my-1">
                                    <label for="lastname" class="text-sm font-medium text-gray-500">Last Name</label>
                                    <input type="text" class="text-xs border-1 border-gray-300 rounded-md focus:ring focus:ring-gray-500/50" id="lastname" placeholder="Enter your Last name">
                                </div>
                            </div>

                            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                                <!-- Row 1 -->
                                <div class="flex flex-col my-1">
                                    <label for="username" class="text-sm font-medium text-gray-500">Username</label>
                                    <input type="text" class="text-xs border-1 border-gray-300 rounded-md focus:ring focus:ring-gray-500/50" id="username" placeholder="Enter your Username">
                                </div>
                                <div class="flex flex-col my-1">
                                    <label for="phonenumber" class="text-sm font-medium text-gray-500">Phone Number</label>
                                    <input type="number" class="text-xs border-1 border-gray-300 rounded-md focus:ring focus:ring-gray-500/50" id="phonenumber" placeholder="Enter your Phone number">
                                </div>
                            </div>

                            <!-- Row 2 -->
                            <div class="grid grid-cols-1 gap-4 mt-2">
                                <div class="flex flex-col my-1">
                                    <label for="email" class="text-sm font-medium text-gray-500">Email</label>
                                    <input type="email" class="text-xs border-1 border-gray-300 rounded-md focus:ring focus:ring-gray-500/50" id="email" placeholder="me@example.com">
                                </div>
                            </div>
                            <!-- Row 2 -->
                            <div class="grid grid-cols-1 gap-4 mt-2">
                                <div class="flex flex-col my-1">
                                    <label for="address" class="text-sm font-medium text-gray-500">Residential Address</label>
                                    <textarea name="" id="" placeholder="Enter you residential Address" class="mt-1 border-gray-300 rounded-lg focus:ring focus:ring-gray-500/50">

                                    </textarea>
                                </div>
                            </div>
                        </div>
                        <div class="grid justify-end">
                            <button type="submit" class="text-sm mt-6 border-solid border-2 border-red-900 border-1 text-red-900 hover:bg-red-950 hover:text-white py-2 px-14 rounded-md">SAVE CHANGES</button>
                        </div>

                    </form>

                </div>
            </div>
        </div>
    </div>
</x-app-layout>
