<x-app-layout>
    <section>
        <div class="container-full ">
            <div class="row bg-transparent mb-3 p-4" >
                <div class="col-xl-9 col-12">
                <h1 class="font-semibold text-white text-3xl">Invest</h1>
            </div>
            </div>
        </div>
    </section>

    <section>
        <div>
            <div class="container-full ps-4 pe-4 pb-1">
                <div class="box box-body pull-up Sales_Profit ">
                    <div class="row">
                        <div class="col-8 ">
                            <h4 class="hover-success"><i class="bi bi-cash-coin text-success"></i>Wallet Balance</h4>
                            <div class="d-flex">
                                <p style="font-size: 39px;">${{ number_format(Auth::user()->wallet->balance, 2, '.', ',') }}</p>
                            </div>
                        </div>
                        <div class="col-4 text-end" style="position: relative;">
                            <div id="new-leads-chart2" style="min-height: 70px;"><i class="bi bi-briefcase-fill fs-50 text-success"></i></div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <section class="px-10">
        <div class="box" id="first_box">
            <div class="box-header">
                <h4 class="font-bold">Select from our list of available Investments</h4>
            </div>
            <div class="box-body grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3  gap-5" >
                <div class="border grid grid-cols-2 justify-between w-full p-6 rounded hover:border-green-500 hover:border-2" onclick="selectInvestment(1)" id="investment-1">
                    <div>
                        <div class="font-bold text-2xl">Investment 1 </div>
                        <div>Minimum Investment</div>
                        <div class="text-4xl">$700</div>
                    </div>
                    <div class="text-right flex flex-col justify-between">
                        <div>Duration: 20 Days</div>
                        <div>ROI: <span class="font-bold text-2xl">20%</span></div>
                        <div>Offer Closes in 3 days</div>
                    </div>
                </div>
                <div class="border grid grid-cols-2 justify-between w-full p-6 rounded hover:border-green-500 hover:border-2" onclick="selectInvestment(2)" id="investment-2">
                    <div>
                        <div class="font-bold text-2xl">Investment 1 </div>
                        <div>Minimum Investment</div>
                        <div class="text-4xl">$700</div>
                    </div>
                    <div class="text-right flex flex-col justify-between">
                        <div>Duration: 20 Days</div>
                        <div>ROI: <span class="font-bold text-2xl">20%</span></div>
                        <div>Offer Closes in 3 days</div>
                    </div>
                </div>
                <div class="border grid grid-cols-2 justify-between w-full p-6 rounded hover:border-green-500 hover:border-2" onclick="selectInvestment(3)" id="investment-3">
                    <div>
                        <div class="font-bold text-2xl">Investment 1 </div>
                        <div>Minimum Investment</div>
                        <div class="text-4xl">$700</div>
                    </div>
                    <div class="text-right flex flex-col justify-between">
                        <div>Duration: 20 Days</div>
                        <div>ROI: <span class="font-bold text-2xl">20%</span></div>
                        <div>Offer Closes in 3 days</div>
                    </div>
                </div>
                <div class="border grid grid-cols-2 justify-between w-full p-6 rounded hover:border-green-500 hover:border-2" onclick="selectInvestment(4)" id="investment-4">
                    <div>
                        <div class="font-bold text-2xl">Investment 1 </div>
                        <div>Minimum Investment</div>
                        <div class="text-4xl">$700</div>
                    </div>
                    <div class="text-right flex flex-col justify-between">
                        <div>Duration: 20 Days</div>
                        <div>ROI: <span class="font-bold text-2xl">20%</span></div>
                        <div>Offer Closes in 3 days</div>
                    </div>
                </div>
            </div>
            <x-primary-button xclass="w-fit text-2xl block mx-auto" onclick="hideFirstBox()">Next</x-primary-button>
        </div>
        <div class="box p-6 hidden" id="second_box">
            <div class="box-header">
                <h4 class="font-bold">Investment Ammount</h4>
            </div>
            <div class="form-group">
              <input type="text"
                class="form-control" name="" id="" aria-describedby="helpId" placeholder="">
              <small id="helpId" class="form-text text-muted">max ${{ number_format(Auth::user()->wallet->balance, 2, '.', ',') }}</small>
            </div>
            <a href="/investments" clas="w-full block">
                <x-primary-button class="w-full text-2xl block mx-auto" >Invest</x-primary-button>
            </a>
        </div>
    </section>
    <script>
        var box;
        var selectedbox = null;
        function selectInvestment(id) {
            console.log(id,selectedbox);
            if (!selectedbox) {
                console.log('if ran');
                box = document.getElementById('investment-' + id);
                box.style.backgroundColor = 'green';
                selectedbox = id;
            }else{
                box = document.getElementById('investment-' + selectedbox);
                console.log('else ran', box);
                box.style.backgroundColor = '';
                box = document.getElementById('investment-' + id);
                box.style.backgroundColor = 'green';
                selectedbox = id;
            }
        }
        function hideFirstBox() {
            document.getElementById('first_box').style.display = 'none';
            document.getElementById('second_box').style.display = 'block';
        }
    </script>
</x-app-layout>
