<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" class="dark">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    {{-- PRIMARY SEO META TAGS --}}
    <title>@yield('title', config('app.name', 'Stackvault') . ' - Your Digital Asset Platform')</title>
    <meta name="description" content="@yield('description', 'Stackvault is your premier platform for digital asset trading, crypto staking, signal subscriptions, and copy trading. Manage your portfolio, make deposits and withdrawals, and refer friends.')">
    <meta name="keywords" content="@yield('keywords', 'Stackvault, crypto trading, digital assets, cryptocurrency, staking, crypto signals, copy trading, Bitcoin, Ethereum, USDT, finance, investment, portfolio management, online trading')">
    <meta name="author" content="Stackvault Team">

    {{-- OPEN GRAPH / SOCIAL MEDIA META TAGS --}}
    <meta property="og:type" content="website">
    <meta property="og:url" content="{{ url()->current() }}">
    <meta property="og:title" content="@yield('title', config('app.name', 'Stackvault') . ' - Your Digital Asset Platform')">
    <meta property="og:description" content="@yield('description', 'Stackvault is your premier platform for digital asset trading, crypto staking, signal subscriptions, and copy trading. Manage your portfolio, make deposits and withdrawals, and refer friends.')">
    <!-- <meta property="og:image" content="https://stakeorbityield.com/assets/images/resource/apps-1.png"> -->
    <meta property="og:site_name" content="{{ config('app.name', 'Stackvault') }}">

    {{-- TWITTER CARD META TAGS --}}
    <meta name="twitter:card" content="summary_large_image">
    <meta name="twitter:url" content="{{ url()->current() }}">
    <meta name="twitter:title" content="@yield('title', config('app.name', 'Stackvault') . ' - Your Digital Asset Platform')">
    <meta name="twitter:description" content="@yield('description', 'Stackvault is your premier platform for digital asset trading, crypto staking, signal subscriptions, and copy trading. Manage your portfolio, make deposits and withdrawals, and refer friends.')">
    <!-- <meta name="twitter:image" content="https://stakeorbityield.com/assets/images/resource/apps-1.png"> -->
    <meta name="twitter:creator" content="@YourTwitterHandle">

    {{-- CANONICAL URL --}}
    <link rel="canonical" href="{{ url()->current() }}">

    {{-- FAVICONS --}}
    <link rel="apple-touch-icon" sizes="180x180" href="{{ asset('images/apple-touch-icon.png') }}">
    <link rel="icon" type="image/png" href="{{ asset('images/favvv.png')}}" sizes="32x32"/>
    <link rel="icon" type="image/png" href="{{ asset('images/favvv.png')}}" sizes="16x16"/>
    <link rel="manifest" href="{{ asset('site.webmanifest') }}">
    <link rel="mask-icon" href="{{ asset('images/safari-pinned-tab.svg') }}" color="#5bbad5">
    <meta name="msapplication-TileColor" content="#da532c">
    <meta name="theme-color" content="#ffffff">

    {{-- FONTS --}}
    <link rel="preconnect" href="https://fonts.bunny.net">
    <link href="https://fonts.bunny.net/css?family=figtree:400,500,600&display=swap" rel="stylesheet" />

    {{-- STYLES & SCRIPTS --}}
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css" integrity="sha512-SnH5WK+bZxgPHs44uWIX+LLJAJ9/2PkPKZ5QiAj6Ta86w+fsb2TkcmfRyVX3pBnMFcV7oQPJkl9QevSCWr3W6A==" crossorigin="anonymous" referrerpolicy="no-referrer" />
    <link href="{{asset('build/assets/built.css')}}" rel="stylesheet" />
    <script src="https://unpkg.com/lucide@latest"></script>
    <script>
      lucide.createIcons();
    </script>
    {{-- Assuming app2.js is still needed for some global behavior --}}
    <script src="{{asset('build/assets/app2.js')}}"></script>

    {{-- Global Site Tag (gtag.js) - Google Analytics --}}
    {{-- <script async src="https://www.googletagmanager.com/gtag/js?id=G-XXXXXXXXXX"></script>
    <script>
      window.dataLayer = window.dataLayer || [];
      function gtag(){dataLayer.push(arguments);}
      gtag('js', new Date());
      gtag('config', 'G-XXXXXXXXXX');
    </script> --}}

    {{-- Structured Data (JSON-LD) --}}
    <script type="application/ld+json">
    {
      "@context": "https://schema.org",
      "@type": "WebSite",
      "name": "{{ config('app.name', 'Stackvault') }}",
      "url": "{{ config('app.url') }}",
      "description": "@yield('description', 'Stackvault is your premier platform for digital asset trading, crypto staking, signal subscriptions, and copy trading. Manage your portfolio, make deposits and withdrawals, and refer friends.')",
      "potentialAction": {
        "@type": "SearchAction",
        "target": "{{ config('app.url') }}/search?q={search_term_string}",
        "query-input": "required name=search_term_string"
      }
    }
    </script>

</head>
{{-- Removed inline style for body background --}}
<body class="font-sans text-gray-100 antialiased bg-[#000]"> {{-- Changed text-gray-900 to text-gray-100 and added bg-[#000] --}}
    <div class="min-h-screen flex flex-col justify-center items-center py-6 sm:py-0"> {{-- Changed pt-6 sm:pt-0 to py-6 sm:py-0, removed bg-gray-100 dark:bg-[#000] as body handles bg --}}
        <div>
            <a href="/">
                {{-- Assuming x-application-logo component is set up for dark mode, otherwise use a static dark logo --}}
                {{-- If it's a monochrome logo, it might need to be white for dark backgrounds --}}
                <img src="{{ asset('images/login-logo-v2.png') }}" alt="stakeorbityield Logo" class="mx-auto w-40 sm:w-48">

            </a>
        </div>

        <div class="w-full sm:max-w-md mt-6 px-6 py-4 bg-[#131319] border border-gray-700 shadow-xl overflow-hidden rounded-lg"> {{-- Changed bg-white dark:bg-[#131319] to bg-[#131319] and added border, shadow-xl --}}
            {{ $slot }}
        </div>
    </div>
    <!-- <script src="//code.jivosite.com/widget/Nj06ckmk8i" async></script> -->
</body>
</html>
