<x-app-layout>
    <section class="py-8 antialiased md:py-16">
        <div class="mx-auto max-w-screen-xl px-4 2xl:px-0">
            <div class="mx-auto max-w-5xl py-">
                <h1 class="text-xl font-semibold text-white sm:text-2xl mt-10 display-2">Deposit</h1>

                <div class="mt-6 grow sm:mt-8 lg:mt-0">
                    <div class="box">
                        <div class="box-header with-border">
                            <h4 class="box-title">Payment Guide</h4>
                            <div class="box-controls pull-right">
                                <div class="lookup lookup-circle lookup-right">
                                <input type="text" name="s">
                                </div>
                            </div>
                        </div>
                        <div class="box-body">
                            <p class="text-gray-600">Make Payment to the Account details below, using the payment ID: <span class="text-2xl font-bold">{{$transactionId}}</span> as your description then click on "I have made Payment" and the admin will verify the payment then send it to your wallet.</p>
                        </div>
                    </div>
                </div>
                <div class="mt-6 sm:mt-8 lg:flex lg:items-start lg:gap-12">
                    <form action="" method="POST" class="w-full rounded-lg border border-gray-200 bg-white p-4 shadow-sm dark:border-gray-700 dark:bg-[#131319] sm:p-6 lg:p-8">
                        <div>{{$transactionId}}</div>
                        @csrf
                        <div class="mb-6 grid grid-cols-2 gap-4">
                            <div class="col-span-2">
                                <label for="amount" class="mb-2 block text-sm font-medium text-gray-900 dark:text-white"> Deposit Amount (USD)* </label>
                                <input type="number" id="amount" name="amount" class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-primary-500 focus:ring-primary-500 dark:border-gray-600  dark:placeholder:text-gray-400" placeholder="Enter Amount" required />
                            </div>

                            <div class="col-span-2">
                                <label for="option" class="mb-2 block text-sm font-medium text-gray-900 dark:text-white"> Deposit Option* </label>
                                <select id="payment_option" name="option" oncahnge="console.log('hello')" class="block w-full rounded-lg border border-gray-300 bg-gray-50 p-2.5 text-sm text-gray-900 focus:border-primary-500 focus:ring-primary-500  dark:text-white dark:placeholder:text-gray-400 required">
                                    <option value="bank">Bank Transfer</option>
                                    <option value="bitcoin">Bitcoin</option>
                                </select>
                            </div>
                        </div>
                        <div class="mt-6 grow sm:mt-8 lg:mt-0">
                            <div class="box">
                                <div class="box-header with-border">
                                    <h4 class="box-title">Account Details </h4>
                                </div>

                                <div class="box-body">
                                    <div id="account-details">
                                        <div>
                                            <span class="font-bold">Account Number: </span><span>0099338833</span>
                                        </div>
                                        <div>
                                            <span class="font-bold">Account Name: </span><span>Test Account</span>
                                        </div>
                                        <div>
                                            <span class="font-bold">Bank: </span><span>Union Bank</span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <input type="hidden" id="transaction_id" name="transaction_id" value="{{$transactionId}}" required />
                        <x-primary-button class="w-full text-white text-center font-bold py-2 px-4 rounded-lg">
                            {{ __('I have made Payment') }}
                        </x-primary-button>
                    </form>
                </div>
            </div>
        </div>
    </section>
    <script>
        const optionSelect = document.getElementById('payment_option');
        const accountDetails = document.getElementById('account-details');

        optionSelect.addEventListener('change', () => {
            const selectedOption = optionSelect.value;
            console.log(selectedOption);

        if (selectedOption === 'bank') {
            accountDetails.innerHTML = `
            <div>
                <span class="font-bold">Account Number: </span><span>0099338833</span>
            </div>
            <div>
                <span class="font-bold">Account Name: </span><span>Test Account</span>
            </div>
            <div>
                <span class="font-bold">Bank: </span><span>Union Bank</span>
            </div>
            `;
        } else if (selectedOption === 'bitcoin') {
            accountDetails.innerHTML = `
                <div>
                    <span class="font-bold">Wallet Address: </span><span>erxdtfyguhijokohgfdfgyuhjikohhhhhhhhhhhhhhhhhvvvvvvvvvvvvvvvvvvt</span>
                </div>
            `;
        } else {
            // Hide account details if no option is selected or an invalid option is selected
            // accountDetails.classList.add('hidden');
        }
        });
    </script>

<!-- Success Alert Modal -->
@if (session('success'))
<button type="button" class="btn btn-success hidden" data-bs-toggle="modal" data-bs-target="#success-alert-modal" id="trigger_success">Success Alert</button>
<div id="success-alert-modal" class="modal fade" style="background: rgba(0, 0, 0, 0.7);" tabindex="-1" role="dialog" aria-hidden="true">
	<div class="modal-dialog modal-dialog-centered">
		<div class="modal-content modal-filled bg-success">
			<div class="modal-body p-4">
				<div class="text-center">
					<i class="dripicons-checkmark h1"></i>
					<h2 class="mt-2">Well Done!</h2>
					<h2 class="mt-2 text-2xl">{{ session('transaction_id') }}</h2>
					<p class="mt-3">Your Deposit has been logged and will be added to your wallet once it is confirmed</p>
                    <div class="flex item-center justify-center gap-4">
                        <button type="button" class="btn btn-light my-2 bg-white" data-bs-dismiss="modal">Deposit Again</button>
                        <a type="button" class="btn btn-light my-2 bg-white" href="#">Go To Wallet</a>
                    </div>
				</div>
			</div>
		</div><!-- /.modal-content -->
	</div><!-- /.modal-dialog -->
</div><!-- /.modal -->
  <script>
    var modal = new bootstrap.Modal(document.getElementById('success-alert-modal'));
    modal.show();
  </script>
@endif
<script>
const button_success = document.querySelector('#trigger_success');


// Simulate a click event
button_success.click();
document.addEventListener('DOMContentLoaded', () => {
  window.addEventListener('load', () => {
    const triggerButton = document.getElementById('trigger-modal');
    button_success.click();
  });
});
// Close the modal when the close button is clicked
const closeButton = document.querySelector('.close-modal');
closeButton.addEventListener('click', hideModal);
    var modal = new bootstrap.Modal(document.getElementById('success-alert-modal'));
    modal.show();
  </script>
</x-app-layout>
