<div class="max-w-md mx-auto">
    <div class="bg-[#131319] rounded-lg shadow-inner border border-[#131319]">
        <div class="flex items-center justify-between">
            <div class="flex flex-1">
                <button id="buy-tab" class="py-3 px-6 text-center text-sm font-semibold transition-all duration-200 text-white bg-blue-600 rounded-tl-lg">
                    Buy Order
                </button>
                <button id="sell-tab" class="py-3 px-6 text-center text-sm font-semibold text-gray-400 transition-all duration-200 bg-gray-700 hover:text-white">
                    Sell Order
                </button>
            </div>
            <button class="py-2 px-4 text-gray-400 hover:text-white transition-colors duration-200" id="close-trading-box">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>

        <div id="trading_box_content" class="p-4 space-y-4 mt-0 border-2 border-blue-600">
            <div class="grid grid-cols-2 gap-4" id="tradingbox-summary-info">
                <div>
                    <p class="text-xs text-gray-400">Account</p>
                    <p class="text-sm text-white font-medium" id="account-name">-</p>
                </div>
                <div>
                    <p class="text-xs text-gray-400">Avg. Price</p>
                    <p class="text-sm text-white font-medium" id="avg-price">-</p>
                </div>
                <div>
                    <p class="text-xs text-gray-400">Avail. Liq</p>
                    <p class="text-sm text-white font-medium" id="available-funds">-</p>
                </div>
                <div>
                    <p class="text-xs text-gray-400">Avail. Shares</p>
                    <p class="text-sm text-white font-medium" id="available-shares">-</p>
                </div>
            </div>

            <div id="leverage-container" class="hidden">
                <p class="text-xs text-gray-400 mb-1">Leverage</p>
                <select id="leverage-input" class="w-full bg-[#131319] text-white border border-gray-700 rounded-lg py-2 px-3 focus:outline-none focus:ring-2 focus:ring-primary-500">
                    <option value="1">1:1 (None)</option>
                    <option value="50">1:50</option>
                    <option value="100" selected>1:100</option>
                    <option value="500">1:500</option>
                </select>
            </div>

            <div>
                <p class="text-xs text-gray-400 mb-1">Quantity</p>
                <div class="flex items-center space-x-2">
                    <div class="flex flex-col flex-1">
                        <input type="number" id="shares-quantity-input" class="w-full bg-[#131319] text-white border border-gray-700 rounded-lg py-2 px-3 focus:outline-none focus:ring-2 focus:ring-primary-500" placeholder="Shares" step="1">
                        <input type="number" id="fiat-quantity-input" class="hidden w-full bg-[#131319] text-white border border-gray-700 rounded-lg py-2 px-3 focus:outline-none focus:ring-2 focus:ring-primary-500" placeholder="USD" step="0.01">
                    </div>
                    <div class="bg-gray-700 rounded-lg grid grid-cols-2 p-1">
                        <button id="unit-shares" class="py-1 px-2 text-center text-sm font-semibold rounded-lg transition-colors duration-200 bg-gray-500 text-white">
                            Shares
                        </button>
                        <button id="unit-fiat" class="py-1 px-2 text-center text-sm font-semibold rounded-lg transition-colors duration-200 text-gray-400 hover:text-white">
                            USD
                        </button>
                    </div>
                </div>
            </div>

            <div class="bg-gray-700 rounded-lg flex-shrink-0 p-1 flex space-x-1">
                <button id="limit-btn" class="flex-1 py-1 px-4 text-sm font-semibold rounded-lg transition-colors duration-200 bg-gray-500 text-white">Limit</button>
                <button id="market-btn" class="flex-1 py-1 px-4 text-sm font-semibold rounded-lg transition-colors duration-200 text-gray-400 hover:text-white">Market</button>
                <button id="stop-btn" class="flex-1 py-1 px-4 text-sm font-semibold rounded-lg transition-colors duration-200 text-gray-400 hover:text-white">Stop</button>
            </div>

            <div id="order-fields">
                <div id="limit-fields" class="grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Limit Price</p>
                        <input type="number" id="limit-price" class="w-full bg-[#131319] text-white border border-gray-700 rounded-lg py-2 px-3" placeholder="Price" step="0.01">
                    </div>
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Time-in-force</p>
                        <div class="bg-gray-700 rounded-lg grid grid-cols-2 p-1">
                            <button id="tif-day" class="py-1 text-center text-sm font-semibold rounded-lg transition-colors duration-200 bg-gray-500 text-white">
                                Day
                            </button>
                            <button id="tif-gtc" class="py-1 text-center text-sm font-semibold rounded-lg transition-colors duration-200 text-gray-400 hover:text-white">
                                GTC
                            </button>
                        </div>
                    </div>
                </div>
                <div id="market-fields" class="hidden">
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Time-in-force</p>
                        <div class="bg-gray-700 rounded-lg grid grid-cols-2 p-1">
                            <button class="py-1 text-center text-sm font-semibold rounded-lg bg-gray-500 text-white">Day</button>
                            <button class="py-1 text-center text-sm font-semibold rounded-lg text-gray-400">GTC</button>
                        </div>
                    </div>
                </div>
                <div id="stop-fields" class="hidden grid grid-cols-2 gap-4">
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Stop Price</p>
                        <input type="number" id="stop-price" class="w-full bg-[#131319] text-white border border-gray-700 rounded-lg py-2 px-3" placeholder="Price" step="0.01">
                    </div>
                    <div>
                        <p class="text-xs text-gray-400 mb-1">Time-in-force</p>
                        <div class="bg-gray-700 rounded-lg grid grid-cols-2 p-1">
                            <button id="stop-tif-day" class="py-1 text-center text-sm font-semibold rounded-lg transition-colors duration-200 bg-gray-500 text-white">
                                Day
                            </button>
                            <button id="stop-tif-gtc" class="py-1 text-center text-sm font-semibold rounded-lg transition-colors duration-200 text-gray-400 hover:text-white">
                                GTC
                            </button>
                        </div>
                    </div>
                </div>
            </div>

            <div class="flex items-center space-x-2 text-sm text-gray-400">
                <input type="checkbox" id="fill-outside-rth" class="h-4 w-4 text-primary-600 bg-[#131319] border-gray-700 rounded" />
                <label for="fill-outside-rth">Fill outside RTH</label>
            </div>

            <div class="flex justify-between items-center text-sm font-bold text-gray-400">
                <p>Ask: <span id="ask-value" class="text-white">-</span></p>
                <p>Bid: <span id="bid-value" class="text-white">-</span></p>
            </div>

            <div class="flex justify-center relative">
                <button id="submit-order" class="w-full py-2 px-4 flex items-center justify-center rounded-lg text-white font-semibold bg-blue-600 hover:bg-blue-700 transition-colors">
                    <span id="submit-text">Submit Buy Order</span>
                    <span id="submit-spinner" class="hidden">
                        <svg class="animate-spin h-5 w-5 text-white" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24">
                            <circle class="opacity-25" cx="12" cy="12" r="10" stroke="currentColor" stroke-width="4"></circle>
                            <path class="opacity-75" fill="currentColor" d="M4 12a8 8 0 018-8V0C5.373 0 0 5.373 0 12h4zm2 5.291A7.962 7.962 0 014 12H0c0 3.042 1.135 5.824 3 7.938l3-2.647z"></path>
                        </svg>
                    </span>
                </button>
            </div>

            <div class="flex justify-between items-center text-sm text-gray-400">
                <span><span id="cost-label">Est. Total:</span> ≈<span id="estimated-total">$0.00</span></span>
            </div>
        </div>
    </div>
</div>
