<x-guest-layout>
    <div class="mb-4 text-sm text-gray-300">
        {{ __('Forgot your password? No problem. Just let us know your email address and we\'ll email you a password reset link that will allow you to choose a new one.') }}
    </div>

    {{-- Assuming x-auth-session-status is a Blade component that renders toast/alert messages --}}
    <x-auth-session-status class="mb-4 text-sm text-green-500" :status="session('status')" />

    <form method="POST" action="{{ route('password.email') }}">
        @csrf

        <div class="mb-4">
            <x-input-label for="email" :value="__('Email')" class="text-sm font-medium text-gray-300 mb-1" />
            <x-text-input
                id="email"
                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"
                type="email"
                name="email"
                :value="old('email')"
                required
                autofocus
            />
            <x-input-error :messages="$errors->get('email')" class="mt-2 text-red-400" />
        </div>

        <div class="flex items-center justify-end mt-6">
            <button
                type="submit"
                class="w-full text-white bg-primary-600 hover:bg-primary-700 focus:ring-4 focus:ring-primary-300 font-bold py-3 px-4 rounded-lg transition-colors duration-200"
            >
                {{ __('Email Password Reset Link') }}
            </button>
        </div>
    </form>
</x-guest-layout>
