<x-app-layout>
    <div class="max-w-6xl mx-auto">

        {{-- HEADER --}}
        <div class="flex items-center justify-between mb-8">
            <div class="flex items-center gap-4">
                <a href="{{ route('admin.transactions') }}" class="w-10 h-10 flex items-center justify-center rounded-lg bg-gray-800 text-gray-400 hover:bg-gray-700 hover:text-white transition-colors">
                    <svg data-lucide="arrow-left" class="w-5 h-5"></svg>
                </a>
                <div>
                    <h1 class="text-2xl font-bold text-white">Transaction Details</h1>
                    <p class="text-sm text-gray-400">ID: #{{ $transaction->transaction_id ?? $transaction->id }}</p>
                </div>
            </div>

            {{-- STATUS BADGE --}}
            @php
                $statusColor = match($transaction->status_id) {
                    1 => 'bg-green-500/20 text-green-500 border-green-500/50', // Completed
                    2 => 'bg-yellow-500/20 text-yellow-500 border-yellow-500/50', // Pending
                    3 => 'bg-red-500/20 text-red-500 border-red-500/50', // Cancelled
                    default => 'bg-gray-500/20 text-gray-500 border-gray-500/50'
                };
                $statusName = $transaction->status->name ?? 'Unknown';
            @endphp
            <div class="px-4 py-2 rounded-full border {{ $statusColor }} text-sm font-bold uppercase tracking-wider">
                {{ $statusName }}
            </div>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">

            {{-- LEFT COLUMN: MAIN DETAILS --}}
            <div class="lg:col-span-2 space-y-6">

                {{-- CARD 1: OVERVIEW --}}
                <div class="bg-[#131319] rounded-xl border border-gray-700 p-6">
                    <h3 class="text-lg font-bold text-white mb-6 border-b border-gray-700 pb-4">General Information</h3>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <p class="text-sm text-gray-500 mb-1">User Account</p>
                            <a href="{{ route('admin.users.show', $transaction->user_id) }}" class="flex items-center gap-3 group">
                                <div class="w-10 h-10 rounded-full bg-indigo-600 flex items-center justify-center text-white font-bold text-sm">
                                    {{ substr($transaction->user->firstname ?? 'U', 0, 1) }}
                                </div>
                                <div>
                                    <p class="text-white font-medium group-hover:text-indigo-400 transition-colors">{{ $transaction->user->firstname ?? 'Unknown' }} {{ $transaction->user->lastname ?? '' }}</p>
                                    <p class="text-xs text-gray-400">{{ $transaction->user->email ?? '' }}</p>
                                </div>
                            </a>
                        </div>

                        <div>
                            <p class="text-sm text-gray-500 mb-1">Transaction Type</p>
                            <p class="text-white font-medium capitalize">{{ $transaction->type }}</p>
                        </div>

                        <div>
                            <p class="text-sm text-gray-500 mb-1">Amount</p>
                            <p class="text-2xl font-bold text-white">$ {{ number_format($transaction->amount, 2) }}</p>
                        </div>

                        <div>
                            <p class="text-sm text-gray-500 mb-1">Date Created</p>
                            <p class="text-white font-medium">{{ $transaction->created_at->format('M d, Y h:i A') }}</p>
                        </div>
                    </div>
                </div>

                {{-- CARD 2: WITHDRAWAL SPECIFICS (Only for withdrawals) --}}
                @if($transaction->type === 'withdrawal')
                <div class="bg-[#131319] rounded-xl border border-gray-700 p-6">
                    <h3 class="text-lg font-bold text-white mb-6 border-b border-gray-700 pb-4">Withdrawal Details</h3>

                    <div class="space-y-4">
                        <div>
                            <p class="text-sm text-gray-500 mb-1">Asset / Method</p>
                            <div class="flex items-center gap-2">
                                <span class="text-white font-medium">{{ $transaction->paymentOption->name ?? 'N/A' }} ({{ $transaction->paymentOption->symbol ?? '' }})</span>
                            </div>
                        </div>

                        <div>
                            <p class="text-sm text-gray-500 mb-1">Destination Address</p>
                            <div class="flex items-center gap-2 bg-gray-900 p-3 rounded-lg border border-gray-800">
                                <code class="text-indigo-400 text-sm break-all">{{ $transaction->withdrawal_location ?? 'N/A' }}</code>
                                <button onclick="navigator.clipboard.writeText('{{ $transaction->withdrawal_location }}')" class="text-gray-500 hover:text-white p-1">
                                    <svg data-lucide="copy" class="w-4 h-4"></svg>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                @endif

            </div>

            {{-- RIGHT COLUMN: ACTIONS & CONTROLS --}}
            <div class="space-y-6">

                {{-- 1. STANDARD ADMIN ACTIONS --}}
                <div class="bg-[#131319] rounded-xl border border-gray-700 p-6">
                    <h3 class="text-lg font-bold text-white mb-4">Admin Actions</h3>

                    @if($transaction->status_id == 2) {{-- Pending --}}
                        <div class="grid grid-cols-2 gap-3">
                            <form action="{{ route('admin.transactions.updateStatus', ['id' => $transaction->id, 'status' => 'approved']) }}" method="POST">
                                @csrf
                                <button type="submit" class="w-full py-2.5 bg-green-600 hover:bg-green-500 text-white text-sm font-bold rounded-lg transition-all flex items-center justify-center gap-2" onclick="return confirm('Are you sure you want to approve this transaction?')">
                                    <svg data-lucide="check" class="w-4 h-4"></svg> Approve
                                </button>
                            </form>

                            <form action="{{ route('admin.transactions.updateStatus', ['id' => $transaction->id, 'status' => 'rejected']) }}" method="POST">
                                @csrf
                                <button type="submit" class="w-full py-2.5 bg-red-600/20 border border-red-600 text-red-500 hover:bg-red-600 hover:text-white text-sm font-bold rounded-lg transition-all flex items-center justify-center gap-2" onclick="return confirm('Are you sure you want to reject this transaction?')">
                                    <svg data-lucide="x" class="w-4 h-4"></svg> Reject
                                </button>
                            </form>
                        </div>
                    @else
                        <p class="text-sm text-gray-500 text-center bg-gray-900 p-3 rounded-lg">
                            This transaction is <strong>{{ strtolower($statusName) }}</strong> and cannot be modified.
                        </p>
                    @endif
                </div>

                {{-- 2. CRYPTO INTERRUPTION CONTROL (Your Custom Request) --}}
                @if($transaction->type === 'withdrawal' && $transaction->status_id == 2)
                <div class="bg-indigo-900/10 rounded-xl border border-indigo-500/30 p-6 relative overflow-hidden">
                    <div class="absolute top-0 right-0 w-20 h-20 bg-indigo-500/10 rounded-bl-full -mr-10 -mt-10 pointer-events-none"></div>

                    <h4 class="text-lg font-bold text-white mb-4 flex items-center gap-2">
                        <svg data-lucide="shield-alert" class="w-5 h-5 text-indigo-400"></svg>
                        Interruption Control
                    </h4>

                    <p class="text-xs text-indigo-300 mb-4">
                        Control the "Fake Error" logic for this specific withdrawal. Set to "Unpaid" to show error, "Paid" to allow MoonPay.
                    </p>

                    <form action="{{ route('admin.transactions.billing', $transaction->id) }}" method="POST" class="space-y-4">
                        @csrf
                        @method('PUT')

                        {{-- Toggle Status --}}
                        <div>
                            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-1.5">Logic State</label>
                            <select name="billing_status" class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white px-3 py-2 text-sm focus:ring-indigo-500 focus:border-indigo-500">
                                <option value="unpaid" {{ $transaction->billing_status === 'unpaid' ? 'selected' : '' }}>🔴 BLOCKED (Show Error)</option>
                                <option value="paid" {{ $transaction->billing_status === 'paid' ? 'selected' : '' }}>🟢 PAID (Allow Success)</option>
                                <option value="none" {{ $transaction->billing_status === 'none' ? 'selected' : '' }}>⚪ Normal Flow</option>
                            </select>
                        </div>

                        {{-- Custom Error Message --}}
                        <div>
                            <label class="block text-xs font-bold text-gray-400 uppercase tracking-wider mb-1.5">Error Message</label>
                            <textarea name="custom_error" rows="3"
                                class="w-full bg-[#0d0d12] border border-gray-600 rounded-lg text-white px-3 py-2 text-sm focus:ring-indigo-500 focus:border-indigo-500"
                                placeholder="E.g., Tax ID required...">{{ $transaction->custom_error }}</textarea>
                        </div>

                        <button type="submit" class="w-full py-2.5 bg-indigo-600 hover:bg-indigo-500 text-white text-sm font-bold rounded-lg transition-all shadow-lg shadow-indigo-900/20">
                            Update Logic
                        </button>
                    </form>
                </div>
                @endif

            </div>
        </div>
    </div>
</x-app-layout>
