{{-- resources/views/admin/stocks/form-fields.blade.php --}}
<div class="space-y-4 text-left">
    <div>
        <label for="name-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Stock Name</label>
        <input type="text" name="name" id="name-{{ $stock->id }}" value="{{ old('name', $stock->name) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="code-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Code</label>
        <input type="text" name="code" id="code-{{ $stock->id }}" value="{{ old('code', $stock->code) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="symbol-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Symbol</label>
        <input type="text" name="symbol" id="symbol-{{ $stock->id }}" value="{{ old('symbol', $stock->symbol) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="market-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Market</label>
        <select name="market" id="market-{{ $stock->id }}" required
                class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white focus:ring-primary-500 focus:border-primary-500">
            <option value="usd" {{ old('market', $stock->market) === 'usd' ? 'selected' : '' }}>USD</option>
            <option value="gbx" {{ old('market', $stock->market) === 'gbx' ? 'selected' : '' }}>GBX</option>
        </select>
    </div>
    <div>
        <label for="value-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Current Value</label>
        <input type="number" step="any" name="value" id="value-{{ $stock->id }}" value="{{ old('value', $stock->value) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="ask_value-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Ask Value</label>
        <input type="number" step="any" name="ask_value" id="ask_value-{{ $stock->id }}" value="{{ old('ask_value', $stock->ask_value) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="ask_shares-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Ask Shares</label>
        <input type="number" name="ask_shares" id="ask_shares-{{ $stock->id }}" value="{{ old('ask_shares', $stock->ask_shares) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="bid_value-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Bid Value</label>
        <input type="number" step="any" name="bid_value" id="bid_value-{{ $stock->id }}" value="{{ old('bid_value', $stock->bid_value) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="bid_shares-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Bid Shares</label>
        <input type="number" name="bid_shares" id="bid_shares-{{ $stock->id }}" value="{{ old('bid_shares', $stock->bid_shares) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="year_range_min-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Year Range Min</label>
        <input type="number" step="any" name="year_range_min" id="year_range_min-{{ $stock->id }}" value="{{ old('year_range_min', $stock->year_range_min) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="year_range_max-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">Year Range Max</label>
        <input type="number" step="any" name="year_range_max" id="year_range_max-{{ $stock->id }}" value="{{ old('year_range_max', $stock->year_range_max) }}" required
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
    <div>
        <label for="tradingview_code-{{ $stock->id }}" class="block text-sm font-medium text-gray-300 mb-1">TradingView Code</label>
        <input type="text" name="tradingview_code" id="tradingview_code-{{ $stock->id }}" value="{{ old('tradingview_code', $stock->tradingview_code) }}"
               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
    </div>
</div>
