<x-app-layout>
    <div class="max-w-4xl mx-auto">
        <a href="{{ route('admin.kyc.index') }}" class="text-gray-400 hover:text-white mb-6 inline-block">&larr; Back</a>

        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            {{-- Document Preview --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700">
                <h4 class="text-lg font-bold text-white mb-4">Submitted Document</h4>
                @if(Str::endsWith($user->kyc, '.pdf'))
                    <iframe src="{{ asset('storage/' . $user->kyc) }}" class="w-full h-[500px] border border-gray-600 rounded"></iframe>
                @else
                    <a href="{{ asset('storage/' . $user->kyc) }}" target="_blank">
                        <img src="{{ asset('storage/' . $user->kyc) }}" class="w-full h-auto rounded border border-gray-600 hover:opacity-90 transition" alt="KYC Doc">
                    </a>
                @endif
                <div class="mt-4 text-center">
                    <a href="{{ asset('storage/' . $user->kyc) }}" download class="text-indigo-400 text-sm hover:underline">Download Original File</a>
                </div>
            </div>

            {{-- Actions Panel --}}
            <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 h-fit">
                <h4 class="text-lg font-bold text-white mb-4">Application Details</h4>
                <div class="space-y-3 text-sm mb-8">
                    <p class="text-gray-400">Applicant: <span class="text-white">{{ $user->firstname }} {{ $user->lastname }}</span></p>
                    <p class="text-gray-400">Email: <span class="text-white">{{ $user->email }}</span></p>
                    <p class="text-gray-400">Status: <span class="text-white uppercase font-bold">{{ $user->kyc_status }}</span></p>
                    <p class="text-gray-400">Submitted: <span class="text-white">{{ $user->updated_at->diffForHumans() }}</span></p>
                </div>

                @if($user->kyc_status !== 'verified')
                    <div class="space-y-4">
                        <form action="{{ route('admin.kyc.approve', $user->id) }}" method="POST" onsubmit="return confirm('Approve this user?');">
                            @csrf
                            <button type="submit" class="w-full py-3 bg-green-600 hover:bg-green-500 text-white font-bold rounded-lg transition-all">
                                Approve & Verify
                            </button>
                        </form>

                        <div class="relative flex py-2 items-center">
                            <div class="flex-grow border-t border-gray-700"></div>
                            <span class="flex-shrink-0 mx-4 text-gray-500 text-xs">OR REJECT</span>
                            <div class="flex-grow border-t border-gray-700"></div>
                        </div>

                        <form action="{{ route('admin.kyc.reject', $user->id) }}" method="POST" class="space-y-3">
                            @csrf
                            <textarea name="reason" rows="3" required placeholder="Reason for rejection (e.g., blurry image, expired ID)..." class="w-full bg-gray-900 border border-gray-700 rounded-lg p-3 text-white text-sm focus:ring-red-500 focus:border-red-500"></textarea>
                            <button type="submit" class="w-full py-3 bg-red-600/20 border border-red-600 text-red-500 hover:bg-red-600 hover:text-white font-bold rounded-lg transition-all">
                                Reject Application
                            </button>
                        </form>
                    </div>
                @else
                    <div class="bg-green-900/20 border border-green-900 p-4 rounded text-center">
                        <p class="text-green-500 font-bold">This user is already verified.</p>
                        <p class="text-xs text-green-400 mt-1">Verified on {{ \Carbon\Carbon::parse($user->kyc_verified_at)->format('M d, Y') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
</x-app-layout>
