<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        @if ($errors->any())
            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-[#131319] dark:text-red-400" role="alert">
                <span class="font-medium">Please correct the following errors:</span>
                <ul class="mt-1.5 list-disc list-inside">
                    @foreach ($errors->all() as $error)
                        <li>{{ $error }}</li>
                    @endforeach
                </ul>
            </div>
        @endif
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Withdrawals</h4>
                <p class="mt-2 text-gray-400 text-sm">Review withdrawal requests and click on approve or decline.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="withdrawalSearch" placeholder="Search withdrawals..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="withdrawalTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Transaction ID</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">User</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Payment Type</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Wallet Address / Account Number</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Payment Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Action Date</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($withdrawals as $withdrawal)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">{{ $withdrawal->transaction_id }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300 capitalize">{{ $withdrawal->user->firstname }} {{ $withdrawal->user->lastname }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($withdrawal->amount, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300 capitalize">{{ $withdrawal->paymentOption->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300 break-all">{{ $withdrawal->withdrawal_location }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $withdrawal->created_at ? $withdrawal->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $withdrawal->action_at ? \Carbon\Carbon::parse($withdrawal->action_at)->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--' }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($withdrawal->status_id == 2) bg-yellow-600 text-white
                                @elseif($withdrawal->status_id == 1) bg-green-600 text-white
                                @else bg-red-600 text-white @endif">
                                {{ $withdrawal->status->name }}
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                @if($withdrawal->status_id == 2) {{-- Pending --}}
                                    <button type="button" onclick="openModal('approve-withdrawal-modal-{{$withdrawal->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-green-600 hover:bg-green-700 transition-colors duration-200 text-xs font-medium">Approve</button>
                                    <button type="button" onclick="openModal('confirm-decline-modal-{{$withdrawal->id}}')"
                                            class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Decline</button>
                                @elseif ($withdrawal->status_id == 1) {{-- Approved --}}
                                    <span class="px-3 py-1.5 rounded-md border border-green-500 text-green-500 text-xs font-medium">Approved</span>
                                @else {{-- Declined --}}
                                    <span class="px-3 py-1.5 rounded-md border border-red-500 text-red-500 text-xs font-medium">Declined</span>
                                @endif
                            </div>
                        </td>
                    </tr>

                    {{-- Approve Withdrawal Modal --}}
                    <x-modal id="approve-withdrawal-modal-{{$withdrawal->id}}">
                        <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                            <div class="text-white mb-6">
                                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <h2 class="mt-4 text-2xl font-bold">Approve Withdrawal</h2>
                                <p class="mt-2 text-white">Are you sure you want to approve withdrawal **{{ $withdrawal->transaction_id }}** for **${{ number_format($withdrawal->amount, 2) }}**?</p>
                            </div>
                            <form action="{{ url('/admin/transaction/approve') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <input type="number" step="any" name="amount" value="{{ $withdrawal->amount }}"
                                       class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500 mb-4 text-center disabled:opacity-75 disabled:cursor-not-allowed">
                                <input type="hidden" name="id" value="{{ $withdrawal->id }}">
                                <input type="hidden" name="type" value="withdrawal">
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">Yes, Approve</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('approve-withdrawal-modal-{{$withdrawal->id}}')">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>

                    {{-- Decline Withdrawal Modal --}}
                    <x-modal id="confirm-decline-modal-{{$withdrawal->id}}">
                        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                            <div class="text-white mb-6">
                                {{-- Lucide Icon via data attribute --}}
                                <svg data-lucide="x-circle" class="mx-auto h-16 w-16"></svg>
                                <h2 class="mt-4 text-2xl font-bold">Decline Withdrawal</h2>
                                <p class="mt-2 text-white">Are you sure you want to decline withdrawal **{{ $withdrawal->transaction_id }}** for **${{ number_format($withdrawal->amount, 2) }}**?</p>
                            </div>
                            <form action="{{ route('admin.transaction.decline') }}" method="POST">
                                @csrf
                                @method('PUT')
                                <input type="hidden" name="id" value="{{ $withdrawal->id }}">
                                <input type="hidden" name="type" value="withdrawal">
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Decline</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('confirm-decline-modal-{{$withdrawal->id}}')">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Toast Messages --}}
    @if (session('success'))
        <x-toast-success>Withdrawal Approved</x-toast-success>
    @endif
    @if (session('success_decline'))
        <x-toast-danger>Withdrawal Declined</x-toast-danger>
    @endif

    <script>
        // Modal Functions - ADD THESE TO FIX THE POPUP ISSUE
        function openModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                // Show the modal
                modal.style.display = 'flex';
                modal.style.alignItems = 'center';
                modal.style.justifyContent = 'center';
                modal.style.position = 'fixed';
                modal.style.top = '0';
                modal.style.left = '0';
                modal.style.width = '100%';
                modal.style.height = '100%';
                modal.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
                modal.style.zIndex = '1000';
                modal.style.backdropFilter = 'blur(4px)';

                // Prevent background scrolling
                document.body.style.overflow = 'hidden';

                // Add animation
                const modalContent = modal.querySelector('div');
                if (modalContent) {
                    modalContent.style.animation = 'modalSlideIn 0.3s ease-out';
                }
            }
        }

        function closeModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                // Hide the modal
                modal.style.display = 'none';

                // Restore background scrolling
                document.body.style.overflow = '';
            }
        }

        // Close modal when clicking outside
        document.addEventListener('click', function(event) {
            if (event.target.id && event.target.id.includes('modal') && !event.target.closest('.bg-green-700, .bg-red-700')) {
                closeModal(event.target.id);
            }
        });

        // Close modal with Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                // Find any open modals and close them
                const modals = document.querySelectorAll('[id*="modal"]');
                modals.forEach(modal => {
                    if (modal.style.display === 'flex') {
                        closeModal(modal.id);
                    }
                });
            }
        });

        // Add CSS for modal animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes modalSlideIn {
                from {
                    opacity: 0;
                    transform: scale(0.9) translateY(-20px);
                }
                to {
                    opacity: 1;
                    transform: scale(1) translateY(0);
                }
            }
        `;
        document.head.appendChild(style);

        // Existing table functionality
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('withdrawalTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr')); // Get all rows
            const searchInput = document.getElementById('withdrawalSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10; // Number of rows per page
            let currentPage = 1;
            let filteredRows = [];

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                // Ensure current page is valid after filtering
                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0) {
                    currentPage = 1; // Or handle no results, or hide pagination
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                // Clear current table rows
                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">No matching withdrawals found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="9" class="px-6 py-4 text-center text-gray-500">No withdrawals to display.</td></tr>`;
                }

                // Append paginated rows
                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5; // Max number of page buttons to display

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners
            searchInput.addEventListener('input', () => {
                currentPage = 1; // Reset to first page on new search
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
