<x-admin-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">
                    @if(isset($expertTrader))
                        Subscriptions for: <span class="text-primary-500">{{ $expertTrader->name }}</span>
                    @else
                        All User Replications
                    @endif
                </h4>
                <p class="mt-2 text-gray-400 text-sm">
                    @if(isset($expertTrader))
                        Viewing all users currently copying this plan.
                    @else
                        Viewing all copy-trading subscriptions across the platform.
                    @endif
                </p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                {{-- Back Button --}}
                <a href="{{ route('admin.expert-traders.index') }}"
                   class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-semibold transition-colors duration-200">
                    &larr; Back to Plans
                </a>

                {{-- Optional: Show 'View All' button if currently viewing specific expert --}}
                @if(isset($expertTrader))
                    <a href="{{ route('admin.expert-traders.subscriptions') }}"
                       class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">
                        View All
                    </a>
                @endif
            </div>
        </div>

        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">User</th>
                        {{-- Only show Expert Name column if we are viewing ALL subscriptions --}}
                        @if(!isset($expertTrader))
                            <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Plan Name</th>
                        @endif
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Allocated Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Current PNL</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Date Subscribed</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @forelse ($replications as $rep)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white">
                            {{ $rep->user->name ?? 'Unknown User' }}
                            <div class="text-xs text-gray-400 font-normal">{{ $rep->user->email ?? '' }}</div>
                        </td>

                        @if(!isset($expertTrader))
                            <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                                @if($rep->expertTrader)
                                    <a href="{{ route('admin.expert-traders.subscriptions', $rep->expertTrader->id) }}" class="hover:text-primary-400 underline">
                                        {{ $rep->expertTrader->name }}
                                    </a>
                                @else
                                    <span class="text-red-400 italic">Deleted Plan</span>
                                @endif
                            </td>
                        @endif

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            ${{ number_format($rep->allocated_amount, 2) }}
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                            <span class="{{ $rep->current_pnl >= 0 ? 'text-green-400' : 'text-red-400' }}">
                                {{ $rep->current_pnl >= 0 ? '+' : '' }}${{ number_format($rep->current_pnl, 2) }}
                            </span>
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                @if($rep->status === 'active') bg-green-600 text-white
                                @elseif($rep->status === 'paused') bg-yellow-600 text-white
                                @else bg-gray-600 text-white @endif">
                                {{ ucfirst($rep->status) }}
                            </span>
                        </td>

                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            {{ $rep->created_at->format('M d, Y') }}
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ isset($expertTrader) ? 5 : 6 }}" class="px-6 py-8 text-center text-gray-500 text-lg">
                            No subscriptions found.
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>

        <div class="mt-6">
            {{ $replications->links() }}
        </div>
    </div>
</x-admin-layout>
