<x-app-layout>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Coins</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage cryptocurrencies available on the platform.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="coinSearch" placeholder="Search coins..."
                       class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
                <button type="button" onclick="openModal('add-new-coin-modal')"
                        class="px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Add New Coin</button>
            </div>
        </div>

        <div class="overflow-x-auto">
            <table id="coinsTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Code</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Value (USD)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Stake APR (%)</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    @foreach ($coins as $coin)
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize">{{ $coin->name }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $coin->code }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">${{ number_format($coin->value, 2) }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">{{ $coin->stake_apr }}%</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <button type="button" onclick="openModal('edit-coin-modal-{{ $coin->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-blue-600 hover:bg-blue-700 transition-colors duration-200 text-xs font-medium">Edit</button>
                                <button type="button" onclick="openModal('delete-coin-modal-{{ $coin->id }}')"
                                        class="px-3 py-1.5 rounded-md text-white bg-red-600 hover:bg-red-700 transition-colors duration-200 text-xs font-medium">Delete</button>
                            </div>
                        </td>
                    </tr>

                    {{-- Edit Coin Modal --}}
                    <x-modal id="edit-coin-modal-{{ $coin->id }}">
                        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[70vh] overflow-y-auto">
                            <div class="border-b border-gray-700 pb-4 mb-6">
                                <h2 class="text-2xl font-bold text-white">Edit Coin: {{ $coin->name }}</h2>
                            </div>
                            <form action="{{ route('admin.coins.update', $coin->id) }}" method="POST">
                                @csrf
                                @method('PUT')
                                <div class="space-y-4 text-left">
                                    <div>
                                        <label for="name-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">Name</label>
                                        <input type="text" name="name" id="name-{{ $coin->id }}" value="{{ $coin->name }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                                    </div>
                                    <div>
                                        <label for="code-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">Code</label>
                                        <input type="text" name="code" id="code-{{ $coin->id }}" value="{{ $coin->code }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                                    </div>
                                    <div>
                                        <label for="api_name-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">API Name</label>
                                        <input type="text" name="api_name" id="api_name-{{ $coin->id }}" value="{{ $coin->api_name }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                                        <p class="mt-1 text-xs text-gray-400 uppercase">This should be the name of the coin on the Coingecko API. If blank or wrong, the price won't update properly.</p>
                                    </div>
                                    <div>
                                        <label for="value-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">Value (USD)</label>
                                        <input type="number" step="any" name="value" id="value-{{ $coin->id }}" value="{{ $coin->value }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                                    </div>
                                    <div>
                                        <label for="stake_apr-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">Stake APR (%)</label>
                                        <input type="number" step="any" name="stake_apr" id="stake_apr-{{ $coin->id }}" value="{{ $coin->stake_apr }}" required
                                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                                    </div>
                                    <div>
                                        <label for="account_details-{{ $coin->id }}" class="block text-sm font-medium text-gray-300 mb-1">Account Details</label>
                                        <textarea name="account_details" id="account_details-{{ $coin->id }}" rows="3" required
                                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">{{ $coin->account_details }}</textarea>
                                    </div>
                                </div>
                                <div class="flex justify-end gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200">Save Changes</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('edit-coin-modal-{{ $coin->id }}')">Cancel</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>

                    {{-- Delete Coin Modal --}}
                    <x-modal id="delete-coin-modal-{{ $coin->id }}">
                        <div class="bg-red-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-red-600">
                            <div class="text-white mb-6">
                                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                </svg>
                                <h2 class="mt-4 text-2xl font-bold">Delete Coin</h2>
                                <p class="mt-2 text-white">Are you sure you want to delete <span class="font-semibold">{{ $coin->name }} ({{ $coin->code }})</span>?</p>
                            </div>
                            <form action="{{ route('admin.coins.destroy', $coin->id) }}" method="POST">
                                @csrf
                                @method('DELETE')
                                <input type="hidden" name="id" value="{{ $coin->id }}">
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-red-700 font-semibold rounded-lg transition-colors duration-200">Yes, Delete</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('delete-coin-modal-{{ $coin->id }}')">No</button>
                                </div>
                            </form>
                        </div>
                    </x-modal>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
                </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    {{-- Add New Coin Modal --}}
    <x-modal id="add-new-coin-modal">
        <div class="bg-[#131319] rounded-lg shadow-xl p-8 max-w-lg w-full text-center border border-gray-700 max-h-[70vh] overflow-y-auto">
            <div class="border-b border-gray-700 pb-4 mb-6">
                <h2 class="text-2xl font-bold text-white">Add New Coin</h2>
            </div>
            <form action="{{ route('admin.coins.store') }}" method="POST">
                @csrf
                <div class="space-y-4 text-left">
                    <div>
                        <label for="new_name" class="block text-sm font-medium text-gray-300 mb-1">Coin Name</label>
                        <input type="text" name="name" id="new_name" maxlength="15" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_code" class="block text-sm font-medium text-gray-300 mb-1">Code</label>
                        <input type="text" name="code" id="new_code" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_api_name" class="block text-sm font-medium text-gray-300 mb-1">API Name</label>
                        <input type="text" name="api_name" id="new_api_name" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                        <p class="mt-1 text-xs text-gray-400 uppercase">This should be the name of the coin on the Coingecko API. If blank or wrong, the price won't update properly.</p>
                    </div>
                    <div>
                        <label for="new_value" class="block text-sm font-medium text-gray-300 mb-1">Value (USD)</label>
                        <input type="number" step="any" name="value" id="new_value" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_stake_apr" class="block text-sm font-medium text-gray-300 mb-1">Stake APR (%)</label>
                        <input type="number" step="any" name="stake_apr" id="new_stake_apr" required
                               class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500">
                    </div>
                    <div>
                        <label for="new_account_details" class="block text-sm font-medium text-gray-300 mb-1">Account Details</label>
                        <textarea name="account_details" id="new_account_details" rows="3" required
                                  class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"></textarea>
                    </div>
                </div>
                <div class="flex justify-center gap-4 mt-6">
                    <button type="submit" class="px-6 py-2 bg-green-600 hover:bg-green-700 text-white font-semibold rounded-lg transition-colors duration-200">Add Coin</button>
                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('add-new-coin-modal')">Cancel</button>
                </div>
            </form>
        </div>
    </x-modal>

    <script>
        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('coinsTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr')); // Get all rows
            const searchInput = document.getElementById('coinSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10; // Number of rows per page
            let currentPage = 1;
            let filteredRows = [];

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                // Ensure current page is valid after filtering
                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1; // Show no results if search term exists
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1; // Stay on page 1 if no data and no search
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                // Clear current table rows
                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="5" class="px-6 py-8 text-center text-gray-500">No matching coins found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                     tbody.innerHTML = `<tr><td colspan="5" class="px-6 py-8 text-center text-gray-500">No coins to display.</td></tr>`;
                }

                // Append paginated rows
                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5; // Max number of page buttons to display

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners
            searchInput.addEventListener('input', () => {
                currentPage = 1; // Reset to first page on new search
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });

            // Initial render
            renderTable();
        });
    </script>
</x-app-layout>
