<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('expert_traders', function (Blueprint $table) {
            // Add new columns for plan structure
            $table->decimal('min_investment_amount', 15, 2)->after('email')->default(0.00); // Changed from description to after email
            $table->decimal('max_investment_amount', 15, 2)->after('min_investment_amount')->default(0.00);
            $table->integer('expected_duration_value')->after('max_investment_amount')->default(0);
            $table->string('expected_duration_unit')->after('expected_duration_value')->default('days'); // e.g., days, months, years
            $table->string('risk_level')->after('expected_duration_unit')->default('Medium'); // e.g., Low, Medium, High
            $table->json('features')->nullable()->after('risk_level'); // To store an array of features

            // Rename success_rate_percentage to expected_roi_percentage
            $table->renameColumn('success_rate_percentage', 'expected_roi_percentage');

            // You might need to adjust default values or make columns nullable if not adding defaults
            // Or use after() to place them correctly
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('expert_traders', function (Blueprint $table) {
            // Drop new columns
            $table->dropColumn([
                'min_investment_amount',
                'max_investment_amount',
                'expected_duration_value',
                'expected_duration_unit',
                'risk_level',
                'features',
            ]);

            // Revert column name
            $table->renameColumn('expected_roi_percentage', 'success_rate_percentage');
        });
    }
};
