<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class VirtualCard extends Model
{
    // 1. Remove 'balance' from fillable.
    // Since this value comes from the User, we don't want to accidentally
    // try to save it to the virtual_cards table.
    protected $fillable = [
        'user_id',
        'card_number',
        'cvv',
        'expiry_month',
        'expiry_year',
        'status'
    ];

    // 2. (Optional) Append the virtual attribute if you are converting this model to JSON/Array
    protected $appends = ['balance'];

    public function user() {
        return $this->belongsTo(User::class);
    }

    /**
     * Accessor for the 'balance' attribute.
     * When you call $virtualCard->balance, this runs.
     */
    public function getBalanceAttribute()
    {
        // Check if user exists to prevent errors, return 0 or user balance
        return $this->user ? $this->user->balance : 0;
    }
}
