<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserReplication extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'expert_trader_id',
        'allocated_amount',
        'current_pnl',
        'status', // 'active', 'paused', 'stopped'
    ];

    protected $casts = [
        'allocated_amount' => 'float',
        'current_pnl' => 'float',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function expertTrader()
    {
        return $this->belongsTo(ExpertTrader::class)->withTrashed();
    }
}
