<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Transaction extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'user_id',
        'transaction_id',
        'amount',
        'details',
        'amount_release',
        'payment_option_id', // Stores the Coin ID (e.g., BTC ID)
        'wallet_option_id',
        'action_at',
        'action_by',
        'status_id',
        'withdrawal_location', // Stores the Recipient Wallet Address
        'type', // Will be 'withdrawal'
        'billing_status', // NEW: 'unpaid' triggers the error, 'paid' allows success
        'custom_error',   // NEW: The error message shown to user
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function status(): BelongsTo
    {
        return $this->belongsTo(PaymentStatus::class);
    }

    public function paymentOption(): BelongsTo
    {
        return $this->belongsTo(Coin::class, 'payment_option_id', 'id');
    }

    public function walletOption(): BelongsTo
    {
        return $this->belongsTo(Coin::class, 'wallet_option_id', 'id');
    }

    protected static function boot()
    {
        parent::boot();

        static::updating(function ($transaction) {
            if ($transaction->isDirty('status_id') && in_array($transaction->status_id, [1, 3])) {
                $transaction->action_at = now();
                $transaction->action_by = auth()->id();
            }
        });
    }
}
