<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class StockTrade extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'stock_id',
        'trade_action', // 'buy' or 'sell'
        'quantity',
        'price_per_share',
        'account_type', // 'gbx_balance' or 'usd_balance'
        'order_type', // 'market', 'limit', etc. (optional, but good for history)
        'executed_at', // Timestamp of when the trade was executed
    ];

    protected $casts = [
        'price_per_share' => 'decimal:8', // Adjust precision as needed
        'executed_at' => 'datetime',
    ];

    /**
     * Get the user who executed the trade.
     */
    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    /**
     * Get the stock involved in the trade.
     */
    public function stock(): BelongsTo
    {
        return $this->belongsTo(Stock::class);
    }

    /**
     * Get the associated transaction.
     */
    public function transaction(): BelongsTo
    {
        return $this->belongsTo(Transaction::class, 'stock_trade_id');
    }
}
