<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class PaymentOption extends Model
{
    use HasFactory;
    use SoftDeletes;

    protected $fillable = [
        'name',
        'account_details',
    ];
    protected $dates = ['deleted_at'];

    public function transactions()
    {
        return $this->hasMany(Transactions::class);
    }
}
