<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\HasMany;

class InvestmentPlan extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'name',
        'description',
        'min_investment',
        'max_investment',
        'daily_roi_percentage',
        'total_roi_percentage', // Calculated total ROI
        'min_duration_value',   // NEW: Minimum duration user can choose
        'max_duration_value',   // NEW: Maximum duration user can choose
        'allowed_duration_units', // NEW: Units user can choose (e.g., ['days', 'months'])
        'features',
        'created_by',
    ];

    protected $casts = [
        'min_investment' => 'float',
        'max_investment' => 'float',
        'daily_roi_percentage' => 'float',
        'total_roi_percentage' => 'float',
        'min_duration_value' => 'integer',    // NEW
        'max_duration_value' => 'integer',    // NEW
        'allowed_duration_units' => 'array',  // NEW (JSON storage)
        'features' => 'array',
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
        'deleted_at' => 'datetime',
    ];

    public function userFixedInvestments(): HasMany
    {
        return $this->hasMany(UserFixedInvestment::class);
    }
}
