<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ForexWallet extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'forex_pair_id',
        'balance',          // Total Units held
        'avg_entry_price',  // Weighted average price
        'avg_leverage',     // Average leverage used
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function pair()
    {
        return $this->belongsTo(ForexPair::class, 'forex_pair_id');
    }
}
