<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class ForexTrade extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'forex_pair_id',
        'type',           // 'buy' or 'sell'
        'entry_price',
        'quantity',       // Units
        'leverage_used',  // Leverage selected by user
        'margin_amount',  // Real USD deducted
        'executed_at',
    ];

    protected $casts = [
        'executed_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function pair()
    {
        return $this->belongsTo(ForexPair::class, 'forex_pair_id');
    }
}
