<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Http;
use Carbon\Carbon;

class Coin extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = ['name', 'code', 'stake_apr', 'value', 'api_name', 'account_details'];

    public function walletCoins()
    {
        return $this->hasMany(WalletCoin::class); // Exclude soft deleted wallet coins
    }

    // public static function boot()
    // {
    //     parent::boot();

    //     static::created(fn($coin) => $coin->updateCoinValuesFromApi());
    //     static::updated(fn($coin) => $coin->updateCoinValuesFromApi());
    // }

    // public function getAttribute($key)
    // {
    //     if ($key === 'value') {
    //         $this->updateCoinValuesFromApi();
    //     }
    //     return parent::getAttribute($key);
    // }


    public function updateCoinValuesFromApi()
    {

        if ($this->name != 'Dollars' && ($this->updated_at === null || $this->updated_at->lessThan(now()->subDay()))) {
            // dd("Coin  API ran");

            try {
                $response = Http::get("https://api.coingecko.com/api/v3/simple/price", [
                    'ids' => $this->api_name,
                    'vs_currencies' => 'usd',
                ]);

                if ($response->successful()) {
                    $data = $response->json();
                    if (isset($data[$this->api_name]['usd'])) {
                        $this->setAttribute('value', $data[$this->api_name]['usd']);
                        $this->saveQuietly(); // Prevent infinite loop from model events
                        \Log::info("Coin {$this->name} updated successfully. New value: {$this->value}");
                        // dd("Coin {$this->name} API ran");
                    }
                } else {
                    \Log::error("CoinGecko API error for {$this->name} ({$this->api_name}): " . $response->status());
                    // dd("Coin {$this->name} API ran not found".$response->status());
                }
            } catch (\Exception $e) {
                \Log::error("Error updating coin {$this->name}: " . $e->getMessage());
                // dd("Coin {$this->api_name} API ran error". $e->getMessage());

            }
        }
    }

    public function getAuthWalletCoinAttribute()
    {
        if (Auth::check() && Auth::user()->wallet) {
            return $this->walletCoins()
                        ->whereBelongsTo(Auth::user()->wallet)
                        ->first();
        }

        return null;
    }
}
