<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class InvestmentDisbursedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $investment;

    public function __construct($investment)
    {
        $this->investment = $investment;
    }

    public function build()
    {
        return $this->subject('Investment Disbursed')
                    ->view('emails.investment_disbursed');
    }
}
