<?php
namespace App\Jobs;

use App\Models\Coin;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class UpdateCoinValuesJob implements ShouldQueue
{
    use Queueable, InteractsWithQueue, SerializesModels;

    public function handle()
    {
        $coins = Coin::where('name', '!=', 'Dollars')->get();

        foreach ($coins as $coin) {
            $coin->updateCoinValuesFromApi(); // Call your API method here
        }

        \Log::info('✅ Coin values updated successfully by Job.');
    }
}
