<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class CheckRole
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    // public function handle(Request $request, Closure $next, $role)
    // {
    //     if (auth()->user()->role_id != $role) {
    //         return redirect()->back()->with('error', 'Unauthorized access.');
    //     }

    //     return $next($request);
    // }
    public function handle(Request $request, Closure $next, ...$roles)
    {
        if (auth()->check() && in_array(auth()->user()->role_id, $roles)) {
            return $next($request);
        }

        abort(403, 'Unauthorized');
    }
}
