<?php

namespace App\Http\Controllers;

use App\Models\PaymentOption;
use App\Models\Trade;
use App\Models\Wallet;
use App\Models\Coin;
use Illuminate\Http\Request;
use Carbon\Carbon;

class TradeController extends Controller
{
    public function index()
    {
        $options = PaymentOption::all();
        return view('trade', compact('options'));
    }
    public function tradeHistory()
    {
        $trades = Trade::orderByDesc('created_at')->where('user_id', auth()->user()->id )->get();
        return view('trade-history', compact('trades'));
    }

    public function store(Request $request)
    {
        $request->validate([
            'trade_amount' => 'required|numeric|min:1',
            'market' => 'required|string',
            'pair' => 'required|string',
            'timer' => 'required|integer',
            'trade_action' => 'required|in:buy,sell',
        ]);

        if (isset($errors) && $errors->any()) {
            // Handle errors, e.g., redirect back with error messages
            return back()->withErrors($errors)->withInput();
        }

        // removing amount from wallet
        $wallet = Wallet::where('user_id', auth()->id())->first();
        // $wallet->decrement('balance', $request->input('trade_amount'));
        if ($wallet) {
            $usdCoin = Coin::where('code', 'USD')->first();

            if ($usdCoin) {
                $walletCoin = $wallet->walletCoins()->where('coin_id', $usdCoin->id)->first();

                if ($walletCoin && $walletCoin->balance >= $request->input('trade_amount')) {
                    $walletCoin->decrement('balance', $request->input('trade_amount'));
                } else {
                    // Handle insufficient funds or USD coin not found
                    // For example, return an error message:
                    return response()->json(['error' => 'Insufficient funds or USD coin not found'], 400);
                }

            } else {
                //Handle usd coin not found
                return response()->json(['error' => 'USD coin not found'], 400);
            }

        } else {
            // Handle wallet not found
            return response()->json(['error' => 'Wallet not found'], 404);
        }

        // Create a new Trade instance
        Trade::create([
            'user_id' => auth()->id(), // Assuming authenticated user
            'amount' => $request->input('trade_amount'),
            'market' => $request->input('market'),
            'pair' => $request->input('pair'),
            'timer' => $request->input('timer'),
            'trade_action' => $request->input('trade_action'),
            'stop_loss'=> $request->input('stop_loss'),
        ]);

        return redirect()->back()->with('success', 'Trade created successfully.');
    }


    public function admin_view_trades()
    {
        $trades = Trade::orderByDesc('created_at')->get();
        return view('admin-dash.trades', compact('trades'));
    }
    public function admin_update_trade(Request $request)
    {
        $request->validate([
            'pnl' => 'required|string|in:loss,profit',
            'pnl_amount' => 'required|string',
        ]);

        $id = $request['id'];
        $trade = Trade::findOrFail($id);

        $trade->pnl = $request->input('pnl_amount');
        $trade->status = 1;
        $trade->outcome = $request['pnl']==='loss'? '-':'+';
        $trade->exit_time = Carbon::now('Africa/Lagos');

        // Update the wallet balance
        // $wallet = Wallet::where('user_id', $trade->user->id)->first();

        // if ($request->input('pnl') == 'loss') {
        //     $approved_amount = $trade->amount - $request['pnl_amount'];
        // } else {
        //     $approved_amount = $trade->amount + $request['pnl_amount'];
        // }
        // $wallet->increment('balance', $approved_amount);
        // Update the wallet balance
        $wallet = Wallet::where('user_id', $trade->user->id)->first();

        if ($wallet) {
            $usdCoin = Coin::where('code', 'USD')->first();

            if ($usdCoin) {
                $walletCoin = $wallet->walletCoins()->where('coin_id', $usdCoin->id)->first();

                if ($walletCoin) {
                    if ($request->input('pnl') == 'loss') {
                        $approved_amount = $trade->amount - $request['pnl_amount'];
                        if ($approved_amount < 0) {
                            $approved_amount = 0;
                        }
                        $walletCoin->decrement('balance', $trade->amount);
                        if($request['pnl_amount'] > $trade->amount){
                            //handle error or log, loss amount greater than trade amount
                        }else{
                            $walletCoin->increment('balance', $approved_amount);
                        }

                    } else {
                        $approved_amount = $trade->amount + $request['pnl_amount'];
                        $walletCoin->increment('balance', $approved_amount);
                    }
                } else {
                    // Handle USD wallet coin not found
                    // Log or return an error
                }
            } else {
                // Handle USD coin not found
                // Log or return an error
            }
        } else {
            // Handle wallet not found
            // Log or return an error
        }

        $trade->save();
        $wallet->save();

        return redirect()->back()->with('success', 'Trade updated successfully.');
    }

    public function destroy(PaymentOption $paymentOption)
    {

        $paymentOption->delete();

        return redirect()->back()->with('delete_success', 'Payment option deleted successfully.');
    }
}
