<?php

namespace App\Http\Controllers;

use App\Models\PaymentOption;
use App\Models\InvestmentPlan;
use App\Models\Investment;
use App\Models\Referral;
use App\Models\Wallet;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Carbon\Carbon;
use Illuminate\Support\Str;

class ReferralController extends Controller
{
    public function generateUniqueId()
    {
        $user = auth()->user();
        $userId = $user->id;

        do {
            $uniqueID = strtoupper(Str::random(8)) . '_' . $userId;
        } while (User::where('referral_code', $uniqueID)->exists());

        return $uniqueID;
    }

    // public function view()
    // {
    //     $user = auth()->user();

    //     if (!$user->referral_code) {
    //         $referral_code = $this->generateUniqueId();
    //         $user->referral_code = $referral_code;
    //         $user->save();
    //     } else {
    //         $referral_code = $user->referral_code;
    //     }

    //     return view('referral', compact('referral_code'));
    // }

    public function view()
    {
        $user = Auth::user();

        if (!$user->referral_code) {
            $referral_code = $this->generateUniqueId();
            $user->referral_code = $referral_code;
            $user->save();
        } else {
            $referral_code = $user->referral_code;
        }

        // Fetch referred users
        $referrals = User::where('referrer_code', $user->referral_code)
                         ->latest()
                         ->paginate(10);

        return view('user.referral.index', compact('user', 'referrals'));
    }

    public function index()
    {
        $referrals = Referral::all();
        return view('admin-dash.referrals', compact('referrals'));
    }

    public function update(Request $request, Referral $referral)
    {
        $request->validate([
            'amount' => 'required|string',
        ]);
        $refererWallet = $referral->referer->wallet;

        $referral->status_id = 1;
        $referral->referee;
        $refererWallet->increment('bonus', $request['amount']);
        $referral->date_disbursed = Carbon::now('Africa/Lagos');
        $referral->bonus = $request['amount'];

        $referral->save();

        // $referral->referer->wallet->increment('bonus', $request['amount']);
        // $wallet->increment('balance', $request['amount']);

        // increment($referral->referer->wallet->bonus);
        // dd($refererWallet->bonus, $referral->action_by, 'hello', $request['amount']);

        return redirect()->back()->with('success', 'Refund request logged successfully.');
    }

    // public function store(Request $request)
    // {
    //     $request->validate([
    //         'investment_id' => 'required|max:16',
    //         'reason' => 'required|string',
    //     ]);

    //     // Check if there's an existing pending refund for the same investment ID
    //     $existingRefund = Refund::where('investment_id', $request->investment_id)
    //         ->where('status_id', 2)
    //         ->first();

    //     if ($existingRefund) {
    //     return redirect()->back()->with('error', 'A pending refund request already exists for this investment.');
    //     }


    //     $refund_id = $this->generateUniqueId();
    //     $refund = new Refund([
    //         'refund_id' => $refund_id,
    //         'user_id' => Auth::id(),
    //         'investment_id' => $request['investment_id'],
    //         'reason' => $request['reason']
    //     ]);
    //     $refund->save();
    //     return redirect()->back()->with('success', 'Refund request logged successfully.')->with('refund_id', $refund_id);
    // }

    public function destroy(Referral $paymentOption)
    {

        $paymentOption->delete();

        return redirect()->back()->with('delete_success', 'Payment option deleted successfully.');
    }
}
