<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Http\RedirectResponse;
use Illuminate\View\View;
use App\Models\InvestmentPlan;
use App\Models\Stock;
use App\Models\ForexPair;
use App\Models\VirtualCard;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;
use Illuminate\Support\Str;

class DashboardController extends Controller
{
    public function index(Request $request)
    {
        $user = auth()->user();

        // 1. New User Logic
        if ($user->is_new == 1) {
            session()->flash('success_register', 'Registration successful! Please check your email for further instructions.');
            $user->update(['is_new' => 0]);
        }

        // 2. Redirect Admin
        if($user->role_id === "1" || $user->role_id === 1){
            return redirect()->route('admin.users.view');
        }

        // 3. Fetch Data
        $stocks = Stock::all();
        $forexPairs = ForexPair::where('is_active', 1)->get();

        // 4. --- VIRTUAL CARD LOGIC ---
        $card = VirtualCard::where('user_id', $user->id)->first();

        // Auto-generate card if one doesn't exist (Safety net for old users)
        if (!$card) {
            do {
                $cardNumber = '4' . str_pad(mt_rand(1, 999999999999999), 15, '0', STR_PAD_LEFT);
            } while (VirtualCard::where('card_number', $cardNumber)->exists());

            $expiryDate = Carbon::now()->addYears(3);

            $card = VirtualCard::create([
                'user_id'      => $user->id,
                'card_number'  => $cardNumber,
                'cvv'          => str_pad(mt_rand(1, 999), 3, '0', STR_PAD_LEFT),
                'expiry_month' => $expiryDate->format('m'),
                'expiry_year'  => $expiryDate->format('Y'),
                'status'       => 'inactive',
                'balance'      => 0,
            ]);
        }

        // Fetch the custom error message
        $customError = DB::table('site_settings')->where('key', 'crypto_send_error')->value('value');

        // 5. Return View
        return view('dashboard', [
            'customError' => $customError,
            'stocks'     => $stocks,
            'forexPairs' => $forexPairs,
            'card'       => $card, // Pass the card to the view
        ]);
    }
}
