<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\UserSignalSubscription;
use Illuminate\Http\Request;

class AdminUserSignalSubscriptionController extends Controller
{
    /**
     * Display a listing of all user signal subscriptions.
     */
    public function index()
    {
        // Eager load related models (user and signal), including soft-deleted ones
        $subscriptions = UserSignalSubscription::with([
            'user' => function ($query) {
                $query->withTrashed(); // Include soft-deleted users
            },
            'signal' => function ($query) {
                $query->withTrashed(); // Include soft-deleted signals
            }
        ])
        ->latest() // Order by latest created subscriptions
        ->get();

        // Make sure your view path is correct: 'admin.signal-subscriptions.index'
        return view('admin-dash.signal-subscriptions.index', compact('subscriptions'));
    }

    // You might add methods for 'cancel' or 'extend' here if those become admin actions
    public function cancel(Request $request, UserSignalSubscription $subscription)
    {
        // Logic to cancel the subscription
        $subscription->update(['status' => 'canceled']);
        return redirect()->back()->with('success', 'Subscription canceled successfully.');
    }
}
