<?php include 'includes/header.php'; ?>

<main class="relative min-h-screen w-full bg-cover bg-center bg-no-repeat font-sans text-white" style="background-image: url('https://images.unsplash.com/photo-1506744038136-46273834b3fb?q=80&w=2070&auto=format&fit=crop');">
    
    <div class="absolute inset-0 bg-gradient-to-b from-[#1a1a2e]/80 via-[#2d1b4e]/80 to-[#1a1a2e]/90 mix-blend-multiply z-0"></div>
    <div class="absolute inset-0 bg-black/30 z-0"></div>

    <div class="relative z-10 flex flex-col items-center justify-center min-h-screen px-6 py-32">
        
        <div class="text-center mb-16 max-w-2xl">
            <h1 class="text-4xl md:text-5xl font-light mb-4 tracking-tight">How can we help you?</h1>
            <p class="text-sm md:text-base text-gray-300 font-light leading-relaxed">
                We are here to help! Please, find answers to the frequently asked questions below or reach out to us.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 w-full max-w-6xl mb-24">
            
            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-pink-500/20 flex items-center justify-center text-pink-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M11.49 3.17c-.38-1.56-2.6-1.56-2.98 0a1.532 1.532 0 01-2.286.948c-1.372-.836-2.942.734-2.106 2.106.54.886.061 2.042-.947 2.287-1.561.379-1.561 2.6 0 2.978a1.532 1.532 0 01.947 2.287c-.836 1.372.734 2.942 2.106 2.106a1.532 1.532 0 012.287.947c.379 1.561 2.6 1.561 2.978 0a1.533 1.533 0 012.287-.947c1.372.836 2.942-.734 2.106-2.106a1.533 1.533 0 01.947-2.287c1.561-.379 1.561-2.6 0-2.978a1.532 1.532 0 01-.947-2.287c.836-1.372-.734-2.942-2.106-2.106a1.532 1.532 0 01-2.287-.947zM10 13a3 3 0 100-6 3 3 0 000 6z" clip-rule="evenodd"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Getting started</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-purple-500/20 flex items-center justify-center text-purple-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path d="M10.894 2.553a1 1 0 00-1.788 0l-7 14a1 1 0 001.169 1.409l5-1.429A1 1 0 009 15.571V11a1 1 0 112 0v4.571a1 1 0 00.725.962l5 1.428a1 1 0 001.17-1.408l-7-14z"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Transaction Not Sent</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-blue-500/20 flex items-center justify-center text-blue-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Buy Crypto with Fiat</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-blue-400/20 flex items-center justify-center text-blue-300 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path d="M4 4a2 2 0 00-2 2v1h16V6a2 2 0 00-2-2H4z"/><path fill-rule="evenodd" d="M18 9H2v5a2 2 0 002 2h12a2 2 0 002-2V9zM4 13a1 1 0 011-1h1a1 1 0 110 2H5a1 1 0 01-1-1zm5-1a1 1 0 100 2h1a1 1 0 100-2H9z" clip-rule="evenodd"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Withdrawal to Bank Account</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-cyan-500/20 flex items-center justify-center text-cyan-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M18 10a8 8 0 11-16 0 8 8 0 0116 0zm-7 4a1 1 0 11-2 0 1 1 0 012 0zm-1-9a1 1 0 00-1 1v4a1 1 0 102 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Transaction Pending</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-teal-500/20 flex items-center justify-center text-teal-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 7h12m0 0l-4-4m4 4l-4 4m0 6H4m0 0l4 4m-4-4l4-4"></path></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Can Not Swap Crypto</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-green-500/20 flex items-center justify-center text-green-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M2 5a2 2 0 012-2h12a2 2 0 012 2v10a2 2 0 01-2 2H4a2 2 0 01-2-2V5zm3.293 1.293a1 1 0 011.414 0l3 3a1 1 0 010 1.414l-3 3a1 1 0 01-1.414-1.414L7.586 10 5.293 7.707a1 1 0 010-1.414zM11 12a1 1 0 100 2h3a1 1 0 100-2h-3z" clip-rule="evenodd"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide">Lost Access to Wallet</span>
            </a>

            <a href="#" class="group bg-[#1e1e2f]/60 backdrop-blur-md border border-white/5 rounded-lg p-8 flex flex-col items-center justify-center gap-4 hover:bg-[#2a2a40]/80 transition duration-300 hover:-translate-y-1 shadow-lg">
                <div class="w-12 h-12 rounded-full bg-yellow-500/20 flex items-center justify-center text-yellow-400 group-hover:scale-110 transition">
                    <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M12 7a1 1 0 110-2h5a1 1 0 011 1v5a1 1 0 11-2 0V8.414l-4.293 4.293a1 1 0 01-1.414 0L8 10.414l-4.293 4.293a1 1 0 01-1.414-1.414l5-5a1 1 0 011.414 0L11 10.586 14.586 7H12z" clip-rule="evenodd"/></svg>
                </div>
                <span class="text-sm font-medium tracking-wide"><?php echo $appName; ?> Public Offering</span>
            </a>
            
        </div>

        <div class="text-center mb-12">
            <h2 class="text-2xl md:text-3xl font-light mb-4">Didn’t find what you were looking for?</h2>
            <p class="text-sm text-gray-300 font-light mb-8">Please reach out to us, we will be glad to answer any of your questions.</p>
            
            <div class="flex flex-col items-center">
                <div class="w-10 h-10 rounded-full bg-[#7c3aed] flex items-center justify-center mb-2 shadow-[0_0_15px_rgba(124,58,237,0.5)]">
                    <svg class="w-5 h-5 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path></svg>
                </div>
                <div class="font-bold text-sm mb-1">Support</div>
                <p class="text-xs text-gray-400 mb-6">We will help you as soon as possible via our chat.</p>
                
                <button class="bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 text-white text-[10px] font-bold uppercase tracking-wider py-3 px-10 rounded-full shadow-lg transition transform hover:scale-105">
                    Send Us a Message
                </button>
            </div>
        </div>

        <div class="absolute bottom-6 w-full flex justify-center px-4">
            <div class="flex items-center gap-2 text-[10px] md:text-xs text-gray-400 bg-black/20 px-4 py-2 rounded-full backdrop-blur-sm border border-red-500/20">
                <svg class="w-4 h-4 text-red-500" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                <span><?php echo $appName; ?> Staff will NEVER ask for sensitive information, including passwords, 12-word phrases or private keys.</span>
            </div>
        </div>

    </div>
</main>
    

<?php include 'includes/footer.php'; ?>