<?php include 'includes/header.php'; ?>

<main class="w-full bg-white text-gray-900 font-sans">

    <!-- <div class="bg-[#7c3aed] text-white text-xs md:text-sm font-semibold text-center py-3 px-4">
        <?php echo $appName; ?> Agrees to Acquire W3C: <a href="#" class="underline hover:text-gray-200">Supplemental Information</a> and <a href="#" class="underline hover:text-gray-200">Presentation Slides</a>. <a href="#" class="underline hover:text-gray-200 ml-2">Watch Call</a>
    </div> -->

    <section class="relative h-[400px] md:h-[500px] flex items-center justify-center bg-cover bg-center" style="background-image: url('images/mountain-hero.jpg');">
        <div class="absolute inset-0 bg-indigo-900/60 mix-blend-multiply"></div>
        <div class="absolute inset-0 bg-gradient-to-b from-transparent to-[#1a1a2e]/40"></div>
        
        <div class="relative z-10 text-center text-white px-6">
            <h1 class="text-3xl md:text-5xl font-light mb-4"><?php echo $appName; ?> W3C Conference Call</h1>
            <p class="text-sm md:text-base font-bold tracking-widest uppercase mb-10">Nov 24, 2025 5:00 PM EST</p>
            <a href="#" class="inline-block bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 text-white text-xs font-bold uppercase tracking-wider py-3 px-8 rounded-full shadow-lg transition transform hover:scale-105">
                View Webcast
            </a>
        </div>
    </section>

    <section class="py-20 px-6 max-w-7xl mx-auto">
        <div class="flex flex-col md:flex-row justify-between items-end mb-12 border-b border-gray-100 pb-4">
            <h2 class="text-3xl font-light text-gray-800">Latest News</h2>
            <a href="#" class="mt-4 md:mt-0 bg-purple-600 hover:bg-purple-700 text-white text-xs font-bold uppercase py-2 px-6 rounded-full shadow-md transition">
                View All News
            </a>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 gap-12">
            <div class="flex flex-col items-start">
                <div class="text-xs text-gray-500 font-bold mb-2">January 8, 2026 7:20 AM EST</div>
                <h3 class="text-lg font-medium text-gray-900 hover:text-purple-600 cursor-pointer underline decoration-transparent hover:decoration-purple-600 transition mb-4">
                    <?php echo $appName; ?> Movement, Inc. December 2025 Treasury Update and Monthly Metrics
                </h3>
                <a href="#" class="bg-purple-500 hover:bg-purple-600 text-white text-[10px] font-bold uppercase py-2 px-4 rounded-full shadow-sm">
                    Read Press Release
                </a>
            </div>

            <div class="space-y-8">
                <div>
                    <div class="text-xs text-gray-500 font-bold mb-2">Dec 16, 2025 4:30 pm EST</div>
                    <a href="#" class="text-base text-gray-900 hover:text-purple-600 underline decoration-transparent hover:decoration-purple-600 transition">
                        <?php echo $appName; ?>, MoonPay and M0 Unveil a New Digital Dollar for Everyday Payments
                    </a>
                </div>
                <div>
                    <div class="text-xs text-gray-500 font-bold mb-2">Dec 9, 2025 12:26 pm EST</div>
                    <a href="#" class="text-base text-gray-900 hover:text-purple-600 underline decoration-transparent hover:decoration-purple-600 transition">
                        UPDATE -- <?php echo $appName; ?> Movement, Inc. November 2025 Treasury Update and Monthly Metrics
                    </a>
                </div>
            </div>
        </div>
    </section>

    <section class="bg-gray-50 py-16 px-6">
        <div class="max-w-7xl mx-auto">
            <h2 class="text-3xl font-light text-gray-800 mb-8">Latest Presentation</h2>
            
            <div class="mb-2 text-xs font-bold text-gray-500">Nov 10, 2025</div>
            <a href="#" class="text-lg font-medium text-gray-900 hover:text-purple-600 underline decoration-gray-300 underline-offset-4 mb-6 inline-block">
                Company Presentation
            </a>

            <div class="flex gap-6 text-[10px] font-bold uppercase tracking-wide text-gray-600 mt-4">
                <a href="#" class="flex items-center gap-1 hover:text-purple-600 transition">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"/><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"/></svg>
                    View Presentation
                </a>
                <a href="#" class="flex items-center gap-1 hover:text-purple-600 transition">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-8l-4-4m0 0L8 8m4-4v12"/></svg>
                    View All Presentations
                </a>
            </div>
        </div>
    </section>

    <section class="py-20 px-6 max-w-7xl mx-auto">
        <h2 class="text-3xl font-light text-gray-800 mb-12">Latest Financial Results</h2>

        <div class="flex flex-col md:flex-row gap-12">
            <div class="flex-1">
                <h3 class="text-2xl font-light mb-1">Q3 2025</h3>
                <div class="text-xs text-gray-500 font-bold mb-8">Quarter Ended Sep 30, 2025</div>

                <div class="flex justify-between items-center py-3 border-b border-gray-200 text-sm">
                    <a href="#" class="text-gray-800 hover:text-purple-600 underline decoration-gray-300">Earnings Release</a>
                    <div class="flex gap-3 text-xs font-bold uppercase text-gray-500">
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-alt"></i> HTML</a>
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-pdf"></i> PDF</a>
                    </div>
                </div>
                <div class="flex justify-between items-center py-3 border-b border-gray-200 text-sm">
                    <a href="#" class="text-gray-800 hover:text-purple-600 underline decoration-gray-300">Earnings Webcast</a>
                    <div class="flex gap-3 text-xs font-bold uppercase text-gray-500">
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="fas fa-volume-up"></i> Video</a>
                    </div>
                </div>
                 <div class="flex justify-between items-center py-3 border-b border-gray-200 text-sm">
                    <a href="#" class="text-gray-800 hover:text-purple-600 underline decoration-gray-300">10-Q</a>
                    <div class="flex gap-3 text-xs font-bold uppercase text-gray-500">
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-alt"></i> HTML</a>
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-pdf"></i> PDF</a>
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="fas fa-file-archive"></i> XBRL ZIP</a>
                    </div>
                </div>
                <div class="flex justify-between items-center py-3 border-b border-gray-200 text-sm">
                    <a href="#" class="text-gray-800 hover:text-purple-600 underline decoration-gray-300">CFO Supplemental Slides</a>
                    <div class="flex gap-3 text-xs font-bold uppercase text-gray-500">
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-pdf"></i> PDF</a>
                    </div>
                </div>
                 <div class="flex justify-between items-center py-3 border-b border-gray-200 text-sm">
                    <a href="#" class="text-gray-800 hover:text-purple-600 underline decoration-gray-300">Company Presentation</a>
                    <div class="flex gap-3 text-xs font-bold uppercase text-gray-500">
                        <a href="#" class="hover:text-purple-600 flex items-center gap-1"><i class="far fa-file-pdf"></i> PDF</a>
                    </div>
                </div>
            </div>

            <div class="flex-1 h-[300px] md:h-auto overflow-hidden rounded-lg shadow-lg">
                <img src="images/laptop-desk.jpg" alt="Financial Results" class="w-full h-full object-cover transform hover:scale-105 transition duration-700">
            </div>
        </div>

        <div class="mt-20 flex justify-between items-end border-b border-gray-200 pb-4">
             <div>
                <h2 class="text-3xl font-light text-gray-800 mb-2">Latest Annual Filing</h2>
                <div class="text-sm text-gray-500">For Fiscal Year Ending Dec 31, 2024</div>
             </div>
             <a href="#" class="bg-purple-600 hover:bg-purple-700 text-white text-xs font-bold uppercase py-2 px-6 rounded-full shadow-md transition">
                View 10-K
            </a>
        </div>
    </section>

    <section class="bg-[#7c3aed] text-white py-12 px-6">
        <div class="max-w-7xl mx-auto flex flex-col md:flex-row items-center justify-between gap-6 text-center md:text-left">
            <div>
                <h2 class="text-3xl font-light mb-1 inline-block mr-2">Email Alerts</h2>
                <p class="text-sm md:text-base opacity-90 inline-block font-light">Sign up today and receive company updates straight to your inbox.</p>
            </div>
            <a href="#" class="border border-white hover:bg-white hover:text-purple-600 text-white text-xs font-bold uppercase py-3 px-8 rounded-full transition duration-300">
                Sign Up Today
            </a>
        </div>
    </section>

    <section class="bg-[#1a1a2e] text-white py-20 px-6 relative">
        <div class="max-w-7xl mx-auto flex flex-col md:flex-row gap-16 items-center">
            
            <div class="flex-1 relative">
                <img src="images/devices-dark.png" alt="<?php echo $appName; ?> Devices" class="w-full max-w-lg mx-auto drop-shadow-2xl">
            </div>

            <div class="flex-1 text-center md:text-left">
                <h2 class="text-3xl md:text-4xl font-light mb-6">Company Overview</h2>
                <p class="text-gray-400 text-sm leading-relaxed mb-6 font-light">
                    <?php echo $appName; ?> empowers individuals to control their lives in a digital world. Founded in 2015, <?php echo $appName; ?>' multi-asset software wallet keeps design a priority to make cryptocurrency and digital assets easy for everyone. Available for desktop, mobile and browser, <?php echo $appName; ?> allows users to secure, manage and exchange cryptocurrencies like Bitcoin, Ethereum, and more across an industry-leading 100,000+ asset pairs from a beautiful, easy-to-use wallet. The self-custodial functionality is encrypted locally on users' own devices, ensuring privacy, security and complete control over their wealth.
                </p>
                <div class="flex flex-wrap gap-4 justify-center md:justify-start">
                    <a href="#" class="bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 text-white text-[10px] font-bold uppercase py-3 px-8 rounded-full shadow-lg transition">
                        View Executive Team
                    </a>
                    <a href="#" class="bg-gradient-to-r from-purple-600 to-indigo-600 hover:from-purple-700 hover:to-indigo-700 text-white text-[10px] font-bold uppercase py-3 px-8 rounded-full shadow-lg transition">
                        View Board of Directors
                    </a>
                </div>
            </div>
        </div>
    </section>

    <div class="bg-[#6b21a8] text-white py-4 px-6 border-t border-purple-500">
        <div class="max-w-7xl mx-auto flex flex-wrap justify-between items-center text-xs md:text-sm">
            
            <div class="flex flex-col">
                <span class="opacity-70 text-[10px] uppercase mb-1">Market/Symbol</span>
                <span class="font-light text-lg">NYSE AMERICAN: EXOD</span>
            </div>

            <div class="flex flex-col">
                <span class="opacity-70 text-[10px] uppercase mb-1">Price</span>
                <span class="font-light text-lg">16.17</span>
            </div>

            <div class="flex flex-col">
                <span class="opacity-70 text-[10px] uppercase mb-1">Change</span>
                <span class="font-light text-lg">0.10 (0.62%)</span>
            </div>

            <div class="flex flex-col">
                <span class="opacity-70 text-[10px] uppercase mb-1">Volume</span>
                <span class="font-light text-lg">60.00K</span>
            </div>

            <div class="flex flex-col hidden md:flex">
                <span class="opacity-70 text-[10px] uppercase mb-1">Day Range</span>
                <span class="font-light text-lg">15.37 - 16.59</span>
            </div>

            <div class="flex flex-col hidden md:flex">
                <span class="opacity-70 text-[10px] uppercase mb-1">52 Week Range</span>
                <span class="font-light text-lg">13.31 - 117.40</span>
            </div>

            <div class="text-[10px] opacity-60 self-start md:self-center mt-2 md:mt-0">
                January 9, 2026 12:39 PM ET
            </div>
        </div>
    </div>

    <section class="bg-gray-50 py-20 px-6">
        <div class="max-w-7xl mx-auto">
            <h2 class="text-3xl font-light text-gray-800 mb-12">IR Contacts</h2>
            
            <div class="grid grid-cols-1 md:grid-cols-3 gap-12 text-sm">
                <div>
                    <h3 class="text-xl font-normal text-gray-800 mb-4">Headquarters</h3>
                    <p class="text-gray-500 leading-relaxed">
                        <?php echo $appName; ?> Movement, Inc.<br>
                        15418 Weir St.<br>
                        #333<br>
                        Omaha, NE 68137
                    </p>
                </div>

                <div>
                    <h3 class="text-xl font-normal text-gray-800 mb-4">Investor Relations</h3>
                    <p class="text-gray-500 mb-2">T: 833-992-2566</p>
                    <a href="mailto:investors@exodus.com" class="text-gray-800 underline hover:text-purple-600">investors@exodus.com</a>
                </div>

                <div>
                    <h3 class="text-xl font-normal text-gray-800 mb-4">Transfer Agent</h3>
                    <p class="text-gray-500 mb-2">Securitize</p>
                    <a href="mailto:investorsupport@securitize.io" class="text-gray-800 underline hover:text-purple-600">investorsupport@securitize.io</a>
                </div>
            </div>
        </div>
    </section>

    <div class="bg-[#111122] text-white py-4 border-t border-gray-800">
        <div class="max-w-7xl mx-auto px-6 flex flex-wrap justify-center md:justify-end gap-6 text-[10px] font-bold uppercase tracking-wide">
            <a href="#" class="flex items-center gap-2 hover:text-gray-300"><i class="fas fa-envelope"></i> Email Alerts</a>
            <a href="#" class="flex items-center gap-2 hover:text-gray-300"><i class="fas fa-briefcase"></i> Company Profile</a>
            <a href="#" class="flex items-center gap-2 hover:text-gray-300"><i class="fas fa-address-book"></i> Contacts</a>
            <a href="#" class="flex items-center gap-2 hover:text-gray-300"><i class="fas fa-rss"></i> RSS News Feed</a>
            <a href="#" class="flex items-center gap-2 hover:text-gray-300"><i class="fas fa-sitemap"></i> Sitemap</a>
        </div>
    </div>

</main>
    

<?php include 'includes/footer.php'; ?>