<?php
// Start session to enable simple caching (optional, but recommended for speed)
session_start();

// --- CONFIGURATION ---
// The URL to your Laravel API
$apiUrl = 'http://localhost:8000/api/persona/active'; 
$appLink = 'https://exodus.com';

// Default Fallback Values (Used if API is down)
$appBrand = [
    'name' => 'Exodus',
    'tagline' => 'The Future of Finance',
    'logo_icon' => 'https://placehold.co/40x40/blue/white?text=E', // Fallback icon
    'logo_full' => 'https://placehold.co/140x40/blue/white?text=Exodus', // Fallback full logo
    'primary_color' => '#0B46F9',
];

// --- DATA FETCHING ---
// Check if we have cached data in session to avoid hitting the API on every page load
if (isset($_SESSION['persona_data']) && (time() - $_SESSION['persona_time'] < 300)) {
    // Use cached data (valid for 5 minutes)
    $appBrand = $_SESSION['persona_data'];
} else {
    // Fetch fresh data from API
    // Suppress errors with @ to prevent breaking the site if API is offline
    $json = @file_get_contents($apiUrl);
    
    if ($json) {
        $data = json_decode($json, true);
        
        if (isset($data['name'])) {
            $appBrand['name'] = $data['name'];
            $appBrand['tagline'] = $data['tagline'] ?? $appBrand['tagline'];
            
            // Map API fields to our variables
            // 'logo_url' is usually the square icon
            $appBrand['logo_icon'] = $data['logo_url'] ?? $appBrand['logo_icon'];
            
            // 'logo_full_url' is the logo with text (if available), else use icon
            $appBrand['logo_full'] = $data['logo_full_url'] ?? ($data['logo_url'] ?? $appBrand['logo_full']);
            
            $appBrand['primary_color'] = $data['colors']['primary'] ?? $appBrand['primary_color'];

            // Save to session cache
            $_SESSION['persona_data'] = $appBrand;
            $_SESSION['persona_time'] = time();
        }
    }
}

// --- GLOBAL VARIABLES FOR USE IN HTML ---
$appName = htmlspecialchars($appBrand['name']);
$appTagline = htmlspecialchars($appBrand['tagline']);
$appIconUrl = htmlspecialchars($appBrand['logo_icon']);
$appLogoUrl = htmlspecialchars($appBrand['logo_full']);
$appColor = htmlspecialchars($appBrand['primary_color']);
?>