<?php require_once 'init.php'; ?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $appName ?> | <?= $appTagline ?></title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link rel="shortcut icon" href="<?= $appIconUrl ?>" type="image/x-icon">
    <style>
        /* Custom font to match the sleek look */
        @import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;600;700&display=swap');
        body {
            font-family: 'Inter', sans-serif;
        }
        /* Dynamic Primary Color override */
        :root {
            --primary-color: <?= $appColor ?>;
        }
    </style>
</head>
<body class="bg-[#0b0b15] text-white overflow-x-hidden">
    <nav id="navbar" class="fixed left-1/2 top-4 z-50 flex w-[95%] max-w-[1200px] -translate-x-1/2 flex-col items-center justify-between rounded-[2rem] bg-[#0b0b15]/50 px-6 py-3 shadow-lg backdrop-blur-md border border-white/5 transition-all duration-300 md:h-16 md:flex-row md:rounded-full md:px-8">
        
        <div class="flex w-full items-center justify-between md:w-auto">
            
            <a href="index.php" class="flex items-center gap-2 group transition-opacity hover:opacity-80">
                <img src="<?= $appIconUrl ?>" alt="<?= $appName ?> Icon" class="h-8 w-8 md:h-10 md:w-10 object-contain lg:hidden">
                
                <img src="<?= $appLogoUrl ?>" alt="<?= $appName ?> Logo" class="hidden h-8 w-auto lg:block object-contain">
                
                </a>

            <div class="flex items-center gap-3 md:hidden">
                <a href="<?php echo $appLink; ?>" class="rounded-full bg-white px-5 py-2 text-sm font-bold text-black transition-colors hover:bg-gray-200">
                    Get Started
                </a>
                <button id="mobile-toggle" class="group text-white focus:outline-none">
                    <svg id="icon-menu" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="block"><line x1="4" x2="20" y1="12" y2="12"/><line x1="4" x2="20" y1="6" y2="6"/><line x1="4" x2="20" y1="18" y2="18"/></svg>
                    <svg id="icon-close" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="hidden"><path d="M18 6 6 18"/><path d="m6 6 12 12"/></svg>
                </button>
            </div>
        </div>

        <div class="hidden items-center gap-8 md:flex">
            <a href="index.php" class="group flex items-center gap-1.5 text-sm font-medium text-gray-200 transition-colors hover:text-white">
                Home
            </a>
            <a href="company.php" class="group flex items-center gap-1.5 text-sm font-medium text-gray-200 transition-colors hover:text-white">
                Company
            </a>
            <a href="investors.php" class="group flex items-center gap-1.5 text-sm font-medium text-gray-200 transition-colors hover:text-white">
                Investors
            </a>
            <a href="support.php" class="group flex items-center gap-1.5 text-sm font-medium text-gray-200 transition-colors hover:text-white">
                Support
            </a>
            <a href="contact.php" class="group flex items-center gap-1.5 text-sm font-medium text-gray-200 transition-colors hover:text-white">
                Contact
            </a>
        </div>

        <div class="hidden items-center flex-shrink-0 md:flex">
            <a href="<?php echo $appLink; ?>" class="rounded-full bg-white px-6 py-2.5 text-sm font-bold text-black transition-colors hover:bg-gray-200">
                Get Started
            </a>
        </div>

        <div id="mobile-menu" class="hidden w-full pt-4 md:hidden">
            <div class="flex flex-col gap-1 rounded-[2rem] bg-black p-4 text-white">
                <a href="index.php" class="flex items-center justify-between px-4 py-3 text-base font-medium transition hover:text-gray-300">
                    Home
                </a>
                <a href="company.php" class="flex items-center justify-between px-4 py-3 text-base font-medium transition hover:text-gray-300">
                    Company
                </a>
                <a href="investors.php" class="flex items-center justify-between px-4 py-3 text-base font-medium transition hover:text-gray-300">
                    Investors
                </a>
                <a href="support.php" class="flex items-center justify-between px-4 py-3 text-base font-medium transition hover:text-gray-300">
                    Support
                </a>
                <a href="contact.php" class="flex items-center justify-between px-4 py-3 text-base font-medium transition hover:text-gray-300">
                    Contact
                </a>
            </div>
        </div>
    </nav>

