<?php include 'includes/header.php'; ?>

<main class="relative min-h-[80vh] w-full bg-cover bg-center bg-no-repeat font-sans text-white flex items-center justify-center" style="background-image: url('https://images.unsplash.com/photo-1464822759023-fed622ff2c3b?q=80&w=2070&auto=format&fit=crop');">
    
    <div class="absolute inset-0 bg-[#1e1e2f]/90 mix-blend-multiply z-0"></div>
    <div class="absolute inset-0 bg-gradient-to-r from-[#1a1a2e] via-[#1a1a2e]/90 to-transparent z-0"></div>

    <div class="relative z-10 w-full max-w-6xl px-6 py-32 flex flex-col md:flex-row items-start justify-between gap-16 md:gap-24">
        
        <div class="flex-1 max-w-lg pt-10">
            <div class="text-[10px] font-bold uppercase tracking-[0.2em] text-gray-400 mb-4">
                Get In Touch With Us
            </div>
            
            <h1 class="text-5xl md:text-6xl font-light mb-12">
                Contact us
            </h1>

            <div class="space-y-6">
                <div class="flex items-start gap-3 text-red-500">
                    <svg class="w-6 h-6 flex-shrink-0" fill="currentColor" viewBox="0 0 20 20"><path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/></svg>
                </div>
                
                <p class="text-lg leading-relaxed font-light text-white">
                    <?php echo $appName; ?> Staff will NEVER ask for sensitive information, including passwords, 12-word phrases or private keys.
                </p>
                
                <p class="text-xs text-gray-400 leading-relaxed font-light">
                    Presently, <?php echo $appName; ?> does not offer support via telephone. It is important to note that while numbers listed as "Official <?php echo $appName; ?> Support" are often posted and shared on the internet, these are scams attempting to gain access to your funds.
                </p>
            </div>
        </div>

        <div class="flex-1 relative">
             <div class="grid md:grid-cols-3 gap-4 max-w-md mx-auto md:mx-0">
                
                <a href="#" class="aspect-square bg-[#0eb1ff] hover:bg-[#0c9ce0] transition flex flex-col items-center justify-center text-white group">
                    <svg class="w-10 h-10 mb-2 group-hover:scale-110 transition" fill="currentColor" viewBox="0 0 24 24"><path d="M18.244 2.25h3.308l-7.227 8.26 8.502 11.24H16.17l-5.214-6.817L4.99 21.75H1.68l7.73-8.835L1.254 2.25H8.08l4.713 6.231zm-1.161 17.52h1.833L7.084 4.126H5.117z"/></svg>
                    <span class="text-sm font-medium">Twitter</span>
                </a>
                <br>

                <a href="#" class="aspect-square bg-[#3b5998] hover:bg-[#324b82] transition flex flex-col items-center justify-center text-white group">
                    <svg class="w-10 h-10 mb-2 group-hover:scale-110 transition" fill="currentColor" viewBox="0 0 24 24"><path d="M22.675 0h-21.35c-.732 0-1.325.593-1.325 1.325v21.351c0 .731.593 1.324 1.325 1.324h11.495v-9.294h-3.128v-3.622h3.128v-2.671c0-3.1 1.893-4.788 4.659-4.788 1.325 0 2.463.099 2.795.143v3.24l-1.918.001c-1.504 0-1.795.715-1.795 1.763v2.313h3.587l-.467 3.622h-3.12v9.293h6.116c.73 0 1.323-.593 1.323-1.325v-21.351c0-.732-.593-1.325-1.325-1.325z"/></svg>
                    <span class="text-sm font-medium">Facebook</span>
                </a>

                <div class="hidden md:block"></div> <a href="mailto:support@<?php echo $_SERVER['HTTP_HOST']; ?>.com" class="aspect-square bg-[#622aff] hover:bg-[#5220d9] transition flex flex-col items-center justify-center text-white group col-start-2 md:col-start-auto">
                    <svg class="w-10 h-10 mb-2 group-hover:scale-110 transition" fill="currentColor" viewBox="0 0 20 20"><path d="M2.003 5.884L10 9.882l7.997-3.998A2 2 0 0016 4H4a2 2 0 00-1.997 1.884z"/><path d="M18 8.118l-8 4-8-4V14a2 2 0 002 2h12a2 2 0 002-2V8.118z"/></svg>
                    <span class="text-sm font-medium underline decoration-transparent group-hover:decoration-white transition-all">support@<?php echo $_SERVER['HTTP_HOST']; ?>.com</span>
                </a>

            </div>
        </div>

    </div>

</main>
    

<?php include 'includes/footer.php'; ?>