<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">Investments</h4>
                <p class="mt-2 text-gray-400 text-sm">Manage all active and completed staking investments.</p>
            </div>
            <div class="mt-4 sm:mt-0 flex items-center gap-4">
                <input type="text" id="investmentSearch" placeholder="Search investments..."
                    class="px-4 py-2 rounded-md bg-gray-700 border border-gray-600 text-white placeholder-gray-400 focus:outline-none focus:ring-primary-500 focus:border-primary-500 text-sm">
            </div>
        </div>

        <?php if($errors->any()): ?>
            <div class="p-4 mb-4 text-sm text-red-800 rounded-lg bg-red-50 dark:bg-[#131319] dark:text-red-400" role="alert">
                <span class="font-medium">Please correct the following errors:</span>
                <ul class="mt-1.5 list-disc list-inside">
                    <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <li><?php echo e($error); ?></li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </ul>
            </div>
        <?php endif; ?>


        <div class="overflow-x-auto">
            <table id="investmentsTable" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">User</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Currency Staked</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Date Started</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Amount</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Progress</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Status</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__currentLoopData = $investments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize"><?php echo e($inv->user->firstname); ?> <?php echo e($inv->user->lastname); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e($inv->coin->name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            <?php echo e($inv->created_at ? $inv->created_at->setTimezone('Africa/Lagos')->format('h:i a jS M Y') : '--'); ?>

                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">$<?php echo e(number_format($inv->invested_amount, 2)); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">
                            <div class="w-40 sm:w-64 bg-gray-600 rounded-full h-2.5 my-1">
                                <div class="bg-green-500 h-2.5 rounded-full" style="width: <?php echo e($inv->percent_completed); ?>%"></div>
                            </div>
                            <span class="text-xs"><?php echo e($inv->days_gone); ?>/<?php echo e($inv->user_chosen_duration_value); ?> days</span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <span class="px-2 py-1 rounded-full text-xs font-semibold
                                <?php if($inv->status == 'pending'): ?> bg-yellow-600 text-white
                                <?php elseif($inv->status == 'active'): ?> bg-purple-500 text-white
                                <?php elseif($inv->status == 'matured'): ?> bg-green-600 text-white
                                <?php elseif($inv->status == 'disbursed'): ?> bg-green-600 text-white
                                <?php else: ?> bg-red-600 text-white <?php endif; ?>">
                                <?php if($inv->status): ?><?php echo e($inv->status); ?><?php else: ?> -- <?php endif; ?>
                            </span>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <div class="flex flex-col sm:flex-row gap-2">
                                <?php if($inv->status == 'matured'): ?> 
                                    <button type="button" onclick="openModal('disburse-interest-modal-<?php echo e($inv->id); ?>')"
                                        class="px-3 py-1.5 rounded-md text-white bg-primary-600 hover:bg-primary-700 transition-colors duration-200 text-xs font-medium">Disburse</button>
                                <?php elseif($inv->status == 'disbursed'): ?> 
                                    <span class="px-3 py-1.5 rounded-md border border-gray-500 text-gray-500 text-xs font-medium">Disbursed</span>
                                <?php elseif($inv->status == 'active'): ?> 
                                    <span class="px-3 py-1.5 rounded-md border border-green-500 text-green-500 text-xs font-medium">Active</span>
                                <?php else: ?> 
                                    <span class="px-3 py-1.5 rounded-md border border-red-500 text-red-500 text-xs font-medium">Canceled</span>
                                <?php endif; ?>
                            </div>
                        </td>
                    </tr>

                    
                    <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'disburse-interest-modal-'.e($inv->id).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'disburse-interest-modal-'.e($inv->id).'']); ?>
                        <div class="bg-green-700 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-green-600">
                            <div class="text-white mb-6">
                                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <h2 class="mt-4 text-2xl font-bold">Disburse Interest</h2>
                                <p class="mt-2 text-white">For investment ID: <span class="font-semibold"><?php echo e($inv->inv_id); ?></span></p>
                            </div>
                            <form action="<?php echo e(url('/admin/investments')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <?php echo method_field('PUT'); ?>
                                <div class="my-4 text-white text-left">
                                    <div class="mb-3">
                                        
                                        <input type="radio" name="pnl_type" value="profit" id="profit-<?php echo e($inv->id); ?>"
                                            class="rounded-full text-primary-600 border-gray-300 focus:ring-primary-500 bg-gray-700 mr-2"
                                            required checked
                                            onchange="calculateTotal(<?php echo e($inv->id); ?>, <?php echo e($inv->invested_amount); ?>)">
                                        <label for="profit-<?php echo e($inv->id); ?>" class="text-sm">Profit</label>
                                    </div>
                                    <div class="mb-3">
                                        
                                        <input type="radio" name="pnl_type" value="loss" id="loss-<?php echo e($inv->id); ?>"
                                            class="rounded-full text-primary-600 border-gray-300 focus:ring-primary-500 bg-gray-700 mr-2"
                                            required
                                            onchange="calculateTotal(<?php echo e($inv->id); ?>, <?php echo e($inv->invested_amount); ?>)">
                                        <label for="loss-<?php echo e($inv->id); ?>" class="text-sm">Loss</label>
                                    </div>
                                </div>

                                
                                <input type="number" step="any" name="pnl_amount" value="<?php echo e($inv->current_pnl); ?>" id="pnl-amount-<?php echo e($inv->id); ?>"
                                    class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500 mb-2"
                                    oninput="calculateTotal(<?php echo e($inv->id); ?>, <?php echo e($inv->invested_amount); ?>)" />

                                
                                <p class="text-right text-sm text-gray-300 mb-4">
                                    Total to Disburse: <span class="font-bold text-white" id="total-display-<?php echo e($inv->id); ?>">$<?php echo e(number_format($inv->invested_amount + ($inv->current_pnl ?? 0), 2)); ?></span>
                                </p>

                                <input type="hidden" name="id" value="<?php echo e($inv->id); ?>">
                                <div class="flex justify-center gap-4 mt-6">
                                    <button type="submit" class="px-6 py-2 bg-white hover:bg-gray-100 text-green-700 font-semibold rounded-lg transition-colors duration-200">Disburse</button>
                                    <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('disburse-interest-modal-<?php echo e($inv->id); ?>')">Cancel</button>
                                </div>
                            </form>
                        </div>
                     <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($investments->isEmpty()): ?>
                        <tr>
                            <td colspan="7" class="px-6 py-8 text-center text-gray-500 text-lg">No investments to display.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>

        <div id="paginationControls" class="flex justify-between items-center mt-6">
            <button id="prevPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Previous</button>
            <div id="pageNumbers" class="flex gap-2">
            </div>
            <button id="nextPage" class="px-4 py-2 bg-gray-700 hover:bg-gray-600 text-white rounded-md text-sm font-medium disabled:opacity-50 disabled:cursor-not-allowed">Next</button>
        </div>
    </div>

    
    <?php if(session('success')): ?>
        <?php if (isset($component)) { $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-success','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-success'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>Profit Disbursed <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $attributes = $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $component = $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
    <?php endif; ?>
    <?php if(session('success_decline')): ?>
        <?php if (isset($component)) { $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-danger','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-danger'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>Investment Action Declined <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $attributes = $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $component = $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
    <?php endif; ?>

    <script>
        // Modal Functions - ADD THESE TO FIX THE POPUP ISSUE
        function openModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                // Show the modal
                modal.style.display = 'flex';
                modal.style.alignItems = 'center';
                modal.style.justifyContent = 'center';
                modal.style.position = 'fixed';
                modal.style.top = '0';
                modal.style.left = '0';
                modal.style.width = '100%';
                modal.style.height = '100%';
                modal.style.backgroundColor = 'rgba(0, 0, 0, 0.5)';
                modal.style.zIndex = '1000';
                modal.style.backdropFilter = 'blur(4px)';

                // Prevent background scrolling
                document.body.style.overflow = 'hidden';

                // Add animation
                const modalContent = modal.querySelector('div');
                if (modalContent) {
                    modalContent.style.animation = 'modalSlideIn 0.3s ease-out';
                }
            }
        }

        function closeModal(modalId) {
            const modal = document.getElementById(modalId);
            if (modal) {
                // Hide the modal
                modal.style.display = 'none';

                // Restore background scrolling
                document.body.style.overflow = '';
            }
        }

        // Close modal when clicking outside
        document.addEventListener('click', function(event) {
            if (event.target.id && event.target.id.includes('modal') && !event.target.closest('.bg-green-700, .bg-red-700')) {
                closeModal(event.target.id);
            }
        });

        // Close modal with Escape key
        document.addEventListener('keydown', function(event) {
            if (event.key === 'Escape') {
                // Find any open modals and close them
                const modals = document.querySelectorAll('[id*="modal"]');
                modals.forEach(modal => {
                    if (modal.style.display === 'flex') {
                        closeModal(modal.id);
                    }
                });
            }
        });

        // Add CSS for modal animations
        const style = document.createElement('style');
        style.textContent = `
            @keyframes modalSlideIn {
                from {
                    opacity: 0;
                    transform: scale(0.9) translateY(-20px);
                }
                to {
                    opacity: 1;
                    transform: scale(1) translateY(0);
                }
            }
        `;
        document.head.appendChild(style);

        // Calculation Function
        function calculateTotal(id, investedAmount) {
            // Get elements specific to this modal ID
            const amountInput = document.getElementById(`pnl-amount-${id}`);
            const totalDisplay = document.getElementById(`total-display-${id}`);
            const isProfit = document.getElementById(`profit-${id}`).checked;

            // Get values
            let pnlAmount = parseFloat(amountInput.value);
            if (isNaN(pnlAmount)) pnlAmount = 0;

            let total = 0;

            // Calculate based on type
            if (isProfit) {
                total = parseFloat(investedAmount) + pnlAmount;
            } else {
                total = parseFloat(investedAmount) - pnlAmount;
            }

            // Format to 2 decimal places and update display
            totalDisplay.textContent = '$' + total.toLocaleString('en-US', {
                minimumFractionDigits: 2,
                maximumFractionDigits: 2
            });
        }


        document.addEventListener('DOMContentLoaded', function () {
            const table = document.getElementById('investmentsTable');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr')); // Get all rows
            const searchInput = document.getElementById('investmentSearch');
            const prevButton = document.getElementById('prevPage');
            const nextButton = document.getElementById('nextPage');
            const pageNumbersContainer = document.getElementById('pageNumbers');

            const rowsPerPage = 10; // Number of rows per page
            let currentPage = 1;
            let filteredRows = [];

            // Function to filter and paginate rows
            function renderTable() {
                const searchTerm = searchInput.value.toLowerCase();
                filteredRows = rows.filter(row => {
                    const textContent = row.textContent.toLowerCase();
                    return textContent.includes(searchTerm);
                });

                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);

                // Ensure current page is valid after filtering
                if (currentPage > totalPages && totalPages > 0) {
                    currentPage = totalPages;
                } else if (totalPages === 0 && searchTerm !== "") {
                    currentPage = 1; // Show no results if search term exists
                } else if (totalPages === 0 && searchTerm === "") {
                    currentPage = 1; // Stay on page 1 if no data and no search
                }

                const start = (currentPage - 1) * rowsPerPage;
                const end = start + rowsPerPage;
                const paginatedRows = filteredRows.slice(start, end);

                // Clear current table rows
                tbody.innerHTML = '';
                if (paginatedRows.length === 0 && searchTerm !== "") {
                    tbody.innerHTML = `<tr><td colspan="7" class="px-6 py-8 text-center text-gray-500">No matching investments found.</td></tr>`;
                } else if (paginatedRows.length === 0 && searchTerm === "") {
                    tbody.innerHTML = `<tr><td colspan="7" class="px-6 py-8 text-center text-gray-500">No investments to display.</td></tr>`;
                }

                // Append paginated rows
                paginatedRows.forEach(row => tbody.appendChild(row));

                updatePaginationControls(totalPages);
            }

            // Function to update pagination buttons and page numbers
            function updatePaginationControls(totalPages) {
                prevButton.disabled = currentPage === 1;
                nextButton.disabled = currentPage === totalPages || totalPages === 0;

                pageNumbersContainer.innerHTML = '';
                const maxPageButtons = 5; // Max number of page buttons to display

                let startPage = Math.max(1, currentPage - Math.floor(maxPageButtons / 2));
                let endPage = Math.min(totalPages, startPage + maxPageButtons - 1);

                if (endPage - startPage + 1 < maxPageButtons) {
                    startPage = Math.max(1, endPage - maxPageButtons + 1);
                }

                if (startPage > 1) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }

                for (let i = startPage; i <= endPage; i++) {
                    const pageButton = document.createElement('button');
                    pageButton.textContent = i;
                    pageButton.className = `px-3 py-1 rounded-md text-sm font-medium ${
                        i === currentPage ? 'bg-primary-600 text-white' : 'bg-gray-700 hover:bg-gray-600 text-gray-300'
                    }`;
                    pageButton.addEventListener('click', () => {
                        currentPage = i;
                        renderTable();
                    });
                    pageNumbersContainer.appendChild(pageButton);
                }

                if (endPage < totalPages) {
                    const ellipsis = document.createElement('span');
                    ellipsis.textContent = '...';
                    ellipsis.className = 'px-2 text-gray-400';
                    pageNumbersContainer.appendChild(ellipsis);
                }
            }

            // Event Listeners
            searchInput.addEventListener('input', () => {
                currentPage = 1; // Reset to first page on new search
                renderTable();
            });

            prevButton.addEventListener('click', () => {
                if (currentPage > 1) {
                    currentPage--;
                    renderTable();
                }
            });

            nextButton.addEventListener('click', () => {
                const totalPages = Math.ceil(filteredRows.length / rowsPerPage);
                if (currentPage < totalPages) {
                    currentPage++;
                    renderTable();
                }
            });


            // Initial render
            renderTable();
        });
    </script>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/admin-dash/investments.blade.php ENDPATH**/ ?>