<?php if (isset($component)) { $__componentOriginal91fdd17964e43374ae18c674f95cdaa3 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3 = $attributes; } ?>
<?php $component = App\View\Components\AdminLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('admin-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AdminLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <div class="bg-[#131319] rounded-lg p-6 border border-gray-700 shadow-sm">
        <div class="border-b border-gray-700 pb-4 mb-4 flex flex-col sm:flex-row sm:items-center sm:justify-between">
            <div>
                <h4 class="text-2xl font-semibold text-white">User Wallet Management</h4>
                <h4 class="mt-2 text-xl text-gray-300">Username: <?php echo e($user->firstname . ' ' . $user->lastname); ?></h4>
            </div>
            <a href="/admin/users" class="mt-4 sm:mt-0 px-4 py-2 bg-primary-600 hover:bg-primary-700 text-white rounded-md text-sm font-semibold transition-colors duration-200">Back to Users Management</a>
        </div>

        <div class="overflow-x-auto">
            <table id="generic_table" class="min-w-full divide-y divide-gray-700">
                <thead class="bg-gray-700">
                    <tr>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tl-lg">Coin Name</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">Balance</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider">USD Value</th>
                        <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-300 uppercase tracking-wider rounded-tr-lg">Actions</th>
                    </tr>
                </thead>
                <tbody class="divide-y divide-gray-700">
                    <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr class="bg-[#131319] hover:bg-gray-700 transition-colors duration-200">
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-white capitalize"><?php echo e($wallet->coin->name); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300"><?php echo e(number_format($wallet->balance, 6)); ?> <?php echo e($wallet->coin->symbol); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-300">$<?php echo e(number_format(($wallet->balance * $wallet->coin->value), 2)); ?></td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm">
                            <button type="button" onclick="openModal('topup-wallet-<?php echo e($wallet->id); ?>')"
                                    class="px-3 py-1.5 rounded-md text-white bg-primary-600 hover:bg-primary-700 transition-colors duration-200 text-xs font-semibold">Manage Balance</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    <?php if($wallets->isEmpty()): ?>
                        <tr>
                            <td colspan="4" class="px-6 py-8 text-center text-gray-500 text-lg">No wallets found for this user.</td>
                        </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>

    
    <?php $__currentLoopData = $wallets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $wallet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php if (isset($component)) { $__componentOriginal9f64f32e90b9102968f2bc548315018c = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9f64f32e90b9102968f2bc548315018c = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.modal','data' => ['id' => 'topup-wallet-'.e($wallet->id).'']] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['id' => 'topup-wallet-'.e($wallet->id).'']); ?>
            <div class="bg-gray-800 rounded-lg shadow-xl p-8 max-w-sm w-full text-center border border-gray-700">
                <div class="text-white mb-6">
                    <h2 class="text-2xl font-bold">Manage <?php echo e($wallet->coin->name); ?></h2>
                    <p class="mt-2 text-gray-400 text-sm">
                        1 <?php echo e($wallet->coin->symbol); ?> = $<?php echo e(number_format($wallet->coin->value, 2)); ?>

                    </p>
                </div>

                <form action="<?php echo e(route('admin.user.wallet.topup', ['wallet' => $wallet->id])); ?>" method="POST">
                    <?php echo csrf_field(); ?>
                    <?php echo method_field('PUT'); ?>

                    
                    <div class="bg-gray-700 p-4 rounded-lg mb-4 text-left">
                         <div class="flex justify-between items-end">
                             <div>
                                 <p class="text-gray-400 text-xs uppercase font-bold tracking-wider mb-1">Current Balance</p>
                                 <p class="text-xl font-mono text-white"><?php echo e(number_format($wallet->balance, 6)); ?> <span class="text-sm text-gray-400"><?php echo e($wallet->coin->symbol); ?></span></p>
                             </div>
                             <div class="text-right">
                                <p class="text-xs text-gray-400">≈ $<?php echo e(number_format($wallet->balance * $wallet->coin->value, 2)); ?></p>
                             </div>
                         </div>
                    </div>

                    
                    <div class="flex justify-center gap-4 mb-3">
                        <label class="cursor-pointer flex items-center gap-2">
                            <input type="radio" name="action_type_<?php echo e($wallet->id); ?>" value="add" checked
                                class="w-4 h-4 text-green-600 bg-gray-700 border-gray-500 focus:ring-green-500 focus:ring-2"
                                onchange="calculateNewBalance(<?php echo e($wallet->id); ?>, <?php echo e($wallet->balance); ?>, <?php echo e($wallet->coin->value); ?>)">
                            <span class="text-sm font-medium text-green-400">Credit (+)</span>
                        </label>
                        <label class="cursor-pointer flex items-center gap-2">
                            <input type="radio" name="action_type_<?php echo e($wallet->id); ?>" value="sub"
                                class="w-4 h-4 text-red-600 bg-gray-700 border-gray-500 focus:ring-red-500 focus:ring-2"
                                onchange="calculateNewBalance(<?php echo e($wallet->id); ?>, <?php echo e($wallet->balance); ?>, <?php echo e($wallet->coin->value); ?>)">
                            <span class="text-sm font-medium text-red-400">Debit (-)</span>
                        </label>
                    </div>

                    
                    <div class="flex justify-center gap-4 mb-4 pb-4 border-b border-gray-700">
                        <span class="text-xs text-gray-400 uppercase self-center mr-2">Input Mode:</span>
                        <label class="cursor-pointer flex items-center gap-2">
                            <input type="radio" name="unit_type_<?php echo e($wallet->id); ?>" value="coin" checked
                                class="w-4 h-4 text-primary-600 bg-gray-700 border-gray-500 focus:ring-primary-500"
                                onchange="calculateNewBalance(<?php echo e($wallet->id); ?>, <?php echo e($wallet->balance); ?>, <?php echo e($wallet->coin->value); ?>)">
                            <span class="text-sm font-medium text-white"><?php echo e($wallet->coin->code); ?></span>
                        </label>
                        <label class="cursor-pointer flex items-center gap-2">
                            <input type="radio" name="unit_type_<?php echo e($wallet->id); ?>" value="usd"
                                class="w-4 h-4 text-primary-600 bg-gray-700 border-gray-500 focus:ring-primary-500"
                                onchange="calculateNewBalance(<?php echo e($wallet->id); ?>, <?php echo e($wallet->balance); ?>, <?php echo e($wallet->coin->value); ?>)">
                            <span class="text-sm font-medium text-white">USD ($)</span>
                        </label>
                    </div>

                    
                    <div class="relative mb-2">
                        <input type="number" step="any" id="visible_amount_<?php echo e($wallet->id); ?>" required placeholder="Enter Amount"
                            class="block w-full rounded-lg border border-gray-600 bg-gray-700 p-2.5 text-sm text-white placeholder-gray-400 focus:ring-primary-500 focus:border-primary-500"
                            oninput="calculateNewBalance(<?php echo e($wallet->id); ?>, <?php echo e($wallet->balance); ?>, <?php echo e($wallet->coin->value); ?>)" />
                        <span id="input_suffix_<?php echo e($wallet->id); ?>" class="absolute right-3 top-2.5 text-gray-400 text-sm font-bold"><?php echo e($wallet->coin->symbol); ?></span>
                    </div>

                    
                    <p id="error_msg_<?php echo e($wallet->id); ?>" class="hidden text-red-500 text-xs text-left mb-2 font-semibold">
                        ⚠️ Insufficient funds for this deduction.
                    </p>

                    
                    <div class="bg-gray-900 rounded p-3 mb-4">
                        <div class="flex justify-between items-center text-sm mb-1">
                            <span class="text-gray-400">New Balance:</span>
                            <span class="font-bold text-white transition-all duration-300">
                                <span id="preview_balance_coin_<?php echo e($wallet->id); ?>"><?php echo e(number_format($wallet->balance, 6)); ?></span> <?php echo e($wallet->coin->code); ?>

                            </span>
                        </div>
                        <div class="flex justify-between items-center text-xs">
                            <span class="text-gray-500">Approx USD:</span>
                            <span id="preview_balance_usd_<?php echo e($wallet->id); ?>" class="text-gray-400">
                                $<?php echo e(number_format($wallet->balance * $wallet->coin->value, 2)); ?>

                            </span>
                        </div>
                    </div>

                    
                    <input type="hidden" name="amount" id="final_amount_<?php echo e($wallet->id); ?>">
                    <input type="hidden" name="id" value="<?php echo e($wallet->id); ?>">

                    <div class="flex justify-center gap-4 mt-6">
                        <button type="submit" id="submit_btn_<?php echo e($wallet->id); ?>" class="px-6 py-2 bg-primary-600 hover:bg-primary-700 text-white font-semibold rounded-lg transition-colors duration-200 disabled:opacity-50 disabled:cursor-not-allowed">Update Wallet</button>
                        <button type="button" class="px-6 py-2 bg-gray-600 hover:bg-gray-700 text-white font-semibold rounded-lg transition-colors duration-200" onclick="closeModal('topup-wallet-<?php echo e($wallet->id); ?>')">Cancel</button>
                    </div>
                </form>
            </div>
         <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $attributes = $__attributesOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__attributesOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9f64f32e90b9102968f2bc548315018c)): ?>
<?php $component = $__componentOriginal9f64f32e90b9102968f2bc548315018c; ?>
<?php unset($__componentOriginal9f64f32e90b9102968f2bc548315018c); ?>
<?php endif; ?>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    
    <?php if(session('success_n')): ?>
        <?php if (isset($component)) { $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-success','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-success'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?><?php echo e(session('success_n')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $attributes = $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $component = $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
    <?php endif; ?>
    <?php if(session('success')): ?>
        <?php if (isset($component)) { $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-success','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-success'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?><?php echo e(session('success')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $attributes = $__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__attributesOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
<?php if (isset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06)): ?>
<?php $component = $__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06; ?>
<?php unset($__componentOriginaleb6323af05d0beb14d8ecb5e3f5f4b06); ?>
<?php endif; ?>
    <?php endif; ?>
    <?php if(session('success_decline')): ?>
        <?php if (isset($component)) { $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-danger','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-danger'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>User Declined <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $attributes = $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $component = $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
    <?php endif; ?>
    <?php if(session('error')): ?>
        <?php if (isset($component)) { $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.toast-danger','data' => []] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('toast-danger'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?><?php echo e(session('error')); ?> <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $attributes = $__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__attributesOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa)): ?>
<?php $component = $__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa; ?>
<?php unset($__componentOriginal5456ec7d3b8c2e0d2da601d6e143d7aa); ?>
<?php endif; ?>
    <?php endif; ?>

    <script>
        function calculateNewBalance(walletId, currentBalance, coinPrice) {
            // Get Elements
            const visibleInput = document.getElementById(`visible_amount_${walletId}`);
            const inputSuffix = document.getElementById(`input_suffix_${walletId}`);
            const finalInput = document.getElementById(`final_amount_${walletId}`);
            const previewCoin = document.getElementById(`preview_balance_coin_${walletId}`);
            const previewUsd = document.getElementById(`preview_balance_usd_${walletId}`);
            const submitBtn = document.getElementById(`submit_btn_${walletId}`);
            const errorMsg = document.getElementById(`error_msg_${walletId}`);

            // Get Settings
            const isCredit = document.querySelector(`input[name="action_type_${walletId}"][value="add"]`).checked;
            const isUsdMode = document.querySelector(`input[name="unit_type_${walletId}"][value="usd"]`).checked;

            // Update Input Suffix UI
            inputSuffix.innerText = isUsdMode ? 'USD' : 'COIN';

            // Get Input Value (default to 0)
            let rawValue = parseFloat(visibleInput.value);
            if(isNaN(rawValue)) rawValue = 0;

            // --- CONVERSION LOGIC ---
            // The controller expects the amount in COINS.
            // If user types in USD, we must convert it to COINS for the final input.
            let coinAmountToAddOrSub = 0;

            if (isUsdMode) {
                // Prevent division by zero just in case
                if(coinPrice > 0) {
                    coinAmountToAddOrSub = rawValue / coinPrice;
                } else {
                    coinAmountToAddOrSub = 0;
                }
            } else {
                // User typed in coins, use directly
                coinAmountToAddOrSub = rawValue;
            }

            // Determine sign based on Credit vs Debit
            let finalSignedCoinValue = isCredit ? coinAmountToAddOrSub : -coinAmountToAddOrSub;

            // Set the hidden input (Always in Coins)
            finalInput.value = finalSignedCoinValue.toFixed(8); // High precision for crypto

            // --- PREVIEW CALCULATION ---
            let newCoinBalance = parseFloat(currentBalance) + finalSignedCoinValue;
            let newUsdBalance = newCoinBalance * coinPrice;

            // --- VALIDATION ---
            if (newCoinBalance < 0) {
                // LOCK FORM
                submitBtn.disabled = true;
                errorMsg.classList.remove('hidden');
                previewCoin.classList.add('text-red-500');
                previewCoin.classList.remove('text-white', 'text-green-400');
                previewCoin.innerText = "Negative Balance";
                previewUsd.innerText = "--";
            } else {
                // UNLOCK FORM
                submitBtn.disabled = false;
                errorMsg.classList.add('hidden');

                // Color Logic
                previewCoin.classList.remove('text-red-500');
                if (newCoinBalance > currentBalance) {
                    previewCoin.classList.add('text-green-400');
                    previewCoin.classList.remove('text-white');
                } else if (newCoinBalance < currentBalance) {
                    previewCoin.classList.add('text-red-400'); // Warning color but valid
                    previewCoin.classList.remove('text-white');
                } else {
                    previewCoin.classList.add('text-white');
                    previewCoin.classList.remove('text-green-400', 'text-red-400');
                }

                // Update Text
                // Format numbers nicely
                previewCoin.innerText = newCoinBalance.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 6 });
                previewUsd.innerText = '$' + newUsdBalance.toLocaleString('en-US', { minimumFractionDigits: 2, maximumFractionDigits: 2 });
            }
        }
    </script>

 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $attributes = $__attributesOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__attributesOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3)): ?>
<?php $component = $__componentOriginal91fdd17964e43374ae18c674f95cdaa3; ?>
<?php unset($__componentOriginal91fdd17964e43374ae18c674f95cdaa3); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\metaglobalbrokers-crypto-investment-app-v3.1\resources\views/admin-dash/user-wallets.blade.php ENDPATH**/ ?>