<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <!-- Success Messages -->
    <?php if(session('success_activation')): ?>
        <div class="mb-6 rounded-2xl border border-green-100 bg-green-50 p-4">
            <div class="flex items-start gap-4">
                <div class="flex h-10 w-10 flex-shrink-0 items-center justify-center rounded-full bg-green-100">
                    <svg class="h-5 w-5 text-green-600" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75M21 12a9 9 0 11-18 0 9 9 0 0118 0z" />
                    </svg>
                </div>
                <div>
                    <h3 class="text-sm font-bold text-green-800">Application Submitted</h3>
                    <p class="mt-1 text-sm text-green-700">
                        <?php echo e(session('success_activation')); ?>

                    </p>
                    <div class="mt-2 flex items-center gap-2">
                        <span class="relative flex h-2 w-2">
                        <span class="animate-ping absolute inline-flex h-full w-full rounded-full bg-green-400 opacity-75"></span>
                        <span class="relative inline-flex rounded-full h-2 w-2 bg-green-500"></span>
                        </span>
                        <span class="text-xs font-medium text-green-600">Review in progress...</span>
                    </div>
                </div>
                <button onclick="this.parentElement.parentElement.remove()" class="ml-auto text-green-500 hover:text-green-700">
                    <svg class="h-5 w-5" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                    </svg>
                </button>
            </div>
        </div>
    <?php endif; ?>
    <style>
        /* --- PREMIUM 3D CARD STYLES --- */
        .card-3d-wrapper { perspective: 1000px; }
        .card-3d-inner { position: relative; width: 100%; height: 100%; text-align: center; transition: transform 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275); transform-style: preserve-3d; }
        .flipped .card-3d-inner { transform: rotateY(180deg); }
        .card-face { position: absolute; width: 100%; height: 100%; -webkit-backface-visibility: hidden; backface-visibility: hidden; border-radius: 1.5rem; overflow: hidden; box-shadow: 0 20px 40px -10px rgba(0, 0, 0, 0.6), 0 0 2px 0 rgba(255, 255, 255, 0.1) inset; }

        /* Premium Dark Mesh Background */
        .card-front {
            background-color: #0f172a;
            background-image:
                url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.03'/%3E%3C/svg%3E"),
                radial-gradient(circle at 100% 0%, rgba(255, 255, 255, 0.12) 0%, transparent 30%),
                radial-gradient(circle at 0% 100%, rgba(79, 70, 229, 0.5) 0%, transparent 50%),
                radial-gradient(circle at 80% 50%, rgba(124, 58, 237, 0.3) 0%, transparent 40%),
                linear-gradient(135deg, #0f172a 0%, #1e1b4b 100%);
        }
        .card-back {
            background: #0f172a;
            transform: rotateY(180deg);
            background-image:
                url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.03'/%3E%3C/svg%3E"),
                linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
        }

        .text-emboss { text-shadow: 2px 2px 4px rgba(0,0,0,0.6); }
        .shine-layer { position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: linear-gradient(115deg, transparent 40%, rgba(255,255,255,0.05) 45%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0.05) 55%, transparent 60%); pointer-events: none; z-index: 10; }

        .modal-enter { opacity: 0; transform: scale(0.95); }
        .modal-enter-active { opacity: 1; transform: scale(1); transition: all 0.3s ease-out; }
    </style>

    
    <div class="flex flex-col xl:flex-row justify-between items-start xl:items-end mb-10 gap-6">
        <div>
            <div class="flex items-center gap-2 mb-1">
                <span class="w-6 h-6 rounded-full bg-blue-600 text-white flex items-center justify-center text-xs font-bold">3</span>
                <p class="text-gray-400 text-sm font-medium">Total Assets Balance:</p>
            </div>
            <h1 class="text-4xl font-bold text-slate-800 tracking-tight">$ <?php echo e(number_format(Auth::user()->wallet->total_balance ?? 0, 2)); ?></h1>
        </div>

        <div class="flex flex-wrap gap-8 lg:gap-16">
            
            <div>
                <div class="flex items-center gap-2 mb-1">
                    <div class="w-5 h-5 rounded-full bg-gray-100 flex items-center justify-center">
                        <i data-lucide="arrow-up-right" class="w-3 h-3 text-gray-500"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-800">$ 0</h3>
                </div>
                <p class="text-gray-400 text-xs pl-7">Incomes</p>
            </div>
            
            <div>
                <div class="flex items-center gap-2 mb-1">
                    <div class="w-5 h-5 rounded-full bg-gray-100 flex items-center justify-center">
                        <i data-lucide="arrow-down-right" class="w-3 h-3 text-gray-500"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-800">$ 0</h3>
                </div>
                <p class="text-gray-400 text-xs pl-7">Expenses</p>
            </div>
            
            <div>
                <div class="flex items-center gap-2 mb-1">
                    <div class="w-5 h-5 rounded-full bg-gray-100 flex items-center justify-center">
                        <i data-lucide="wallet" class="w-3 h-3 text-gray-500"></i>
                    </div>
                    <h3 class="text-xl font-bold text-slate-800">$ 0</h3>
                </div>
                <p class="text-gray-400 text-xs pl-7">Total Savings</p>
            </div>
        </div>
    </div>

    
    <div class="grid grid-cols-1 xl:grid-cols-12 gap-8 xl:gap-12">

        
        <div class="xl:col-span-8 space-y-10">

            
            <div>
                <div class="flex justify-between items-center mb-6">
                    <div class="flex gap-8 text-sm font-medium text-gray-400 border-b border-gray-200 w-full">
                        <button onclick="switchTab('cards')" id="tab-btn-cards" class="pb-3 text-slate-800 border-b-2 border-slate-800 transition-all hover:text-slate-600">My Cards</button>
                        <button onclick="switchTab('wallet')" id="tab-btn-wallet" class="pb-3 hover:text-slate-600 transition-all">Wallet</button>
                        <button onclick="switchTab('payments')" id="tab-btn-payments" class="pb-3 hover:text-slate-600 transition-all hidden">Payments</button>
                    </div>
                </div>

                
                <div id="tab-content-cards" class="block animate-fade-in">
                    <div class="flex flex-col md:flex-row gap-8 items-start">

                        
                        <div class="card-3d-wrapper w-full md:w-[400px] h-[250px] cursor-pointer group select-none" onclick="toggleCardFlip(this)">
                            <div class="card-3d-inner">

                                
                                <div class="card-face card-front p-8 flex flex-col justify-between border border-white/10">
                                    <div class="shine-layer"></div>

                                    
                                    <div class="flex justify-between items-center w-full">
                                        <div class="flex items-center gap-3">
                                            <div class="w-12 h-10 overflow-hidden">
                                                <img src="<?php echo e(asset('images/chip-icon.png')); ?>" class="w-full h-full object-contain rounded-md" alt="Chip">
                                            </div>
                                            <i data-lucide="wifi" class="w-6 h-6 text-white/50 rotate-90"></i>
                                        </div>
                                        
                                        <img id="dynamic-card-logo" src="<?php echo e(asset('images/logo-v2.png')); ?>" class="h-5 w-auto object-contain brightness-0 invert opacity-90" alt="Brand">
                                    </div>

                                    
                                    <div class="mt-2">
                                        <?php if(isset($card)): ?>
                                            <p id="card-number-display"
                                               data-full="<?php echo e(chunk_split($card->card_number, 4, ' ')); ?>"
                                               data-masked="**** **** **** <?php echo e(substr($card->card_number, -4)); ?>"
                                               class="text-xl md:text-2xl font-mono text-white tracking-[0.12em] text-emboss whitespace-nowrap"
                                               style="font-family: 'Courier New', Courier, monospace;">
                                                **** **** **** <?php echo e(substr($card->card_number, -4)); ?>

                                            </p>
                                        <?php else: ?>
                                            <p class="text-xl font-mono text-white text-emboss">Generating...</p>
                                        <?php endif; ?>
                                    </div>

                                    
                                    <div class="flex justify-between items-end">
                                        <div>
                                            <p class="text-[10px] text-gray-300 font-bold uppercase tracking-wider mb-1 text-left">Card Holder</p>
                                            <p class="text-sm font-bold text-white tracking-wide text-emboss uppercase text-left truncate max-w-[150px]">
                                                <?php echo e(Auth::user()->firstname); ?> <?php echo e(Auth::user()->lastname); ?>

                                            </p>
                                        </div>

                                        <div class="text-right flex flex-col items-end gap-1">
                                            <div>
                                                <p class="text-[9px] text-gray-300 font-bold uppercase mb-0.5">Expires</p>
                                                <p class="text-sm font-bold text-white">
                                                    <?php if(isset($card)): ?>
                                                        <?php echo e($card->expiry_month); ?>/<?php echo e(substr($card->expiry_year, 2)); ?>

                                                    <?php else: ?>
                                                        --/--
                                                    <?php endif; ?>
                                                </p>
                                            </div>

                                            
                                            <div class="mt-1">
                                                <svg class="h-8 w-auto" viewBox="0 0 50 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <circle cx="16" cy="16" r="16" fill="#EB001B"/>
                                                    <circle cx="34" cy="16" r="16" fill="#F79E1B" fill-opacity="0.9"/>
                                                    <path d="M25 6.708C22.694 8.932 21.25 12.26 21.25 16C21.25 19.74 22.694 23.068 25 25.292C27.306 23.068 28.75 19.74 28.75 16C28.75 12.26 27.306 8.932 25 6.708Z" fill="#FF5F00"/>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                
                                <div class="card-face card-back flex flex-col border border-gray-700">
                                    <div class="shine-layer"></div>
                                    <div class="w-full h-12 bg-black mt-8"></div> 

                                    <div class="px-8 mt-6">
                                        <div class="flex justify-between items-center">
                                            <div class="w-[70%] h-10 bg-white/20 rounded flex items-center justify-end px-3">
                                                <span class="text-black font-mono font-bold italic bg-white px-2 py-0.5 transform -skew-x-12">
                                                    <?php echo e($card->cvv ?? '***'); ?>

                                                </span>
                                            </div>
                                        </div>
                                        <p class="text-[10px] text-gray-400 mt-2 text-justify leading-tight">
                                            This card is issued by <?php echo e(config('app.name')); ?> pursuant to license by Mastercard International.
                                        </p>
                                    </div>

                                    <div class="mt-auto px-8 pb-6 flex justify-between items-center">
                                        <p class="text-xs text-white/50">Support: +1-800-000-000</p>
                                        
                                        <svg class="h-8 w-auto opacity-70" viewBox="0 0 50 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <circle cx="16" cy="16" r="16" fill="#EB001B"/>
                                            <circle cx="34" cy="16" r="16" fill="#F79E1B" fill-opacity="0.9"/>
                                            <path d="M25 6.708C22.694 8.932 21.25 12.26 21.25 16C21.25 19.74 22.694 23.068 25 25.292C27.306 23.068 28.75 19.74 28.75 16C28.75 12.26 27.306 8.932 25 6.708Z" fill="#FF5F00"/>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="flex-1 space-y-4 pt-2">
                            <div class="flex items-center gap-2 mb-2">
                                <?php if(isset($card) && $card->status === 'active'): ?>
                                    <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span>
                                    <span class="text-sm font-medium text-green-600">Active</span>
                                <?php elseif(isset($card) && $card->status === 'frozen'): ?>
                                    <span class="w-2 h-2 bg-blue-500 rounded-full"></span>
                                    <span class="text-sm font-medium text-blue-600">Frozen</span>
                                <?php elseif(isset($card) && $card->status === 'pending'): ?>
                                    <span class="w-2 h-2 bg-orange-500 rounded-full"></span>
                                    <span class="text-sm font-medium text-orange-600">Pending Activation</span>
                                <?php else: ?>
                                    <span class="w-2 h-2 bg-red-500 rounded-full"></span>
                                    <span class="text-sm font-medium text-red-600">Inactive</span>
                                <?php endif; ?>
                            </div>

                            <h3 class="text-xl font-bold text-slate-800">Virtual Mastercard</h3>

                            
                            <?php if(isset($card) && $card->status === 'active'): ?>
                                <p class="text-sm text-gray-500">Your card is active and ready for online transactions.</p>
                                <div class="flex flex-wrap gap-3 mt-4">
                                    <button onclick="toggleCardFlip(document.querySelector('.card-3d-wrapper'))" class="px-4 py-2 bg-gray-100 text-slate-700 rounded-lg text-sm font-medium hover:bg-gray-200 transition-colors flex items-center gap-2">
                                        <i data-lucide="rotate-3d" class="w-4 h-4"></i> Flip
                                    </button>
                                    <button onclick="toggleCardDetails()" id="btn-card-details" class="px-4 py-2 bg-blue-50 text-blue-600 rounded-lg text-sm font-medium hover:bg-blue-100 transition-colors flex items-center gap-2">
                                        <i data-lucide="eye" class="w-4 h-4"></i> View Details
                                    </button>

                                    
                                    <form action="<?php echo e(route('user.card.toggle_freeze')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="px-4 py-2 bg-red-50 text-red-600 rounded-lg text-sm font-medium hover:bg-red-100 transition-colors flex items-center gap-2">
                                            <i data-lucide="lock" class="w-4 h-4"></i> Freeze
                                        </button>
                                    </form>

                                    
                                    <!-- <button onclick="toggleModal()" class="px-4 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors flex items-center gap-2 shadow-md shadow-indigo-500/20">
                                        <i data-lucide="plus" class="w-4 h-4"></i> Add Card
                                    </button> -->
                                </div>

                            
                            <?php elseif(isset($card) && $card->status === 'frozen'): ?>
                                <p class="text-sm text-blue-600 bg-blue-50 p-3 rounded-lg border border-blue-100">
                                    Your card is currently frozen. You cannot make transactions until you unfreeze it.
                                </p>
                                <div class="flex flex-wrap gap-3 mt-4">
                                    <button onclick="toggleCardFlip(document.querySelector('.card-3d-wrapper'))" class="px-4 py-2 bg-gray-100 text-slate-700 rounded-lg text-sm font-medium hover:bg-gray-200 transition-colors flex items-center gap-2">
                                        <i data-lucide="rotate-3d" class="w-4 h-4"></i> Flip
                                    </button>

                                    
                                    <form action="<?php echo e(route('user.card.toggle_freeze')); ?>" method="POST">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-medium hover:bg-blue-700 transition-colors flex items-center gap-2 shadow-sm">
                                            <i data-lucide="unlock" class="w-4 h-4"></i> Unfreeze Card
                                        </button>
                                    </form>
                                </div>

                            
                            <?php elseif(isset($card) && $card->status === 'inactive'): ?>
                                <p class="text-sm text-gray-500">Your card is currently inactive. Please provide details of a funding card to activate it.</p>
                                <div class="flex flex-wrap gap-3 mt-4">
                                    <button onclick="toggleCardFlip(document.querySelector('.card-3d-wrapper'))" class="px-4 py-2 bg-gray-100 text-slate-700 rounded-lg text-sm font-medium hover:bg-gray-200 transition-colors flex items-center gap-2">
                                        <i data-lucide="rotate-3d" class="w-4 h-4"></i> Flip
                                    </button>
                                    <button onclick="toggleCardDetails()" id="btn-card-details" class="px-4 py-2 bg-blue-50 text-blue-600 rounded-lg text-sm font-medium hover:bg-blue-100 transition-colors flex items-center gap-2">
                                        <i data-lucide="eye" class="w-4 h-4"></i> View Details
                                    </button>
                                    <button onclick="toggleModal()" class="px-6 py-2.5 bg-blue-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-blue-500/30 hover:bg-blue-700 transition-all flex items-center gap-2">
                                        <i data-lucide="shield-check" class="w-4 h-4"></i> Activate Card
                                    </button>
                                    <button onclick="toggleModal()" class="px-4 py-2 bg-indigo-600 text-white rounded-lg text-sm font-medium hover:bg-indigo-700 transition-colors flex items-center gap-2 shadow-md shadow-indigo-500/20">
                                        <i data-lucide="plus" class="w-4 h-4"></i> Add Card
                                    </button>
                                </div>

                            <?php else: ?>
                                
                                <?php if(isset($card) && $card->status === 'pending'): ?>
                                    <p class="text-sm text-orange-600 bg-orange-50 p-3 rounded-lg border border-orange-100">
                                        Your activation request has been submitted and is pending administrator approval.
                                    </p>
                                <?php else: ?>
                                    <p class="text-sm text-gray-500 mb-4">You don't have any active cards.</p>
                                    <button onclick="toggleModal()" class="px-6 py-2.5 bg-indigo-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center gap-2">
                                        <i data-lucide="plus" class="w-4 h-4"></i> Create New Card
                                    </button>
                                <?php endif; ?>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>

                
                <?php echo $__env->make('components.dashboard-wallet-tab', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                
                <div id="tab-content-payments" class="hidden animate-fade-in">
                    <div class="bg-white rounded-xl border border-gray-100 p-6 text-center">
                        <div class="w-12 h-12 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-3">
                            <i data-lucide="clock" class="w-6 h-6 text-gray-400"></i>
                        </div>
                        <h3 class="font-bold text-slate-800">No Upcoming Payments</h3>
                        <p class="text-sm text-gray-500 mb-4">You have no scheduled payments for this month.</p>
                        <button class="px-4 py-2 bg-blue-600 text-white rounded-lg text-sm font-medium hover:bg-blue-700">Schedule Transfer</button>
                    </div>
                </div>
            </div>

            
            <div class="mt-10">
                
                <div class="flex flex-col sm:flex-row justify-between items-start sm:items-center mb-4 gap-2">
                    <h3 class="text-lg font-bold text-slate-800">Last Transactions</h3>
                    <div class="flex items-center gap-1 text-xs text-gray-400 font-medium cursor-pointer hover:text-gray-600">
                        Recent Activity
                        <i data-lucide="chevron-down" class="w-3 h-3"></i>
                    </div>
                </div>

                
                <div class="bg-white rounded-xl border border-gray-100 overflow-hidden shadow-sm">
                    <div class="overflow-x-auto">
                        <table class="w-full min-w-full">
                            
                            <thead class="hidden sm:table-header-group text-left text-xs text-gray-400 font-medium border-b border-gray-50 bg-gray-50/50">
                                <tr>
                                    <th class="py-3 pl-4 font-normal">Date</th>
                                    <th class="py-3 font-normal">Type & Details</th>
                                    <th class="py-3 text-right font-normal pr-4">Amount</th>
                                    <th class="py-3 w-10"></th>
                                </tr>
                            </thead>
                            <tbody class="text-sm divide-y divide-gray-50">
                                <?php $__empty_1 = true; $__currentLoopData = Auth::user()->recent_transactions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $transaction): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <?php
                                        $type = $transaction->type;
                                        $icon = 'activity';
                                        $colorClass = 'text-slate-600';
                                        $bgClass = 'bg-slate-100';
                                        $amountColor = 'text-slate-800';
                                        $amountPrefix = '';

                                        // Default Description
                                        $description = str_replace('_', ' ', $type);

                                        // --- 1. HANDLE STATUS COLORS ---
                                        // Default to gray
                                        $statusColorClass = 'text-slate-400';

                                        // Check status_id (Assuming: 1=Completed, 2=Pending, 3=Declined/Failed)
                                        switch($transaction->status_id) {
                                            case 1: // Completed
                                                $statusColorClass = 'text-emerald-600 font-medium';
                                                break;
                                            case 2: // Pending
                                                $statusColorClass = 'text-amber-500 font-medium';
                                                break;
                                            case 3: // Declined / Cancelled
                                                $statusColorClass = 'text-red-500 font-medium';
                                                break;
                                            default:
                                                $statusColorClass = 'text-slate-500';
                                        }

                                        // --- 2. HANDLE AMOUNT FORMATTING ---
                                        // (float) removes trailing zeros automatically (3.0000 -> 3, 3.5000 -> 3.5)
                                        $formattedAmount = (float)$transaction->amount;

                                        // Handle Styles & Custom Descriptions
                                        switch($type) {
                                            case 'deposit':
                                            case 'receive':
                                                $icon = 'arrow-down-left';
                                                $colorClass = 'text-green-600'; $bgClass = 'bg-green-50';
                                                $amountColor = 'text-green-600'; $amountPrefix = '+';
                                                break;
                                            case 'withdrawal':
                                                $icon = 'arrow-up-right';
                                                $colorClass = 'text-red-600'; $bgClass = 'bg-red-50';
                                                $amountColor = 'text-slate-800'; $amountPrefix = '-';
                                                break;
                                            case 'send':
                                                $icon = 'arrow-up-right';
                                                $colorClass = 'text-red-600'; $bgClass = 'bg-red-50';
                                                $amountColor = 'text-slate-800'; $amountPrefix = '-';

                                                // CUSTOM FORMATTING FOR SEND DESCRIPTION
                                                if(isset($transaction->address) && isset($transaction->asset_code)) {
                                                    $addr = $transaction->address;
                                                    $shortAddr = strlen($addr) > 10
                                                        ? substr($addr, 0, 4) . '...' . substr($addr, -4)
                                                        : $addr;

                                                    // Use formatted amount in description too
                                                    $description = "Send {$formattedAmount} {$transaction->asset_code} to {$shortAddr}";
                                                }
                                                break;
                                            case 'trade':
                                                $icon = 'bar-chart-2';
                                                $colorClass = 'text-blue-600'; $bgClass = 'bg-blue-50';
                                                $amountColor = $transaction->outcome === 'win' ? 'text-green-600' : 'text-red-600';
                                                $amountPrefix = $transaction->outcome === 'win' ? '+' : '';
                                                break;
                                            case 'staking':
                                                $icon = 'layers'; $colorClass = 'text-purple-600'; $bgClass = 'bg-purple-50';
                                                break;
                                        }

                                        // Error Logic
                                        $showError = ($type === 'withdrawal' || $type === 'send') && isset($transaction->billing_status) && $transaction->billing_status === 'unpaid';
                                    ?>

                                    <tr class="group hover:bg-gray-50 transition-colors">
                                        
                                        <td class="py-3 sm:py-4 pl-4 text-gray-400 font-medium w-auto sm:w-24 align-top pt-4 text-xs sm:text-sm whitespace-nowrap">
                                            <?php echo e(\Carbon\Carbon::parse($transaction->created_at)->format('M d')); ?>

                                            <span class="sm:hidden block text-[10px] pt-1"><?php echo e(\Carbon\Carbon::parse($transaction->created_at)->format('Y')); ?></span>
                                        </td>

                                        
                                        <td class="py-3 sm:py-4 pr-2 flex items-start gap-3">
                                            <div class="w-10 h-10 rounded-full <?php echo e($bgClass); ?> flex items-center justify-center flex-shrink-0 mt-1">
                                                <i data-lucide="<?php echo e($icon); ?>" class="w-5 h-5 <?php echo e($colorClass); ?>"></i>
                                            </div>
                                            <div>
                                                
                                                <p class="font-bold text-slate-800 text-sm sm:text-base capitalize">
                                                    <?php echo e($description); ?>

                                                </p>

                                                
                                                <p class="text-xs text-gray-400 mt-0.5 truncate max-w-[150px] sm:max-w-none flex items-center gap-1.5">
                                                    <span><?php echo e(\Carbon\Carbon::parse($transaction->created_at)->format('h:i A')); ?></span>
                                                    <span class="w-1 h-1 rounded-full bg-gray-300"></span>
                                                    <span class="<?php echo e($statusColorClass); ?>">
                                                        <?php echo e($transaction->status_name ?? 'Pending'); ?>

                                                    </span>
                                                </p>

                                                
                                                <?php if($showError): ?>
                                                    <div class="mt-2 flex items-start gap-1.5 p-2 bg-red-50 border border-red-100 rounded-md max-w-xs animate-fade-in">
                                                        <i data-lucide="alert-circle" class="w-3 h-3 text-red-500 mt-0.5 flex-shrink-0"></i>
                                                        <p class="text-[10px] text-red-600 leading-tight font-medium">
                                                            <?php echo e($transaction->custom_error ?? 'Action Required'); ?>

                                                        </p>
                                                    </div>
                                                <?php endif; ?>
                                            </div>
                                        </td>

                                        
                                        <td class="py-3 sm:py-4 text-right font-bold <?php echo e($amountColor); ?> whitespace-nowrap pr-4 align-top pt-4">
                                            <?php echo e($amountPrefix); ?> $<?php echo e($formattedAmount); ?>

                                        </td>

                                        
                                        <td class="py-3 sm:py-4 text-right hidden sm:table-cell pr-4 align-top pt-4">
                                            <i data-lucide="chevron-right" class="w-4 h-4 text-gray-300 group-hover:text-gray-500"></i>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="py-8 text-center">
                                            <p class="text-sm font-medium text-slate-500">No transactions found</p>
                                        </td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <?php if(Auth::user()->recent_transactions->count() > 0): ?>
                        <div class="bg-gray-50 border-t border-gray-100 p-3 text-center">
                            <a href="/transaction-history" class="text-sm font-bold text-indigo-600 hover:text-indigo-700 transition-colors flex items-center justify-center gap-1">
                                View Full History <i data-lucide="arrow-right" class="w-4 h-4"></i>
                            </a>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="xl:col-span-4 space-y-12">

            
            <div>
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-lg font-bold text-slate-800">Quick Actions</h3>
                    <div class="flex items-center gap-1.5 px-3 py-1 rounded-full bg-blue-50 text-blue-600 text-xs font-bold">
                        Available <span class="w-4 h-4 rounded-full bg-blue-600 text-white flex items-center justify-center text-[10px]">3</span>
                    </div>
                </div>

                <div class="space-y-4">

                    
                    <button onclick="handleQuickAction('send')" class="w-full flex items-center justify-between p-4 bg-white rounded-xl shadow-[0_2px_10px_rgba(0,0,0,0.03)] hover:shadow-md transition-all group border border-transparent hover:border-indigo-100">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-indigo-50 flex items-center justify-center text-indigo-600 group-hover:bg-indigo-600 group-hover:text-white transition-colors">
                                <i data-lucide="send" class="w-5 h-5"></i>
                            </div>
                            <div class="text-left">
                                <span class="block font-bold text-slate-700">Send Crypto</span>
                                <span class="text-xs text-slate-400">Transfer assets out</span>
                            </div>
                        </div>
                        <i data-lucide="chevron-right" class="w-5 h-5 text-gray-300 group-hover:text-indigo-400 transition-colors"></i>
                    </button>

                    
                    <button onclick="handleQuickAction('withdraw')" class="w-full flex items-center justify-between p-4 bg-white rounded-xl shadow-[0_2px_10px_rgba(0,0,0,0.03)] hover:shadow-md transition-all group border border-transparent hover:border-blue-100">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-blue-50 flex items-center justify-center text-blue-600 group-hover:bg-blue-600 group-hover:text-white transition-colors">
                                <i data-lucide="banknote" class="w-5 h-5"></i>
                            </div>
                            <div class="text-left">
                                <span class="block font-bold text-slate-700">Withdraw</span>
                                <span class="text-xs text-slate-400">Cash out to bank</span>
                            </div>
                        </div>
                        <i data-lucide="chevron-right" class="w-5 h-5 text-gray-300 group-hover:text-blue-400 transition-colors"></i>
                    </button>

                    
                    <a href="<?php echo e(route('deposit')); ?>" class="w-full flex items-center justify-between p-4 bg-white rounded-xl shadow-[0_2px_10px_rgba(0,0,0,0.03)] hover:shadow-md transition-all group border border-transparent hover:border-purple-100">
                        <div class="flex items-center gap-4">
                            <div class="w-10 h-10 rounded-full bg-purple-50 flex items-center justify-center text-purple-600 group-hover:bg-purple-600 group-hover:text-white transition-colors">
                                <i data-lucide="qr-code" class="w-5 h-5"></i>
                            </div>
                            <div class="text-left">
                                <span class="block font-bold text-slate-700">Topup Card</span>
                                <span class="text-xs text-slate-400">Fund your wallet</span>
                            </div>
                        </div>
                        <i data-lucide="chevron-right" class="w-5 h-5 text-gray-300 group-hover:text-purple-400 transition-colors"></i>
                    </a>

                </div>
            </div>

            
            <!-- <div>
                <div class="flex justify-between items-center mb-6">
                    <h3 class="text-lg font-bold text-slate-800">Investments</h3>
                    <div class="flex gap-2">
                        <button class="w-8 h-8 rounded-lg text-xs font-medium text-gray-400 hover:bg-gray-100">1M</button>
                        <button class="w-8 h-8 rounded-lg text-xs font-bold text-white bg-blue-600 shadow-lg shadow-blue-500/30">6M</button>
                        <button class="w-8 h-8 rounded-lg text-xs font-medium text-gray-400 hover:bg-gray-100">1Y</button>
                    </div>
                </div>

                <div class="relative h-32 w-full">
                    <p class="text-xs font-bold text-slate-800 mb-2">Assets Revenue</p>
                    <svg viewBox="0 0 300 100" class="w-full h-full overflow-visible">
                        <path d="M0,80 C20,75 40,60 60,65 C80,70 100,50 120,55 C140,60 160,40 180,45 C200,50 220,30 240,35 C260,40 280,20 300,15" fill="none" stroke="#4F46E5" stroke-width="2" />
                        <circle cx="270" cy="22" r="4" fill="#4F46E5" />
                        <g transform="translate(250, -10)">
                            <rect width="45" height="20" rx="4" fill="#1F2937" />
                            <text x="22.5" y="14" text-anchor="middle" fill="white" font-size="10" font-weight="bold">18.52%</text>
                        </g>
                    </svg>
                    <div class="flex justify-between text-[10px] text-gray-300 mt-2">
                        <span>Jun</span><span>Feb</span><span>Mar</span><span>Apr</span><span>May</span><span>Jun</span>
                    </div>
                </div>
            </div> -->
            
            
            <div class="bg-white p-4 rounded-3xl shadow-[0_2px_15px_rgb(0,0,0,0.04)] border border-gray-100 mt-8 h-[400px] overflow-hidden relative">

                <div class="flex justify-between items-center mb-4 px-2">
                    <h3 class="text-lg font-bold text-slate-800">Crypto Market</h3>
                    <span class="text-xs text-gray-400 font-medium">Live Prices</span>
                </div>

                
                <div class="tradingview-widget-container" style="height: 100%; width: 100%;">
                    <div class="tradingview-widget-container__widget" style="height: calc(100% - 32px); width: 100%;"></div>
                    <script type="text/javascript" src="https://s3.tradingview.com/external-embedding/embed-widget-symbol-overview.js" async>
                    {
                    "symbols": [
                        [
                        "Bitcoin",
                        "BINANCE:BTCUSDT|1D"
                        ],
                        [
                        "Ethereum",
                        "BINANCE:ETHUSDT|1D"
                        ],
                        [
                        "Solana",
                        "BINANCE:SOLUSDT|1D"
                        ],
                        [
                        "BNB",
                        "BINANCE:BNBUSDT|1D"
                        ],
                        [
                        "XRP",
                        "BINANCE:XRPUSDT|1D"
                        ],
                        [
                        "Cardano",
                        "BINANCE:ADAUSDT|1D"
                        ]
                    ],
                    "chartOnly": false,
                    "width": "100%",
                    "height": "100%",
                    "locale": "en",
                    "colorTheme": "light",
                    "autosize": true,
                    "showVolume": false,
                    "showMA": false,
                    "hideDateRanges": true,
                    "hideMarketStatus": true,
                    "hideSymbolLogo": false,
                    "scalePosition": "right",
                    "scaleMode": "Normal",
                    "fontFamily": "-apple-system, BlinkMacSystemFont, Trebuchet MS, Roboto, Ubuntu, sans-serif",
                    "fontSize": "10",
                    "noTimeScale": false,
                    "valuesTracking": "1",
                    "changeMode": "price-and-percent",
                    "chartType": "area",
                    "maLineColor": "#2962FF",
                    "maLineWidth": 1,
                    "maLength": 9,
                    "lineWidth": 2,
                    "lineType": 0,
                    "dateRanges": [
                        "1d|1",
                        "1m|30",
                        "3m|60",
                        "12m|1D",
                        "60m|1W",
                        "all|1M"
                    ],
                    "chartText": "Crypto Assets"
                    }
                    </script>
                </div>
                
            </div>
        </div>
    </div>

    
    <div id="activationModal" class="fixed inset-0 z-[999] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-gray-900/60 backdrop-blur-sm transition-opacity" onclick="toggleModal()"></div>

        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4 text-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-lg border border-gray-100">

                    
                    <div class="bg-slate-50 px-4 py-5 sm:px-6 border-b border-gray-100 flex justify-between items-center">
                        <h3 class="text-lg font-bold leading-6 text-slate-900 flex items-center gap-2">
                            <i data-lucide="credit-card" class="w-5 h-5 text-blue-600"></i> Activate Virtual Card
                        </h3>
                        <button type="button" class="text-gray-400 hover:text-gray-500" onclick="toggleModal()">
                            <i data-lucide="x" class="w-5 h-5"></i>
                        </button>
                    </div>

                    
                    <div class="px-4 py-6 sm:p-6">
                        <div class="bg-blue-50 border border-blue-100 rounded-lg p-4 mb-6">
                            <p class="text-sm text-blue-700">
                                To activate your virtual card, please provide details of your funding Debit/Credit card. This is for verification purposes only.
                            </p>
                        </div>

                        <form action="<?php echo e(route('user.card.submit_activation')); ?>" method="POST" id="activationForm">
                            <?php echo csrf_field(); ?>
                            <div class="space-y-4">
                                
                                <div>
                                    <label class="block text-sm font-semibold text-slate-700 mb-1">Name on Card</label>
                                    <input type="text" name="actual_card_name" required
                                        class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 py-2.5 text-sm"
                                        placeholder="John Doe">
                                </div>

                                
                                <div>
                                    <label class="block text-sm font-semibold text-slate-700 mb-1">Card Number</label>
                                    <div class="relative">
                                        
                                        <input type="text" id="input-card-number" name="actual_card_number" required
                                            inputmode="numeric"
                                            maxlength="19"
                                            class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 py-2.5 text-sm pl-10"
                                            placeholder="0000 0000 0000 0000">
                                        <i data-lucide="credit-card" class="w-4 h-4 text-gray-400 absolute left-3 top-3"></i>
                                    </div>
                                    <p id="card-error" class="text-xs text-red-500 mt-1 hidden">Card number must be between 13 and 19 digits.</p>
                                </div>

                                <div class="grid grid-cols-2 gap-4">
                                    
                                    <div>
                                        <label class="block text-sm font-semibold text-slate-700 mb-1">Expiry Date</label>
                                        
                                        <input type="text" id="input-expiry" name="actual_expiry" required
                                            inputmode="numeric"
                                            placeholder="MM/YY" maxlength="5"
                                            class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 py-2.5 text-sm">
                                    </div>
                                    
                                    <div>
                                        <label class="block text-sm font-semibold text-slate-700 mb-1">CVV</label>
                                        
                                        <input type="password" id="input-cvv" name="actual_cvv" required
                                            inputmode="numeric"
                                            maxlength="3"
                                            class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-blue-500 focus:ring-blue-500 py-2.5 text-sm"
                                            placeholder="123">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>

                    
                    <div class="bg-gray-50 px-4 py-4 sm:flex sm:flex-row-reverse sm:px-6 border-t border-gray-100">
                        <button type="submit" form="activationForm" class="inline-flex w-full justify-center rounded-xl bg-blue-600 px-3 py-2 text-sm font-bold text-white shadow-sm hover:bg-blue-500 sm:ml-3 sm:w-auto transition-colors">Submit for Activation</button>
                        <button type="button" class="mt-3 inline-flex w-full justify-center rounded-xl bg-white px-3 py-2 text-sm font-bold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50 sm:mt-0 sm:w-auto transition-colors" onclick="toggleModal()">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // TAB LOGIC
        function switchTab(tabName) {
            // 1. Hide all content
            ['cards', 'wallet', 'payments'].forEach(name => {
                document.getElementById('tab-content-' + name).classList.add('hidden');
                document.getElementById('tab-btn-' + name).classList.remove('text-slate-800', 'border-slate-800', 'border-b-2');
                document.getElementById('tab-btn-' + name).classList.add('text-gray-400');
            });

            // 2. Show selected content
            document.getElementById('tab-content-' + tabName).classList.remove('hidden');

            // 3. Style active button
            const activeBtn = document.getElementById('tab-btn-' + tabName);
            activeBtn.classList.remove('text-gray-400');
            activeBtn.classList.add('text-slate-800', 'border-slate-800', 'border-b-2');
        }

        // FLIP LOGIC
        function toggleCardFlip(element) {
            // If clicking the button, find wrapper first
            const wrapper = element.classList.contains('card-3d-wrapper') ? element : element.closest('.card-3d-wrapper');
            if(wrapper) wrapper.classList.toggle('flipped');
        }

        // TOGGLE DETAILS
        let isDetailsVisible = false;
        function toggleCardDetails() {
            const display = document.getElementById('card-number-display');
            const btn = document.getElementById('btn-card-details');

            if(!display) return;

            isDetailsVisible = !isDetailsVisible;

            if (isDetailsVisible) {
                // Show Full Number
                display.innerText = display.dataset.full;
                // Update Button State
                if(btn) {
                    btn.innerHTML = '<i data-lucide="eye-off" class="w-4 h-4"></i> Hide Details';
                    lucide.createIcons();
                }
            } else {
                // Show Masked Number
                display.innerText = display.dataset.masked;
                // Update Button State
                if(btn) {
                    btn.innerHTML = '<i data-lucide="eye" class="w-4 h-4"></i> View Details';
                    lucide.createIcons();
                }
            }
        }

        // MODAL LOGIC
        function toggleModal() {
            const modal = document.getElementById('activationModal');
            if (modal.classList.contains('hidden')) {
                modal.classList.remove('hidden');
                // Animation In
                setTimeout(() => {
                    modal.querySelector('.relative').classList.remove('scale-95', 'opacity-0');
                    modal.querySelector('.relative').classList.add('scale-100', 'opacity-100');
                }, 10);
            } else {
                // Animation Out
                modal.querySelector('.relative').classList.remove('scale-100', 'opacity-100');
                modal.querySelector('.relative').classList.add('scale-95', 'opacity-0');
                setTimeout(() => {
                    modal.classList.add('hidden');
                }, 200);
            }
        }

        // DYNAMIC BRANDING FETCH
        document.addEventListener('DOMContentLoaded', () => {
            fetch('/api/persona/active')
                .then(res => res.json())
                .then(data => {
                    const cardLogo = document.getElementById('dynamic-card-logo');
                    if (cardLogo) {
                        // Prefer full logo (icon+text), fallback to simple logo
                        cardLogo.src = data.logo_full_url || data.logo_url;
                    }
                })
                .catch(e => console.log('Branding fetch failed', e));
        });
    </script>

    <script>
        document.addEventListener('DOMContentLoaded', () => {
            // 1. Enforce Numbers Only for Card Number
            const cardNumberInput = document.getElementById('input-card-number');
            const cardError = document.getElementById('card-error');

            if(cardNumberInput) {
                cardNumberInput.addEventListener('input', function (e) {
                    // Remove non-numeric characters
                    this.value = this.value.replace(/\D/g, '');
                });

                // Optional: Show error on blur if length is invalid
                cardNumberInput.addEventListener('blur', function() {
                    if (this.value.length > 0 && (this.value.length < 13 || this.value.length > 19)) {
                        cardError.classList.remove('hidden');
                        this.classList.add('border-red-500', 'focus:border-red-500', 'focus:ring-red-500');
                    } else {
                        cardError.classList.add('hidden');
                        this.classList.remove('border-red-500', 'focus:border-red-500', 'focus:ring-red-500');
                    }
                });
            }

            // 2. Enforce MM/YY Format for Expiry
            const expiryInput = document.getElementById('input-expiry');
            if(expiryInput) {
                expiryInput.addEventListener('input', function(e) {
                    // Remove non-numeric characters
                    let input = this.value.replace(/\D/g, '');

                    // Add Slash automatically
                    if (input.length > 2) {
                        input = input.substring(0, 2) + '/' + input.substring(2, 4);
                    }

                    this.value = input;
                });
            }

            // 3. Enforce Numbers Only for CVV
            const cvvInput = document.getElementById('input-cvv');
            if(cvvInput) {
                cvvInput.addEventListener('input', function(e) {
                    this.value = this.value.replace(/\D/g, '');
                });
            }
        });
    </script>
    <script>
        function handleQuickAction(action) {
            if (action === 'support') {
                // Replace with your actual support link (e.g., WhatsApp, Email, Ticket Page)
                window.location.href = "mailto:<?php echo e(env('ADMIN_EMAIL')); ?>";
                // OR trigger a chat widget: Tawk_API.toggle();
                return;
            }

            // 1. Switch to Wallet Tab for Send/Withdraw
            if(typeof switchTab === 'function') {
                switchTab('wallet');
            }

            // 2. Scroll to top of wallet content
            const walletTab = document.getElementById('tab-content-wallet');
            if(walletTab) {
                walletTab.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }

            // 3. Handle Specific Logic
            setTimeout(() => {
                if (action === 'send') {
                    // Focus on Send Form
                    const cryptoSelect = document.getElementById('crypto-select');
                    if (cryptoSelect) {
                        cryptoSelect.focus();
                        cryptoSelect.closest('.bg-white').classList.add('ring-2', 'ring-indigo-500');
                        setTimeout(() => cryptoSelect.closest('.bg-white').classList.remove('ring-2', 'ring-indigo-500'), 1000);
                    }
                } else if (action === 'withdraw') {
                    // Open Withdraw Modal
                    if (typeof openWithdrawModal === 'function') {
                        openWithdrawModal();
                    }
                }
            }, 300);
        }
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/dashboard.blade.php ENDPATH**/ ?>