<?php if (isset($component)) { $__componentOriginal951024bfcf58033c82ac11d797616473 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal951024bfcf58033c82ac11d797616473 = $attributes; } ?>
<?php $component = App\View\Components\UserLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('user-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\UserLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <style>
        /* --- PREMIUM 3D CARD STYLES --- */
        .card-3d-wrapper { perspective: 1000px; }
        .card-3d-inner { position: relative; width: 100%; height: 100%; text-align: center; transition: transform 0.8s cubic-bezier(0.175, 0.885, 0.32, 1.275); transform-style: preserve-3d; }
        .flipped .card-3d-inner { transform: rotateY(180deg); }
        .card-face { position: absolute; width: 100%; height: 100%; -webkit-backface-visibility: hidden; backface-visibility: hidden; border-radius: 1.5rem; overflow: hidden; box-shadow: 0 20px 40px -10px rgba(0, 0, 0, 0.6), 0 0 2px 0 rgba(255, 255, 255, 0.1) inset; }

        /* Dark Mesh Background */
        .card-front {
            background-color: #0f172a;
            background-image:
                url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.03'/%3E%3C/svg%3E"),
                radial-gradient(circle at 100% 0%, rgba(255, 255, 255, 0.12) 0%, transparent 30%),
                radial-gradient(circle at 0% 100%, rgba(79, 70, 229, 0.5) 0%, transparent 50%),
                radial-gradient(circle at 80% 50%, rgba(124, 58, 237, 0.3) 0%, transparent 40%),
                linear-gradient(135deg, #0f172a 0%, #1e1b4b 100%);
        }
        .card-back {
            background: #0f172a;
            transform: rotateY(180deg);
            background-image:
                url("data:image/svg+xml,%3Csvg viewBox='0 0 200 200' xmlns='http://www.w3.org/2000/svg'%3E%3Cfilter id='noiseFilter'%3E%3CfeTurbulence type='fractalNoise' baseFrequency='0.8' numOctaves='3' stitchTiles='stitch'/%3E%3C/filter%3E%3Crect width='100%25' height='100%25' filter='url(%23noiseFilter)' opacity='0.03'/%3E%3C/svg%3E"),
                linear-gradient(135deg, #1e293b 0%, #0f172a 100%);
        }

        .text-emboss { text-shadow: 2px 2px 4px rgba(0,0,0,0.6); }
        .shine-layer { position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: linear-gradient(115deg, transparent 40%, rgba(255,255,255,0.05) 45%, rgba(255,255,255,0.1) 50%, rgba(255,255,255,0.05) 55%, transparent 60%); pointer-events: none; z-index: 10; }

        /* Modal Transitions */
        .modal-enter { opacity: 0; transform: scale(0.95); }
        .modal-enter-active { opacity: 1; transform: scale(1); transition: all 0.3s ease-out; }
    </style>

    <div class="max-w-[1600px] mx-auto space-y-8">

        
        <div class="flex justify-between items-center">
            <div>
                <h1 class="text-2xl font-bold text-slate-900">Card Management</h1>
                <p class="text-sm text-slate-500 mt-1">Manage your virtual cards, limits, and security.</p>
            </div>
            <?php if($card->status === 'active'): ?>
                <a href="/deposit" class="flex items-center gap-2 px-4 py-2 bg-indigo-600 text-white rounded-xl text-sm font-bold shadow-lg shadow-indigo-500/20 hover:bg-indigo-700 transition-all">
                    <i data-lucide="plus" class="w-4 h-4"></i> Add Money
                </a>
            <?php endif; ?>
        </div>

        <div class="grid grid-cols-1 lg:grid-cols-12 gap-8">

            
            <div class="lg:col-span-5 xl:col-span-4 space-y-6">

                
                <div class="card-3d-wrapper w-full h-[240px] sm:h-[260px] cursor-pointer group select-none" onclick="toggleCardFlip(this)">
                    <div class="card-3d-inner">
                        
                        <div class="card-face card-front p-8 flex flex-col justify-between border border-white/10">
                            <div class="shine-layer"></div>
                            
                            <div class="flex justify-between items-start w-full">
                                <div class="flex items-center gap-3">
                                    <div class="w-12 h-10 overflow-hidden">
                                        <img src="<?php echo e(asset('images/chip-icon.png')); ?>" class="w-full h-full object-contain rounded-md" alt="Chip">
                                    </div>
                                    <i data-lucide="wifi" class="w-6 h-6 text-white/50 rotate-90"></i>
                                </div>
                                <img id="dynamic-card-logo" src="<?php echo e(asset('images/logo-v2.png')); ?>" class="h-8 w-auto object-contain brightness-0 invert opacity-90" alt="Brand">
                            </div>
                            
                            <div class="mt-2">
                                <p id="card-number-display"
                                   data-full="<?php echo e(chunk_split($card->card_number, 4, ' ')); ?>"
                                   data-masked="**** **** **** <?php echo e(substr($card->card_number, -4)); ?>"
                                   class="text-xl md:text-2xl font-mono text-white tracking-[0.12em] text-emboss whitespace-nowrap"
                                   style="font-family: 'Courier New', Courier, monospace;">
                                    **** **** **** <?php echo e(substr($card->card_number, -4)); ?>

                                </p>
                            </div>
                            
                            <div class="flex justify-between items-end">
                                <div>
                                    <p class="text-[10px] text-gray-300 font-bold uppercase tracking-wider mb-1 text-left">Card Holder</p>
                                    <p class="text-sm font-bold text-white tracking-wide text-emboss uppercase text-left truncate max-w-[150px]">
                                        <?php echo e(Auth::user()->firstname); ?> <?php echo e(Auth::user()->lastname); ?>

                                    </p>
                                </div>
                                <div class="text-right flex flex-col items-end gap-1">
                                    <div>
                                        <p class="text-[9px] text-gray-300 font-bold uppercase mb-0.5">Expires</p>
                                        <p class="text-sm font-bold text-white"><?php echo e($card->expiry_month); ?>/<?php echo e(substr($card->expiry_year, 2)); ?></p>
                                    </div>
                                    <div class="mt-1">
                                        <svg class="h-8 w-auto" viewBox="0 0 50 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <circle cx="16" cy="16" r="16" fill="#EB001B"/>
                                            <circle cx="34" cy="16" r="16" fill="#F79E1B" fill-opacity="0.9"/>
                                            <path d="M25 6.708C22.694 8.932 21.25 12.26 21.25 16C21.25 19.74 22.694 23.068 25 25.292C27.306 23.068 28.75 19.74 28.75 16C28.75 12.26 27.306 8.932 25 6.708Z" fill="#FF5F00"/>
                                        </svg>
                                    </div>
                                </div>
                            </div>
                        </div>

                        
                        <div class="card-face card-back flex flex-col border border-gray-700">
                            <div class="shine-layer"></div>
                            <div class="w-full h-12 bg-black mt-8"></div>
                            <div class="px-8 mt-6">
                                <div class="flex justify-between items-center">
                                    <div class="w-[70%] h-10 bg-white/20 rounded flex items-center justify-end px-3">
                                        <span class="text-black font-mono font-bold italic bg-white px-2 py-0.5 transform -skew-x-12"><?php echo e($card->cvv); ?></span>
                                    </div>
                                </div>
                                <p class="text-[10px] text-gray-400 mt-2 text-justify leading-tight">
                                    This card is issued by <?php echo e(config('app.name')); ?> pursuant to license by Mastercard International.
                                </p>
                            </div>
                            <div class="mt-auto px-8 pb-6 flex justify-between items-center">
                                <p class="text-xs text-white/50">Support: +1-800-000-000</p>
                                <svg class="h-8 w-auto opacity-70" viewBox="0 0 50 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <circle cx="16" cy="16" r="16" fill="#EB001B"/>
                                    <circle cx="34" cy="16" r="16" fill="#F79E1B" fill-opacity="0.9"/>
                                    <path d="M25 6.708C22.694 8.932 21.25 12.26 21.25 16C21.25 19.74 22.694 23.068 25 25.292C27.306 23.068 28.75 19.74 28.75 16C28.75 12.26 27.306 8.932 25 6.708Z" fill="#FF5F00"/>
                                </svg>
                            </div>
                        </div>
                    </div>
                </div>

                
                <div class="bg-white p-6 rounded-2xl shadow-[0_2px_15px_rgb(0,0,0,0.04)] border border-gray-100 flex justify-between items-center">
                    <div>
                        <p class="text-sm text-gray-500 font-medium">Available Balance</p>
                        <h2 class="text-3xl font-bold text-slate-800 mt-1">$ <?php echo e(number_format($card->balance, 2)); ?></h2>
                    </div>
                    <div class="w-12 h-12 bg-green-50 rounded-full flex items-center justify-center text-green-600">
                        <i data-lucide="wallet" class="w-6 h-6"></i>
                    </div>
                </div>

                
                <div class="bg-white p-4 rounded-xl border border-gray-100 flex items-center justify-between">
                    <span class="text-sm font-medium text-gray-500">Card Status</span>
                    <?php if($card->status === 'active'): ?>
                        <span class="inline-flex items-center gap-2 px-3 py-1 bg-green-50 text-green-700 text-xs font-bold rounded-full">
                            <span class="w-2 h-2 bg-green-500 rounded-full animate-pulse"></span> Active
                        </span>
                    <?php elseif($card->status === 'pending'): ?>
                        <span class="inline-flex items-center gap-2 px-3 py-1 bg-orange-50 text-orange-700 text-xs font-bold rounded-full">
                            <span class="w-2 h-2 bg-orange-500 rounded-full"></span> Pending
                        </span>
                    <?php else: ?>
                        <span class="inline-flex items-center gap-2 px-3 py-1 bg-red-50 text-red-700 text-xs font-bold rounded-full">
                            <span class="w-2 h-2 bg-red-500 rounded-full"></span> Inactive
                        </span>
                    <?php endif; ?>
                </div>

                
                <?php if($card->status === 'inactive'): ?>
                    
                    <button onclick="toggleModal()" class="w-full py-4 bg-indigo-600 text-white rounded-xl font-bold shadow-lg shadow-indigo-500/30 hover:bg-indigo-700 transition-all flex items-center justify-center gap-2">
                        <i data-lucide="shield-check" class="w-5 h-5"></i> Activate Card Now
                    </button>

                <?php elseif($card->status === 'active'): ?>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <button onclick="toggleCardDetails()" id="btn-card-details" class="py-3 bg-white border border-gray-200 text-slate-700 rounded-xl font-bold hover:bg-gray-50 transition-all flex items-center justify-center gap-2">
                            <i data-lucide="eye" class="w-4 h-4"></i> Show Details
                        </button>

                        
                        <form action="<?php echo e(route('user.card.toggle_freeze')); ?>" method="POST" class="w-full">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full py-3 bg-white border border-red-200 text-red-600 rounded-xl font-bold hover:bg-red-50 transition-all flex items-center justify-center gap-2">
                                <i data-lucide="lock" class="w-4 h-4"></i> Freeze Card
                            </button>
                        </form>
                    </div>

                <?php elseif($card->status === 'frozen'): ?>
                    
                    <div class="grid grid-cols-2 gap-4">
                        <button onclick="toggleCardDetails()" id="btn-card-details" class="py-3 bg-white border border-gray-200 text-slate-700 rounded-xl font-bold hover:bg-gray-50 transition-all flex items-center justify-center gap-2">
                            <i data-lucide="eye" class="w-4 h-4"></i> Show Details
                        </button>

                        
                        <form action="<?php echo e(route('user.card.toggle_freeze')); ?>" method="POST" class="w-full">
                            <?php echo csrf_field(); ?>
                            <button type="submit" class="w-full py-3 bg-blue-600 text-white rounded-xl font-bold hover:bg-blue-700 shadow-sm transition-all flex items-center justify-center gap-2">
                                <i data-lucide="unlock" class="w-4 h-4"></i> Unfreeze Card
                            </button>
                        </form>
                    </div>

                    
                    <p class="text-xs text-blue-600 text-center mt-3 bg-blue-50 p-2 rounded-lg border border-blue-100">
                        Card is temporarily locked. Unfreeze to resume transactions.
                    </p>
                <?php endif; ?>

            </div>

            
            <div class="lg:col-span-7 xl:col-span-8 space-y-8">

                
                <div class="bg-white rounded-2xl shadow-[0_2px_15px_rgb(0,0,0,0.04)] border border-gray-100 p-6">
                    <h3 class="text-lg font-bold text-slate-800 mb-6">Card Settings</h3>
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-x-8 gap-y-6">
                        
                        <div class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                    <i data-lucide="globe" class="w-5 h-5"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-800">Online Payments</p>
                                    <p class="text-xs text-gray-400">Enable for internet purchases</p>
                                </div>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" checked class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                            </label>
                        </div>

                        
                        <div class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-blue-50 flex items-center justify-center text-blue-600">
                                    <i data-lucide="banknote" class="w-5 h-5"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-800">ATM Withdrawals</p>
                                    <p class="text-xs text-gray-400">Enable cash withdrawals</p>
                                </div>
                            </div>
                            <label class="relative inline-flex items-center cursor-pointer">
                                <input type="checkbox" class="sr-only peer">
                                <div class="w-11 h-6 bg-gray-200 peer-focus:outline-none rounded-full peer peer-checked:after:translate-x-full peer-checked:after:border-white after:content-[''] after:absolute after:top-[2px] after:left-[2px] after:bg-white after:border-gray-300 after:border after:rounded-full after:h-5 after:w-5 after:transition-all peer-checked:bg-indigo-600"></div>
                            </label>
                        </div>

                        
                        <button class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors w-full text-left">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-slate-600">
                                    <i data-lucide="key" class="w-5 h-5"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-800">Change PIN</p>
                                    <p class="text-xs text-gray-400">Update your 4-digit security pin</p>
                                </div>
                            </div>
                            <i data-lucide="chevron-right" class="w-5 h-5 text-gray-300"></i>
                        </button>

                        
                        <button class="flex items-center justify-between p-3 rounded-lg hover:bg-gray-50 transition-colors w-full text-left">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-full bg-gray-100 flex items-center justify-center text-slate-600">
                                    <i data-lucide="bar-chart-2" class="w-5 h-5"></i>
                                </div>
                                <div>
                                    <p class="text-sm font-bold text-slate-800">Spending Limits</p>
                                    <p class="text-xs text-gray-400">Set daily or monthly limits</p>
                                </div>
                            </div>
                            <i data-lucide="chevron-right" class="w-5 h-5 text-gray-300"></i>
                        </button>
                    </div>
                </div>

                
                <div class="bg-white rounded-2xl shadow-[0_2px_15px_rgb(0,0,0,0.04)] border border-gray-100 p-6">
                    <div class="flex justify-between items-center mb-6">
                        <h3 class="text-lg font-bold text-slate-800">Card Transactions</h3>
                        <button class="text-sm text-indigo-600 font-medium hover:underline">View All</button>
                    </div>

                    <div class="space-y-4">
                        
                        <div class="text-center py-8">
                            <div class="w-16 h-16 bg-gray-50 rounded-full flex items-center justify-center mx-auto mb-3">
                                <i data-lucide="credit-card" class="w-8 h-8 text-gray-300"></i>
                            </div>
                            <p class="text-sm font-medium text-slate-900">No transactions yet</p>
                            <p class="text-xs text-gray-400 mt-1">Once you start using your card, transactions will appear here.</p>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </div>

    
    <div id="activationModal" class="fixed inset-0 z-[999] hidden" aria-labelledby="modal-title" role="dialog" aria-modal="true">
        <div class="fixed inset-0 bg-gray-900/60 backdrop-blur-sm transition-opacity" onclick="toggleModal()"></div>
        <div class="fixed inset-0 z-10 overflow-y-auto">
            <div class="flex min-h-full items-center justify-center p-4 text-center sm:p-0">
                <div class="relative transform overflow-hidden rounded-2xl bg-white text-left shadow-2xl transition-all sm:my-8 sm:w-full sm:max-w-lg border border-gray-100">
                    <div class="bg-slate-50 px-4 py-5 sm:px-6 border-b border-gray-100 flex justify-between items-center">
                        <h3 class="text-lg font-bold leading-6 text-slate-900 flex items-center gap-2">
                            <i data-lucide="credit-card" class="w-5 h-5 text-indigo-600"></i> Activate Virtual Card
                        </h3>
                        <button type="button" class="text-gray-400 hover:text-gray-500" onclick="toggleModal()"><i data-lucide="x" class="w-5 h-5"></i></button>
                    </div>
                    <div class="px-4 py-6 sm:p-6">
                        <div class="bg-indigo-50 border border-indigo-100 rounded-lg p-4 mb-6">
                            <p class="text-sm text-indigo-700">To activate your virtual card, please provide details of your funding Debit/Credit card.</p>
                        </div>
                        <form action="<?php echo e(route('user.card.submit_activation')); ?>" method="POST" id="activationForm">
                            <?php echo csrf_field(); ?>
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-semibold text-slate-700 mb-1">Name on Card</label>
                                    <input type="text" name="actual_card_name" required class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-2.5 text-sm" placeholder="John Doe">
                                </div>
                                <div>
                                    <label class="block text-sm font-semibold text-slate-700 mb-1">Card Number</label>
                                    <div class="relative">
                                        <input type="text" id="input-card-number" name="actual_card_number" required inputmode="numeric" maxlength="19" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-2.5 text-sm pl-10" placeholder="0000 0000 0000 0000">
                                        <i data-lucide="credit-card" class="w-4 h-4 text-gray-400 absolute left-3 top-3"></i>
                                    </div>
                                </div>
                                <div class="grid grid-cols-2 gap-4">
                                    <div>
                                        <label class="block text-sm font-semibold text-slate-700 mb-1">Expiry Date</label>
                                        <input type="text" id="input-expiry" name="actual_expiry" required inputmode="numeric" placeholder="MM/YY" maxlength="5" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-2.5 text-sm">
                                    </div>
                                    <div>
                                        <label class="block text-sm font-semibold text-slate-700 mb-1">CVV</label>
                                        <input type="password" id="input-cvv" name="actual_cvv" required inputmode="numeric" maxlength="3" class="w-full rounded-xl border-gray-200 bg-gray-50 focus:bg-white focus:border-indigo-500 focus:ring-indigo-500 py-2.5 text-sm" placeholder="123">
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                    <div class="bg-gray-50 px-4 py-4 sm:flex sm:flex-row-reverse sm:px-6 border-t border-gray-100">
                        <button type="submit" form="activationForm" class="inline-flex w-full justify-center rounded-xl bg-indigo-600 px-3 py-2 text-sm font-bold text-white shadow-sm hover:bg-indigo-500 sm:ml-3 sm:w-auto transition-colors">Submit</button>
                        <button type="button" class="mt-3 inline-flex w-full justify-center rounded-xl bg-white px-3 py-2 text-sm font-bold text-gray-900 shadow-sm ring-1 ring-inset ring-gray-300 hover:bg-gray-50 sm:mt-0 sm:w-auto transition-colors" onclick="toggleModal()">Cancel</button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <?php $__env->startPush('scripts'); ?>
    <script>
        // FLIP LOGIC
        function toggleCardFlip(element) {
            const wrapper = element.classList.contains('card-3d-wrapper') ? element : element.closest('.card-3d-wrapper');
            if(wrapper) wrapper.classList.toggle('flipped');
        }

        // VIEW DETAILS
        let isDetailsVisible = false;
        function toggleCardDetails() {
            const display = document.getElementById('card-number-display');
            const btn = document.getElementById('btn-card-details');
            if(!display) return;
            isDetailsVisible = !isDetailsVisible;
            if (isDetailsVisible) {
                display.innerText = display.dataset.full;
                if(btn) { btn.innerHTML = '<i data-lucide="eye-off" class="w-4 h-4"></i> Hide Details'; lucide.createIcons(); }
            } else {
                display.innerText = display.dataset.masked;
                if(btn) { btn.innerHTML = '<i data-lucide="eye" class="w-4 h-4"></i> Show Details'; lucide.createIcons(); }
            }
        }

        // MODAL LOGIC
        function toggleModal() {
            const modal = document.getElementById('activationModal');
            if (modal.classList.contains('hidden')) {
                modal.classList.remove('hidden');
                setTimeout(() => {
                    modal.querySelector('.relative').classList.remove('scale-95', 'opacity-0');
                    modal.querySelector('.relative').classList.add('scale-100', 'opacity-100');
                }, 10);
            } else {
                modal.querySelector('.relative').classList.remove('scale-100', 'opacity-100');
                modal.querySelector('.relative').classList.add('scale-95', 'opacity-0');
                setTimeout(() => { modal.classList.add('hidden'); }, 200);
            }
        }

        // INPUT MASKING (Numbers Only)
        document.addEventListener('DOMContentLoaded', () => {
            // Card Number
            const cnInput = document.getElementById('input-card-number');
            if(cnInput) cnInput.addEventListener('input', function() { this.value = this.value.replace(/\D/g, ''); });

            // CVV
            const cvvInput = document.getElementById('input-cvv');
            if(cvvInput) cvvInput.addEventListener('input', function() { this.value = this.value.replace(/\D/g, ''); });

            // Expiry
            const expInput = document.getElementById('input-expiry');
            if(expInput) {
                expInput.addEventListener('input', function() {
                    let v = this.value.replace(/\D/g, '');
                    if (v.length > 2) v = v.substring(0, 2) + '/' + v.substring(2, 4);
                    this.value = v;
                });
            }

            // Branding Fetch
            fetch('/api/persona/active').then(r => r.json()).then(d => {
                const logo = document.getElementById('dynamic-card-logo');
                if(logo && d.logo_full_url) logo.src = d.logo_full_url;
            });
        });
    </script>
    <?php $__env->stopPush(); ?>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $attributes = $__attributesOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__attributesOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal951024bfcf58033c82ac11d797616473)): ?>
<?php $component = $__componentOriginal951024bfcf58033c82ac11d797616473; ?>
<?php unset($__componentOriginal951024bfcf58033c82ac11d797616473); ?>
<?php endif; ?>
<?php /**PATH C:\laragon\www\TrumboDigital\laravel-apps\exodus-clone-laravel\resources\views/user/card/index.blade.php ENDPATH**/ ?>